/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about each OpenSearch Serverless collection, including the collection endpoint, the OpenSearch Dashboards
 * endpoint, and FIPS-compliant endpoints for federal government workloads.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollectionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<CollectionDetail.Builder, CollectionDetail> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CollectionDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CollectionDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CollectionDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CollectionDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CollectionDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CollectionDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(CollectionDetail::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> STANDBY_REPLICAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("standbyReplicas").getter(getter(CollectionDetail::standbyReplicasAsString))
            .setter(setter(Builder::standbyReplicas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standbyReplicas").build()).build();

    private static final SdkField<Long> CREATED_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createdDate").getter(getter(CollectionDetail::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedDate").getter(getter(CollectionDetail::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<String> COLLECTION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collectionEndpoint").getter(getter(CollectionDetail::collectionEndpoint))
            .setter(setter(Builder::collectionEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionEndpoint").build())
            .build();

    private static final SdkField<String> DASHBOARD_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardEndpoint").getter(getter(CollectionDetail::dashboardEndpoint))
            .setter(setter(Builder::dashboardEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardEndpoint").build()).build();

    private static final SdkField<FipsEndpoints> FIPS_ENDPOINTS_FIELD = SdkField
            .<FipsEndpoints> builder(MarshallingType.SDK_POJO).memberName("fipsEndpoints")
            .getter(getter(CollectionDetail::fipsEndpoints)).setter(setter(Builder::fipsEndpoints))
            .constructor(FipsEndpoints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fipsEndpoints").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(CollectionDetail::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(CollectionDetail::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            STATUS_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, ARN_FIELD, KMS_KEY_ARN_FIELD, STANDBY_REPLICAS_FIELD,
            CREATED_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, COLLECTION_ENDPOINT_FIELD, DASHBOARD_ENDPOINT_FIELD,
            FIPS_ENDPOINTS_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String status;

    private final String type;

    private final String description;

    private final String arn;

    private final String kmsKeyArn;

    private final String standbyReplicas;

    private final Long createdDate;

    private final Long lastModifiedDate;

    private final String collectionEndpoint;

    private final String dashboardEndpoint;

    private final FipsEndpoints fipsEndpoints;

    private final String failureCode;

    private final String failureMessage;

    private CollectionDetail(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.type = builder.type;
        this.description = builder.description;
        this.arn = builder.arn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.standbyReplicas = builder.standbyReplicas;
        this.createdDate = builder.createdDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.collectionEndpoint = builder.collectionEndpoint;
        this.dashboardEndpoint = builder.dashboardEndpoint;
        this.fipsEndpoints = builder.fipsEndpoints;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * A unique identifier for the collection.
     * </p>
     * 
     * @return A unique identifier for the collection.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the collection.
     * </p>
     * 
     * @return The name of the collection.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CollectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the collection.
     * @see CollectionStatus
     */
    public final CollectionStatus status() {
        return CollectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CollectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the collection.
     * @see CollectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of collection.
     * @see CollectionType
     */
    public final CollectionType type() {
        return CollectionType.fromValue(type);
    }

    /**
     * <p>
     * The type of collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of collection.
     * @see CollectionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A description of the collection.
     * </p>
     * 
     * @return A description of the collection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the collection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the collection.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of the Amazon Web Services KMS key used to encrypt the collection.
     * </p>
     * 
     * @return The ARN of the Amazon Web Services KMS key used to encrypt the collection.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * Details about an OpenSearch Serverless collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #standbyReplicas}
     * will return {@link StandbyReplicas#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #standbyReplicasAsString}.
     * </p>
     * 
     * @return Details about an OpenSearch Serverless collection.
     * @see StandbyReplicas
     */
    public final StandbyReplicas standbyReplicas() {
        return StandbyReplicas.fromValue(standbyReplicas);
    }

    /**
     * <p>
     * Details about an OpenSearch Serverless collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #standbyReplicas}
     * will return {@link StandbyReplicas#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #standbyReplicasAsString}.
     * </p>
     * 
     * @return Details about an OpenSearch Serverless collection.
     * @see StandbyReplicas
     */
    public final String standbyReplicasAsString() {
        return standbyReplicas;
    }

    /**
     * <p>
     * The Epoch time when the collection was created.
     * </p>
     * 
     * @return The Epoch time when the collection was created.
     */
    public final Long createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date and time when the collection was last modified.
     * </p>
     * 
     * @return The date and time when the collection was last modified.
     */
    public final Long lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * Collection-specific endpoint used to submit index, search, and data upload requests to an OpenSearch Serverless
     * collection.
     * </p>
     * 
     * @return Collection-specific endpoint used to submit index, search, and data upload requests to an OpenSearch
     *         Serverless collection.
     */
    public final String collectionEndpoint() {
        return collectionEndpoint;
    }

    /**
     * <p>
     * Collection-specific endpoint used to access OpenSearch Dashboards.
     * </p>
     * 
     * @return Collection-specific endpoint used to access OpenSearch Dashboards.
     */
    public final String dashboardEndpoint() {
        return dashboardEndpoint;
    }

    /**
     * <p>
     * FIPS-compliant endpoints for the collection. These endpoints use FIPS 140-3 validated cryptographic modules and
     * are required for federal government workloads that must comply with FedRAMP security standards.
     * </p>
     * 
     * @return FIPS-compliant endpoints for the collection. These endpoints use FIPS 140-3 validated cryptographic
     *         modules and are required for federal government workloads that must comply with FedRAMP security
     *         standards.
     */
    public final FipsEndpoints fipsEndpoints() {
        return fipsEndpoints;
    }

    /**
     * <p>
     * A failure code associated with the request.
     * </p>
     * 
     * @return A failure code associated with the request.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * A message associated with the failure code.
     * </p>
     * 
     * @return A message associated with the failure code.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(standbyReplicasAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(collectionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(fipsEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionDetail)) {
            return false;
        }
        CollectionDetail other = (CollectionDetail) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(arn(), other.arn()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(standbyReplicasAsString(), other.standbyReplicasAsString())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(collectionEndpoint(), other.collectionEndpoint())
                && Objects.equals(dashboardEndpoint(), other.dashboardEndpoint())
                && Objects.equals(fipsEndpoints(), other.fipsEndpoints()) && Objects.equals(failureCode(), other.failureCode())
                && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollectionDetail").add("Id", id()).add("Name", name()).add("Status", statusAsString())
                .add("Type", typeAsString()).add("Description", description()).add("Arn", arn()).add("KmsKeyArn", kmsKeyArn())
                .add("StandbyReplicas", standbyReplicasAsString()).add("CreatedDate", createdDate())
                .add("LastModifiedDate", lastModifiedDate()).add("CollectionEndpoint", collectionEndpoint())
                .add("DashboardEndpoint", dashboardEndpoint()).add("FipsEndpoints", fipsEndpoints())
                .add("FailureCode", failureCode()).add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "standbyReplicas":
            return Optional.ofNullable(clazz.cast(standbyReplicasAsString()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "collectionEndpoint":
            return Optional.ofNullable(clazz.cast(collectionEndpoint()));
        case "dashboardEndpoint":
            return Optional.ofNullable(clazz.cast(dashboardEndpoint()));
        case "fipsEndpoints":
            return Optional.ofNullable(clazz.cast(fipsEndpoints()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("standbyReplicas", STANDBY_REPLICAS_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("collectionEndpoint", COLLECTION_ENDPOINT_FIELD);
        map.put("dashboardEndpoint", DASHBOARD_ENDPOINT_FIELD);
        map.put("fipsEndpoints", FIPS_ENDPOINTS_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollectionDetail, T> g) {
        return obj -> g.apply((CollectionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollectionDetail> {
        /**
         * <p>
         * A unique identifier for the collection.
         * </p>
         * 
         * @param id
         *        A unique identifier for the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the collection.
         * </p>
         * 
         * @param name
         *        The name of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the collection.
         * </p>
         * 
         * @param status
         *        The current status of the collection.
         * @see CollectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the collection.
         * </p>
         * 
         * @param status
         *        The current status of the collection.
         * @see CollectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectionStatus
         */
        Builder status(CollectionStatus status);

        /**
         * <p>
         * The type of collection.
         * </p>
         * 
         * @param type
         *        The type of collection.
         * @see CollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of collection.
         * </p>
         * 
         * @param type
         *        The type of collection.
         * @see CollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectionType
         */
        Builder type(CollectionType type);

        /**
         * <p>
         * A description of the collection.
         * </p>
         * 
         * @param description
         *        A description of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the collection.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of the Amazon Web Services KMS key used to encrypt the collection.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the Amazon Web Services KMS key used to encrypt the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * Details about an OpenSearch Serverless collection.
         * </p>
         * 
         * @param standbyReplicas
         *        Details about an OpenSearch Serverless collection.
         * @see StandbyReplicas
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandbyReplicas
         */
        Builder standbyReplicas(String standbyReplicas);

        /**
         * <p>
         * Details about an OpenSearch Serverless collection.
         * </p>
         * 
         * @param standbyReplicas
         *        Details about an OpenSearch Serverless collection.
         * @see StandbyReplicas
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandbyReplicas
         */
        Builder standbyReplicas(StandbyReplicas standbyReplicas);

        /**
         * <p>
         * The Epoch time when the collection was created.
         * </p>
         * 
         * @param createdDate
         *        The Epoch time when the collection was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Long createdDate);

        /**
         * <p>
         * The date and time when the collection was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time when the collection was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Long lastModifiedDate);

        /**
         * <p>
         * Collection-specific endpoint used to submit index, search, and data upload requests to an OpenSearch
         * Serverless collection.
         * </p>
         * 
         * @param collectionEndpoint
         *        Collection-specific endpoint used to submit index, search, and data upload requests to an OpenSearch
         *        Serverless collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionEndpoint(String collectionEndpoint);

        /**
         * <p>
         * Collection-specific endpoint used to access OpenSearch Dashboards.
         * </p>
         * 
         * @param dashboardEndpoint
         *        Collection-specific endpoint used to access OpenSearch Dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardEndpoint(String dashboardEndpoint);

        /**
         * <p>
         * FIPS-compliant endpoints for the collection. These endpoints use FIPS 140-3 validated cryptographic modules
         * and are required for federal government workloads that must comply with FedRAMP security standards.
         * </p>
         * 
         * @param fipsEndpoints
         *        FIPS-compliant endpoints for the collection. These endpoints use FIPS 140-3 validated cryptographic
         *        modules and are required for federal government workloads that must comply with FedRAMP security
         *        standards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fipsEndpoints(FipsEndpoints fipsEndpoints);

        /**
         * <p>
         * FIPS-compliant endpoints for the collection. These endpoints use FIPS 140-3 validated cryptographic modules
         * and are required for federal government workloads that must comply with FedRAMP security standards.
         * </p>
         * This is a convenience method that creates an instance of the {@link FipsEndpoints.Builder} avoiding the need
         * to create one manually via {@link FipsEndpoints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FipsEndpoints.Builder#build()} is called immediately and its
         * result is passed to {@link #fipsEndpoints(FipsEndpoints)}.
         * 
         * @param fipsEndpoints
         *        a consumer that will call methods on {@link FipsEndpoints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fipsEndpoints(FipsEndpoints)
         */
        default Builder fipsEndpoints(Consumer<FipsEndpoints.Builder> fipsEndpoints) {
            return fipsEndpoints(FipsEndpoints.builder().applyMutation(fipsEndpoints).build());
        }

        /**
         * <p>
         * A failure code associated with the request.
         * </p>
         * 
         * @param failureCode
         *        A failure code associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * A message associated with the failure code.
         * </p>
         * 
         * @param failureMessage
         *        A message associated with the failure code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String status;

        private String type;

        private String description;

        private String arn;

        private String kmsKeyArn;

        private String standbyReplicas;

        private Long createdDate;

        private Long lastModifiedDate;

        private String collectionEndpoint;

        private String dashboardEndpoint;

        private FipsEndpoints fipsEndpoints;

        private String failureCode;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CollectionDetail model) {
            id(model.id);
            name(model.name);
            status(model.status);
            type(model.type);
            description(model.description);
            arn(model.arn);
            kmsKeyArn(model.kmsKeyArn);
            standbyReplicas(model.standbyReplicas);
            createdDate(model.createdDate);
            lastModifiedDate(model.lastModifiedDate);
            collectionEndpoint(model.collectionEndpoint);
            dashboardEndpoint(model.dashboardEndpoint);
            fipsEndpoints(model.fipsEndpoints);
            failureCode(model.failureCode);
            failureMessage(model.failureMessage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CollectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CollectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getStandbyReplicas() {
            return standbyReplicas;
        }

        public final void setStandbyReplicas(String standbyReplicas) {
            this.standbyReplicas = standbyReplicas;
        }

        @Override
        public final Builder standbyReplicas(String standbyReplicas) {
            this.standbyReplicas = standbyReplicas;
            return this;
        }

        @Override
        public final Builder standbyReplicas(StandbyReplicas standbyReplicas) {
            this.standbyReplicas(standbyReplicas == null ? null : standbyReplicas.toString());
            return this;
        }

        public final Long getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Long createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Long getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getCollectionEndpoint() {
            return collectionEndpoint;
        }

        public final void setCollectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
        }

        @Override
        public final Builder collectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
            return this;
        }

        public final String getDashboardEndpoint() {
            return dashboardEndpoint;
        }

        public final void setDashboardEndpoint(String dashboardEndpoint) {
            this.dashboardEndpoint = dashboardEndpoint;
        }

        @Override
        public final Builder dashboardEndpoint(String dashboardEndpoint) {
            this.dashboardEndpoint = dashboardEndpoint;
            return this;
        }

        public final FipsEndpoints.Builder getFipsEndpoints() {
            return fipsEndpoints != null ? fipsEndpoints.toBuilder() : null;
        }

        public final void setFipsEndpoints(FipsEndpoints.BuilderImpl fipsEndpoints) {
            this.fipsEndpoints = fipsEndpoints != null ? fipsEndpoints.build() : null;
        }

        @Override
        public final Builder fipsEndpoints(FipsEndpoints fipsEndpoints) {
            this.fipsEndpoints = fipsEndpoints;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public CollectionDetail build() {
            return new CollectionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
