/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCollectionResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<CreateCollectionResponse.Builder, CreateCollectionResponse> {
    private static final SdkField<CreateCollectionDetail> CREATE_COLLECTION_DETAIL_FIELD = SdkField
            .<CreateCollectionDetail> builder(MarshallingType.SDK_POJO).memberName("createCollectionDetail")
            .getter(getter(CreateCollectionResponse::createCollectionDetail)).setter(setter(Builder::createCollectionDetail))
            .constructor(CreateCollectionDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createCollectionDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CREATE_COLLECTION_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CreateCollectionDetail createCollectionDetail;

    private CreateCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.createCollectionDetail = builder.createCollectionDetail;
    }

    /**
     * <p>
     * Details about the collection.
     * </p>
     * 
     * @return Details about the collection.
     */
    public final CreateCollectionDetail createCollectionDetail() {
        return createCollectionDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createCollectionDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollectionResponse)) {
            return false;
        }
        CreateCollectionResponse other = (CreateCollectionResponse) obj;
        return Objects.equals(createCollectionDetail(), other.createCollectionDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCollectionResponse").add("CreateCollectionDetail", createCollectionDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createCollectionDetail":
            return Optional.ofNullable(clazz.cast(createCollectionDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createCollectionDetail", CREATE_COLLECTION_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCollectionResponse, T> g) {
        return obj -> g.apply((CreateCollectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCollectionResponse> {
        /**
         * <p>
         * Details about the collection.
         * </p>
         * 
         * @param createCollectionDetail
         *        Details about the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createCollectionDetail(CreateCollectionDetail createCollectionDetail);

        /**
         * <p>
         * Details about the collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateCollectionDetail.Builder} avoiding
         * the need to create one manually via {@link CreateCollectionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateCollectionDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #createCollectionDetail(CreateCollectionDetail)}.
         * 
         * @param createCollectionDetail
         *        a consumer that will call methods on {@link CreateCollectionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createCollectionDetail(CreateCollectionDetail)
         */
        default Builder createCollectionDetail(Consumer<CreateCollectionDetail.Builder> createCollectionDetail) {
            return createCollectionDetail(CreateCollectionDetail.builder().applyMutation(createCollectionDetail).build());
        }
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private CreateCollectionDetail createCollectionDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollectionResponse model) {
            super(model);
            createCollectionDetail(model.createCollectionDetail);
        }

        public final CreateCollectionDetail.Builder getCreateCollectionDetail() {
            return createCollectionDetail != null ? createCollectionDetail.toBuilder() : null;
        }

        public final void setCreateCollectionDetail(CreateCollectionDetail.BuilderImpl createCollectionDetail) {
            this.createCollectionDetail = createCollectionDetail != null ? createCollectionDetail.build() : null;
        }

        @Override
        public final Builder createCollectionDetail(CreateCollectionDetail createCollectionDetail) {
            this.createCollectionDetail = createCollectionDetail;
            return this;
        }

        @Override
        public CreateCollectionResponse build() {
            return new CreateCollectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
