/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcEndpointResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<CreateVpcEndpointResponse.Builder, CreateVpcEndpointResponse> {
    private static final SdkField<CreateVpcEndpointDetail> CREATE_VPC_ENDPOINT_DETAIL_FIELD = SdkField
            .<CreateVpcEndpointDetail> builder(MarshallingType.SDK_POJO).memberName("createVpcEndpointDetail")
            .getter(getter(CreateVpcEndpointResponse::createVpcEndpointDetail)).setter(setter(Builder::createVpcEndpointDetail))
            .constructor(CreateVpcEndpointDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVpcEndpointDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CREATE_VPC_ENDPOINT_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CreateVpcEndpointDetail createVpcEndpointDetail;

    private CreateVpcEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.createVpcEndpointDetail = builder.createVpcEndpointDetail;
    }

    /**
     * <p>
     * Details about the created interface VPC endpoint.
     * </p>
     * 
     * @return Details about the created interface VPC endpoint.
     */
    public final CreateVpcEndpointDetail createVpcEndpointDetail() {
        return createVpcEndpointDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createVpcEndpointDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointResponse)) {
            return false;
        }
        CreateVpcEndpointResponse other = (CreateVpcEndpointResponse) obj;
        return Objects.equals(createVpcEndpointDetail(), other.createVpcEndpointDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcEndpointResponse").add("CreateVpcEndpointDetail", createVpcEndpointDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createVpcEndpointDetail":
            return Optional.ofNullable(clazz.cast(createVpcEndpointDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createVpcEndpointDetail", CREATE_VPC_ENDPOINT_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointResponse, T> g) {
        return obj -> g.apply((CreateVpcEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcEndpointResponse> {
        /**
         * <p>
         * Details about the created interface VPC endpoint.
         * </p>
         * 
         * @param createVpcEndpointDetail
         *        Details about the created interface VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVpcEndpointDetail(CreateVpcEndpointDetail createVpcEndpointDetail);

        /**
         * <p>
         * Details about the created interface VPC endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateVpcEndpointDetail.Builder} avoiding
         * the need to create one manually via {@link CreateVpcEndpointDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateVpcEndpointDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #createVpcEndpointDetail(CreateVpcEndpointDetail)}.
         * 
         * @param createVpcEndpointDetail
         *        a consumer that will call methods on {@link CreateVpcEndpointDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createVpcEndpointDetail(CreateVpcEndpointDetail)
         */
        default Builder createVpcEndpointDetail(Consumer<CreateVpcEndpointDetail.Builder> createVpcEndpointDetail) {
            return createVpcEndpointDetail(CreateVpcEndpointDetail.builder().applyMutation(createVpcEndpointDetail).build());
        }
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private CreateVpcEndpointDetail createVpcEndpointDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointResponse model) {
            super(model);
            createVpcEndpointDetail(model.createVpcEndpointDetail);
        }

        public final CreateVpcEndpointDetail.Builder getCreateVpcEndpointDetail() {
            return createVpcEndpointDetail != null ? createVpcEndpointDetail.toBuilder() : null;
        }

        public final void setCreateVpcEndpointDetail(CreateVpcEndpointDetail.BuilderImpl createVpcEndpointDetail) {
            this.createVpcEndpointDetail = createVpcEndpointDetail != null ? createVpcEndpointDetail.build() : null;
        }

        @Override
        public final Builder createVpcEndpointDetail(CreateVpcEndpointDetail createVpcEndpointDetail) {
            this.createVpcEndpointDetail = createVpcEndpointDetail;
            return this;
        }

        @Override
        public CreateVpcEndpointResponse build() {
            return new CreateVpcEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
