/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * FIPS-compliant endpoint URLs for an OpenSearch Serverless collection. These endpoints ensure all data transmission
 * uses FIPS 140-3 validated cryptographic implementations, meeting federal security requirements for government
 * workloads.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FipsEndpoints implements SdkPojo, Serializable, ToCopyableBuilder<FipsEndpoints.Builder, FipsEndpoints> {
    private static final SdkField<String> COLLECTION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collectionEndpoint").getter(getter(FipsEndpoints::collectionEndpoint))
            .setter(setter(Builder::collectionEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionEndpoint").build())
            .build();

    private static final SdkField<String> DASHBOARD_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardEndpoint").getter(getter(FipsEndpoints::dashboardEndpoint))
            .setter(setter(Builder::dashboardEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ENDPOINT_FIELD,
            DASHBOARD_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String collectionEndpoint;

    private final String dashboardEndpoint;

    private FipsEndpoints(BuilderImpl builder) {
        this.collectionEndpoint = builder.collectionEndpoint;
        this.dashboardEndpoint = builder.dashboardEndpoint;
    }

    /**
     * <p>
     * FIPS-compliant collection endpoint used to submit index, search, and data upload requests to an OpenSearch
     * Serverless collection. This endpoint uses FIPS 140-3 validated cryptography and is required for federal
     * government workloads.
     * </p>
     * 
     * @return FIPS-compliant collection endpoint used to submit index, search, and data upload requests to an
     *         OpenSearch Serverless collection. This endpoint uses FIPS 140-3 validated cryptography and is required
     *         for federal government workloads.
     */
    public final String collectionEndpoint() {
        return collectionEndpoint;
    }

    /**
     * <p>
     * FIPS-compliant endpoint used to access OpenSearch Dashboards. This endpoint uses FIPS 140-3 validated
     * cryptography and is required for federal government workloads that need dashboard visualization capabilities.
     * </p>
     * 
     * @return FIPS-compliant endpoint used to access OpenSearch Dashboards. This endpoint uses FIPS 140-3 validated
     *         cryptography and is required for federal government workloads that need dashboard visualization
     *         capabilities.
     */
    public final String dashboardEndpoint() {
        return dashboardEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FipsEndpoints)) {
            return false;
        }
        FipsEndpoints other = (FipsEndpoints) obj;
        return Objects.equals(collectionEndpoint(), other.collectionEndpoint())
                && Objects.equals(dashboardEndpoint(), other.dashboardEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FipsEndpoints").add("CollectionEndpoint", collectionEndpoint())
                .add("DashboardEndpoint", dashboardEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collectionEndpoint":
            return Optional.ofNullable(clazz.cast(collectionEndpoint()));
        case "dashboardEndpoint":
            return Optional.ofNullable(clazz.cast(dashboardEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collectionEndpoint", COLLECTION_ENDPOINT_FIELD);
        map.put("dashboardEndpoint", DASHBOARD_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FipsEndpoints, T> g) {
        return obj -> g.apply((FipsEndpoints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FipsEndpoints> {
        /**
         * <p>
         * FIPS-compliant collection endpoint used to submit index, search, and data upload requests to an OpenSearch
         * Serverless collection. This endpoint uses FIPS 140-3 validated cryptography and is required for federal
         * government workloads.
         * </p>
         * 
         * @param collectionEndpoint
         *        FIPS-compliant collection endpoint used to submit index, search, and data upload requests to an
         *        OpenSearch Serverless collection. This endpoint uses FIPS 140-3 validated cryptography and is required
         *        for federal government workloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionEndpoint(String collectionEndpoint);

        /**
         * <p>
         * FIPS-compliant endpoint used to access OpenSearch Dashboards. This endpoint uses FIPS 140-3 validated
         * cryptography and is required for federal government workloads that need dashboard visualization capabilities.
         * </p>
         * 
         * @param dashboardEndpoint
         *        FIPS-compliant endpoint used to access OpenSearch Dashboards. This endpoint uses FIPS 140-3 validated
         *        cryptography and is required for federal government workloads that need dashboard visualization
         *        capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardEndpoint(String dashboardEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String collectionEndpoint;

        private String dashboardEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(FipsEndpoints model) {
            collectionEndpoint(model.collectionEndpoint);
            dashboardEndpoint(model.dashboardEndpoint);
        }

        public final String getCollectionEndpoint() {
            return collectionEndpoint;
        }

        public final void setCollectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
        }

        @Override
        public final Builder collectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
            return this;
        }

        public final String getDashboardEndpoint() {
            return dashboardEndpoint;
        }

        public final void setDashboardEndpoint(String dashboardEndpoint) {
            this.dashboardEndpoint = dashboardEndpoint;
        }

        @Override
        public final Builder dashboardEndpoint(String dashboardEndpoint) {
            this.dashboardEndpoint = dashboardEndpoint;
            return this;
        }

        @Override
        public FipsEndpoints build() {
            return new FipsEndpoints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
