/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIndexResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<GetIndexResponse.Builder, GetIndexResponse> {
    private static final SdkField<Document> INDEX_SCHEMA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("indexSchema").getter(getter(GetIndexResponse::indexSchema)).setter(setter(Builder::indexSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Document indexSchema;

    private GetIndexResponse(BuilderImpl builder) {
        super(builder);
        this.indexSchema = builder.indexSchema;
    }

    /**
     * <p>
     * The JSON schema definition for the index, including field mappings and settings.
     * </p>
     * 
     * @return The JSON schema definition for the index, including field mappings and settings.
     */
    public final Document indexSchema() {
        return indexSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIndexResponse)) {
            return false;
        }
        GetIndexResponse other = (GetIndexResponse) obj;
        return Objects.equals(indexSchema(), other.indexSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIndexResponse").add("IndexSchema", indexSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "indexSchema":
            return Optional.ofNullable(clazz.cast(indexSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("indexSchema", INDEX_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIndexResponse, T> g) {
        return obj -> g.apply((GetIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIndexResponse> {
        /**
         * <p>
         * The JSON schema definition for the index, including field mappings and settings.
         * </p>
         * 
         * @param indexSchema
         *        The JSON schema definition for the index, including field mappings and settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexSchema(Document indexSchema);
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private Document indexSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIndexResponse model) {
            super(model);
            indexSchema(model.indexSchema);
        }

        public final Document getIndexSchema() {
            return indexSchema;
        }

        public final void setIndexSchema(Document indexSchema) {
            this.indexSchema = indexSchema;
        }

        @Override
        public final Builder indexSchema(Document indexSchema) {
            this.indexSchema = indexSchema;
            return this;
        }

        @Override
        public GetIndexResponse build() {
            return new GetIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
