/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes IAM federation options for an OpenSearch Serverless security configuration in the form of a key-value map.
 * These options define how OpenSearch Serverless integrates with external identity providers using federation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamFederationConfigOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<IamFederationConfigOptions.Builder, IamFederationConfigOptions> {
    private static final SdkField<String> GROUP_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupAttribute").getter(getter(IamFederationConfigOptions::groupAttribute))
            .setter(setter(Builder::groupAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupAttribute").build()).build();

    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userAttribute").getter(getter(IamFederationConfigOptions::userAttribute))
            .setter(setter(Builder::userAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ATTRIBUTE_FIELD,
            USER_ATTRIBUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupAttribute;

    private final String userAttribute;

    private IamFederationConfigOptions(BuilderImpl builder) {
        this.groupAttribute = builder.groupAttribute;
        this.userAttribute = builder.userAttribute;
    }

    /**
     * <p>
     * The group attribute for this IAM federation integration. This attribute is used to map identity provider groups
     * to OpenSearch Serverless permissions.
     * </p>
     * 
     * @return The group attribute for this IAM federation integration. This attribute is used to map identity provider
     *         groups to OpenSearch Serverless permissions.
     */
    public final String groupAttribute() {
        return groupAttribute;
    }

    /**
     * <p>
     * The user attribute for this IAM federation integration. This attribute is used to identify users in the federated
     * authentication process.
     * </p>
     * 
     * @return The user attribute for this IAM federation integration. This attribute is used to identify users in the
     *         federated authentication process.
     */
    public final String userAttribute() {
        return userAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(userAttribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamFederationConfigOptions)) {
            return false;
        }
        IamFederationConfigOptions other = (IamFederationConfigOptions) obj;
        return Objects.equals(groupAttribute(), other.groupAttribute()) && Objects.equals(userAttribute(), other.userAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamFederationConfigOptions").add("GroupAttribute", groupAttribute())
                .add("UserAttribute", userAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupAttribute":
            return Optional.ofNullable(clazz.cast(groupAttribute()));
        case "userAttribute":
            return Optional.ofNullable(clazz.cast(userAttribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("groupAttribute", GROUP_ATTRIBUTE_FIELD);
        map.put("userAttribute", USER_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamFederationConfigOptions, T> g) {
        return obj -> g.apply((IamFederationConfigOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamFederationConfigOptions> {
        /**
         * <p>
         * The group attribute for this IAM federation integration. This attribute is used to map identity provider
         * groups to OpenSearch Serverless permissions.
         * </p>
         * 
         * @param groupAttribute
         *        The group attribute for this IAM federation integration. This attribute is used to map identity
         *        provider groups to OpenSearch Serverless permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupAttribute(String groupAttribute);

        /**
         * <p>
         * The user attribute for this IAM federation integration. This attribute is used to identify users in the
         * federated authentication process.
         * </p>
         * 
         * @param userAttribute
         *        The user attribute for this IAM federation integration. This attribute is used to identify users in
         *        the federated authentication process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttribute(String userAttribute);
    }

    static final class BuilderImpl implements Builder {
        private String groupAttribute;

        private String userAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(IamFederationConfigOptions model) {
            groupAttribute(model.groupAttribute);
            userAttribute(model.userAttribute);
        }

        public final String getGroupAttribute() {
            return groupAttribute;
        }

        public final void setGroupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
        }

        @Override
        public final Builder groupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
            return this;
        }

        public final String getUserAttribute() {
            return userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        @Override
        public IamFederationConfigOptions build() {
            return new IamFederationConfigOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
