/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccessPolicyResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<UpdateAccessPolicyResponse.Builder, UpdateAccessPolicyResponse> {
    private static final SdkField<AccessPolicyDetail> ACCESS_POLICY_DETAIL_FIELD = SdkField
            .<AccessPolicyDetail> builder(MarshallingType.SDK_POJO).memberName("accessPolicyDetail")
            .getter(getter(UpdateAccessPolicyResponse::accessPolicyDetail)).setter(setter(Builder::accessPolicyDetail))
            .constructor(AccessPolicyDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AccessPolicyDetail accessPolicyDetail;

    private UpdateAccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicyDetail = builder.accessPolicyDetail;
    }

    /**
     * <p>
     * Details about the updated access policy.
     * </p>
     * 
     * @return Details about the updated access policy.
     */
    public final AccessPolicyDetail accessPolicyDetail() {
        return accessPolicyDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessPolicyResponse)) {
            return false;
        }
        UpdateAccessPolicyResponse other = (UpdateAccessPolicyResponse) obj;
        return Objects.equals(accessPolicyDetail(), other.accessPolicyDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccessPolicyResponse").add("AccessPolicyDetail", accessPolicyDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPolicyDetail":
            return Optional.ofNullable(clazz.cast(accessPolicyDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessPolicyDetail", ACCESS_POLICY_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessPolicyResponse, T> g) {
        return obj -> g.apply((UpdateAccessPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccessPolicyResponse> {
        /**
         * <p>
         * Details about the updated access policy.
         * </p>
         * 
         * @param accessPolicyDetail
         *        Details about the updated access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyDetail(AccessPolicyDetail accessPolicyDetail);

        /**
         * <p>
         * Details about the updated access policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessPolicyDetail.Builder} avoiding the
         * need to create one manually via {@link AccessPolicyDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessPolicyDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #accessPolicyDetail(AccessPolicyDetail)}.
         * 
         * @param accessPolicyDetail
         *        a consumer that will call methods on {@link AccessPolicyDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicyDetail(AccessPolicyDetail)
         */
        default Builder accessPolicyDetail(Consumer<AccessPolicyDetail.Builder> accessPolicyDetail) {
            return accessPolicyDetail(AccessPolicyDetail.builder().applyMutation(accessPolicyDetail).build());
        }
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private AccessPolicyDetail accessPolicyDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessPolicyResponse model) {
            super(model);
            accessPolicyDetail(model.accessPolicyDetail);
        }

        public final AccessPolicyDetail.Builder getAccessPolicyDetail() {
            return accessPolicyDetail != null ? accessPolicyDetail.toBuilder() : null;
        }

        public final void setAccessPolicyDetail(AccessPolicyDetail.BuilderImpl accessPolicyDetail) {
            this.accessPolicyDetail = accessPolicyDetail != null ? accessPolicyDetail.build() : null;
        }

        @Override
        public final Builder accessPolicyDetail(AccessPolicyDetail accessPolicyDetail) {
            this.accessPolicyDetail = accessPolicyDetail;
            return this;
        }

        @Override
        public UpdateAccessPolicyResponse build() {
            return new UpdateAccessPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
