/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes IAM Identity Center options for updating an OpenSearch Serverless security configuration in the form of a
 * key-value map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIamIdentityCenterConfigOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateIamIdentityCenterConfigOptions.Builder, UpdateIamIdentityCenterConfigOptions> {
    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userAttribute").getter(getter(UpdateIamIdentityCenterConfigOptions::userAttributeAsString))
            .setter(setter(Builder::userAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()).build();

    private static final SdkField<String> GROUP_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupAttribute").getter(getter(UpdateIamIdentityCenterConfigOptions::groupAttributeAsString))
            .setter(setter(Builder::groupAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupAttribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ATTRIBUTE_FIELD,
            GROUP_ATTRIBUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String userAttribute;

    private final String groupAttribute;

    private UpdateIamIdentityCenterConfigOptions(BuilderImpl builder) {
        this.userAttribute = builder.userAttribute;
        this.groupAttribute = builder.groupAttribute;
    }

    /**
     * <p>
     * The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userAttribute}
     * will return {@link IamIdentityCenterUserAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #userAttributeAsString}.
     * </p>
     * 
     * @return The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>.
     * @see IamIdentityCenterUserAttribute
     */
    public final IamIdentityCenterUserAttribute userAttribute() {
        return IamIdentityCenterUserAttribute.fromValue(userAttribute);
    }

    /**
     * <p>
     * The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userAttribute}
     * will return {@link IamIdentityCenterUserAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #userAttributeAsString}.
     * </p>
     * 
     * @return The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>.
     * @see IamIdentityCenterUserAttribute
     */
    public final String userAttributeAsString() {
        return userAttribute;
    }

    /**
     * <p>
     * The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupAttribute}
     * will return {@link IamIdentityCenterGroupAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #groupAttributeAsString}.
     * </p>
     * 
     * @return The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
     * @see IamIdentityCenterGroupAttribute
     */
    public final IamIdentityCenterGroupAttribute groupAttribute() {
        return IamIdentityCenterGroupAttribute.fromValue(groupAttribute);
    }

    /**
     * <p>
     * The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupAttribute}
     * will return {@link IamIdentityCenterGroupAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #groupAttributeAsString}.
     * </p>
     * 
     * @return The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
     * @see IamIdentityCenterGroupAttribute
     */
    public final String groupAttributeAsString() {
        return groupAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userAttributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupAttributeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIamIdentityCenterConfigOptions)) {
            return false;
        }
        UpdateIamIdentityCenterConfigOptions other = (UpdateIamIdentityCenterConfigOptions) obj;
        return Objects.equals(userAttributeAsString(), other.userAttributeAsString())
                && Objects.equals(groupAttributeAsString(), other.groupAttributeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIamIdentityCenterConfigOptions").add("UserAttribute", userAttributeAsString())
                .add("GroupAttribute", groupAttributeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userAttribute":
            return Optional.ofNullable(clazz.cast(userAttributeAsString()));
        case "groupAttribute":
            return Optional.ofNullable(clazz.cast(groupAttributeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userAttribute", USER_ATTRIBUTE_FIELD);
        map.put("groupAttribute", GROUP_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIamIdentityCenterConfigOptions, T> g) {
        return obj -> g.apply((UpdateIamIdentityCenterConfigOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateIamIdentityCenterConfigOptions> {
        /**
         * <p>
         * The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>.
         * </p>
         * 
         * @param userAttribute
         *        The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>.
         * @see IamIdentityCenterUserAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IamIdentityCenterUserAttribute
         */
        Builder userAttribute(String userAttribute);

        /**
         * <p>
         * The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>.
         * </p>
         * 
         * @param userAttribute
         *        The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>.
         * @see IamIdentityCenterUserAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IamIdentityCenterUserAttribute
         */
        Builder userAttribute(IamIdentityCenterUserAttribute userAttribute);

        /**
         * <p>
         * The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
         * </p>
         * 
         * @param groupAttribute
         *        The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
         * @see IamIdentityCenterGroupAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IamIdentityCenterGroupAttribute
         */
        Builder groupAttribute(String groupAttribute);

        /**
         * <p>
         * The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
         * </p>
         * 
         * @param groupAttribute
         *        The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
         * @see IamIdentityCenterGroupAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IamIdentityCenterGroupAttribute
         */
        Builder groupAttribute(IamIdentityCenterGroupAttribute groupAttribute);
    }

    static final class BuilderImpl implements Builder {
        private String userAttribute;

        private String groupAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIamIdentityCenterConfigOptions model) {
            userAttribute(model.userAttribute);
            groupAttribute(model.groupAttribute);
        }

        public final String getUserAttribute() {
            return userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        @Override
        public final Builder userAttribute(IamIdentityCenterUserAttribute userAttribute) {
            this.userAttribute(userAttribute == null ? null : userAttribute.toString());
            return this;
        }

        public final String getGroupAttribute() {
            return groupAttribute;
        }

        public final void setGroupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
        }

        @Override
        public final Builder groupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
            return this;
        }

        @Override
        public final Builder groupAttribute(IamIdentityCenterGroupAttribute groupAttribute) {
            this.groupAttribute(groupAttribute == null ? null : groupAttribute.toString());
            return this;
        }

        @Override
        public UpdateIamIdentityCenterConfigOptions build() {
            return new UpdateIamIdentityCenterConfigOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
