/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVpcEndpointRequest extends OpenSearchServerlessRequest implements
        ToCopyableBuilder<UpdateVpcEndpointRequest.Builder, UpdateVpcEndpointRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateVpcEndpointRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<String>> ADD_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("addSubnetIds")
            .getter(getter(UpdateVpcEndpointRequest::addSubnetIds))
            .setter(setter(Builder::addSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addSubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("removeSubnetIds")
            .getter(getter(UpdateVpcEndpointRequest::removeSubnetIds))
            .setter(setter(Builder::removeSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeSubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ADD_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("addSecurityGroupIds")
            .getter(getter(UpdateVpcEndpointRequest::addSecurityGroupIds))
            .setter(setter(Builder::addSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("removeSecurityGroupIds")
            .getter(getter(UpdateVpcEndpointRequest::removeSecurityGroupIds))
            .setter(setter(Builder::removeSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateVpcEndpointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            ADD_SUBNET_IDS_FIELD, REMOVE_SUBNET_IDS_FIELD, ADD_SECURITY_GROUP_IDS_FIELD, REMOVE_SECURITY_GROUP_IDS_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final List<String> addSubnetIds;

    private final List<String> removeSubnetIds;

    private final List<String> addSecurityGroupIds;

    private final List<String> removeSecurityGroupIds;

    private final String clientToken;

    private UpdateVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.addSubnetIds = builder.addSubnetIds;
        this.removeSubnetIds = builder.removeSubnetIds;
        this.addSecurityGroupIds = builder.addSecurityGroupIds;
        this.removeSecurityGroupIds = builder.removeSecurityGroupIds;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The unique identifier of the interface endpoint to update.
     * </p>
     * 
     * @return The unique identifier of the interface endpoint to update.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddSubnetIds() {
        return addSubnetIds != null && !(addSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of one or more subnets to add to the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddSubnetIds} method.
     * </p>
     * 
     * @return The ID of one or more subnets to add to the endpoint.
     */
    public final List<String> addSubnetIds() {
        return addSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveSubnetIds() {
        return removeSubnetIds != null && !(removeSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the subnets to remove from the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveSubnetIds} method.
     * </p>
     * 
     * @return The unique identifiers of the subnets to remove from the endpoint.
     */
    public final List<String> removeSubnetIds() {
        return removeSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddSecurityGroupIds() {
        return addSecurityGroupIds != null && !(addSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the security groups to add to the endpoint. Security groups define the ports,
     * protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddSecurityGroupIds} method.
     * </p>
     * 
     * @return The unique identifiers of the security groups to add to the endpoint. Security groups define the ports,
     *         protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     */
    public final List<String> addSecurityGroupIds() {
        return addSecurityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveSecurityGroupIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveSecurityGroupIds() {
        return removeSecurityGroupIds != null && !(removeSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the security groups to remove from the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveSecurityGroupIds} method.
     * </p>
     * 
     * @return The unique identifiers of the security groups to remove from the endpoint.
     */
    public final List<String> removeSecurityGroupIds() {
        return removeSecurityGroupIds;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddSubnetIds() ? addSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveSubnetIds() ? removeSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddSecurityGroupIds() ? addSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveSecurityGroupIds() ? removeSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcEndpointRequest)) {
            return false;
        }
        UpdateVpcEndpointRequest other = (UpdateVpcEndpointRequest) obj;
        return Objects.equals(id(), other.id()) && hasAddSubnetIds() == other.hasAddSubnetIds()
                && Objects.equals(addSubnetIds(), other.addSubnetIds()) && hasRemoveSubnetIds() == other.hasRemoveSubnetIds()
                && Objects.equals(removeSubnetIds(), other.removeSubnetIds())
                && hasAddSecurityGroupIds() == other.hasAddSecurityGroupIds()
                && Objects.equals(addSecurityGroupIds(), other.addSecurityGroupIds())
                && hasRemoveSecurityGroupIds() == other.hasRemoveSecurityGroupIds()
                && Objects.equals(removeSecurityGroupIds(), other.removeSecurityGroupIds())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVpcEndpointRequest").add("Id", id())
                .add("AddSubnetIds", hasAddSubnetIds() ? addSubnetIds() : null)
                .add("RemoveSubnetIds", hasRemoveSubnetIds() ? removeSubnetIds() : null)
                .add("AddSecurityGroupIds", hasAddSecurityGroupIds() ? addSecurityGroupIds() : null)
                .add("RemoveSecurityGroupIds", hasRemoveSecurityGroupIds() ? removeSecurityGroupIds() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "addSubnetIds":
            return Optional.ofNullable(clazz.cast(addSubnetIds()));
        case "removeSubnetIds":
            return Optional.ofNullable(clazz.cast(removeSubnetIds()));
        case "addSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(addSecurityGroupIds()));
        case "removeSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(removeSecurityGroupIds()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("addSubnetIds", ADD_SUBNET_IDS_FIELD);
        map.put("removeSubnetIds", REMOVE_SUBNET_IDS_FIELD);
        map.put("addSecurityGroupIds", ADD_SECURITY_GROUP_IDS_FIELD);
        map.put("removeSecurityGroupIds", REMOVE_SECURITY_GROUP_IDS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcEndpointRequest, T> g) {
        return obj -> g.apply((UpdateVpcEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateVpcEndpointRequest> {
        /**
         * <p>
         * The unique identifier of the interface endpoint to update.
         * </p>
         * 
         * @param id
         *        The unique identifier of the interface endpoint to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of one or more subnets to add to the endpoint.
         * </p>
         * 
         * @param addSubnetIds
         *        The ID of one or more subnets to add to the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetIds(Collection<String> addSubnetIds);

        /**
         * <p>
         * The ID of one or more subnets to add to the endpoint.
         * </p>
         * 
         * @param addSubnetIds
         *        The ID of one or more subnets to add to the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetIds(String... addSubnetIds);

        /**
         * <p>
         * The unique identifiers of the subnets to remove from the endpoint.
         * </p>
         * 
         * @param removeSubnetIds
         *        The unique identifiers of the subnets to remove from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetIds(Collection<String> removeSubnetIds);

        /**
         * <p>
         * The unique identifiers of the subnets to remove from the endpoint.
         * </p>
         * 
         * @param removeSubnetIds
         *        The unique identifiers of the subnets to remove from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetIds(String... removeSubnetIds);

        /**
         * <p>
         * The unique identifiers of the security groups to add to the endpoint. Security groups define the ports,
         * protocols, and sources for inbound traffic that you are authorizing into your endpoint.
         * </p>
         * 
         * @param addSecurityGroupIds
         *        The unique identifiers of the security groups to add to the endpoint. Security groups define the
         *        ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds);

        /**
         * <p>
         * The unique identifiers of the security groups to add to the endpoint. Security groups define the ports,
         * protocols, and sources for inbound traffic that you are authorizing into your endpoint.
         * </p>
         * 
         * @param addSecurityGroupIds
         *        The unique identifiers of the security groups to add to the endpoint. Security groups define the
         *        ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSecurityGroupIds(String... addSecurityGroupIds);

        /**
         * <p>
         * The unique identifiers of the security groups to remove from the endpoint.
         * </p>
         * 
         * @param removeSecurityGroupIds
         *        The unique identifiers of the security groups to remove from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds);

        /**
         * <p>
         * The unique identifiers of the security groups to remove from the endpoint.
         * </p>
         * 
         * @param removeSecurityGroupIds
         *        The unique identifiers of the security groups to remove from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSecurityGroupIds(String... removeSecurityGroupIds);

        /**
         * <p>
         * Unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchServerlessRequest.BuilderImpl implements Builder {
        private String id;

        private List<String> addSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> addSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcEndpointRequest model) {
            super(model);
            id(model.id);
            addSubnetIds(model.addSubnetIds);
            removeSubnetIds(model.removeSubnetIds);
            addSecurityGroupIds(model.addSecurityGroupIds);
            removeSecurityGroupIds(model.removeSecurityGroupIds);
            clientToken(model.clientToken);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getAddSubnetIds() {
            if (addSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addSubnetIds;
        }

        public final void setAddSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = SubnetIdsCopier.copy(addSubnetIds);
        }

        @Override
        public final Builder addSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = SubnetIdsCopier.copy(addSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSubnetIds(String... addSubnetIds) {
            addSubnetIds(Arrays.asList(addSubnetIds));
            return this;
        }

        public final Collection<String> getRemoveSubnetIds() {
            if (removeSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeSubnetIds;
        }

        public final void setRemoveSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = SubnetIdsCopier.copy(removeSubnetIds);
        }

        @Override
        public final Builder removeSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = SubnetIdsCopier.copy(removeSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSubnetIds(String... removeSubnetIds) {
            removeSubnetIds(Arrays.asList(removeSubnetIds));
            return this;
        }

        public final Collection<String> getAddSecurityGroupIds() {
            if (addSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addSecurityGroupIds;
        }

        public final void setAddSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = SecurityGroupIdsCopier.copy(addSecurityGroupIds);
        }

        @Override
        public final Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = SecurityGroupIdsCopier.copy(addSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSecurityGroupIds(String... addSecurityGroupIds) {
            addSecurityGroupIds(Arrays.asList(addSecurityGroupIds));
            return this;
        }

        public final Collection<String> getRemoveSecurityGroupIds() {
            if (removeSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeSecurityGroupIds;
        }

        public final void setRemoveSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = SecurityGroupIdsCopier.copy(removeSecurityGroupIds);
        }

        @Override
        public final Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = SecurityGroupIdsCopier.copy(removeSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSecurityGroupIds(String... removeSecurityGroupIds) {
            removeSecurityGroupIds(Arrays.asList(removeSecurityGroupIds));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVpcEndpointRequest build() {
            return new UpdateVpcEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
