/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDeploymentsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeDeploymentsRequest.Builder, DescribeDeploymentsRequest> {
    private final String stackId;

    private final String appId;

    private final List<String> deploymentIds;

    private DescribeDeploymentsRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.deploymentIds = builder.deploymentIds;
    }

    /**
     * <p>
     * The stack ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of the
     * commands associated with the specified stack.
     * </p>
     * 
     * @return The stack ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of
     *         the commands associated with the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The app ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of the commands
     * associated with the specified app.
     * </p>
     * 
     * @return The app ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of the
     *         commands associated with the specified app.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * An array of deployment IDs to be described. If you include this parameter, <code>DescribeDeployments</code>
     * returns a description of the specified deployments. Otherwise, it returns a description of every deployment.
     * </p>
     * 
     * @return An array of deployment IDs to be described. If you include this parameter,
     *         <code>DescribeDeployments</code> returns a description of the specified deployments. Otherwise, it
     *         returns a description of every deployment.
     */
    public List<String> deploymentIds() {
        return deploymentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((appId() == null) ? 0 : appId().hashCode());
        hashCode = 31 * hashCode + ((deploymentIds() == null) ? 0 : deploymentIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentsRequest)) {
            return false;
        }
        DescribeDeploymentsRequest other = (DescribeDeploymentsRequest) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.appId() == null ^ this.appId() == null) {
            return false;
        }
        if (other.appId() != null && !other.appId().equals(this.appId())) {
            return false;
        }
        if (other.deploymentIds() == null ^ this.deploymentIds() == null) {
            return false;
        }
        if (other.deploymentIds() != null && !other.deploymentIds().equals(this.deploymentIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (appId() != null) {
            sb.append("AppId: ").append(appId()).append(",");
        }
        if (deploymentIds() != null) {
            sb.append("DeploymentIds: ").append(deploymentIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDeploymentsRequest> {
        /**
         * <p>
         * The stack ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of the
         * commands associated with the specified stack.
         * </p>
         * 
         * @param stackId
         *        The stack ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of
         *        the commands associated with the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The app ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of the
         * commands associated with the specified app.
         * </p>
         * 
         * @param appId
         *        The app ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of
         *        the commands associated with the specified app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * An array of deployment IDs to be described. If you include this parameter, <code>DescribeDeployments</code>
         * returns a description of the specified deployments. Otherwise, it returns a description of every deployment.
         * </p>
         * 
         * @param deploymentIds
         *        An array of deployment IDs to be described. If you include this parameter,
         *        <code>DescribeDeployments</code> returns a description of the specified deployments. Otherwise, it
         *        returns a description of every deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(Collection<String> deploymentIds);

        /**
         * <p>
         * An array of deployment IDs to be described. If you include this parameter, <code>DescribeDeployments</code>
         * returns a description of the specified deployments. Otherwise, it returns a description of every deployment.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeploymentIds(java.util.Collection)} or {@link #withDeploymentIds(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param deploymentIds
         *        An array of deployment IDs to be described. If you include this parameter,
         *        <code>DescribeDeployments</code> returns a description of the specified deployments. Otherwise, it
         *        returns a description of every deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(String... deploymentIds);
    }

    private static final class BuilderImpl implements Builder {
        private String stackId;

        private String appId;

        private List<String> deploymentIds = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentsRequest model) {
            setStackId(model.stackId);
            setAppId(model.appId);
            setDeploymentIds(model.deploymentIds);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final Collection<String> getDeploymentIds() {
            return deploymentIds;
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = StringsCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String... deploymentIds) {
            if (this.deploymentIds == null) {
                this.deploymentIds = new SdkInternalList<>(deploymentIds.length);
            }
            for (String e : deploymentIds) {
                this.deploymentIds.add(e);
            }
            return this;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = StringsCopier.copy(deploymentIds);
        }

        @SafeVarargs
        public final void setDeploymentIds(String... deploymentIds) {
            if (this.deploymentIds == null) {
                this.deploymentIds = new SdkInternalList<>(deploymentIds.length);
            }
            for (String e : deploymentIds) {
                this.deploymentIds.add(e);
            }
        }

        @Override
        public DescribeDeploymentsRequest build() {
            return new DescribeDeploymentsRequest(this);
        }
    }
}
