/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribePermissions</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePermissionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribePermissionsResponse.Builder, DescribePermissionsResponse> {
    private final List<Permission> permissions;

    private DescribePermissionsResponse(BuilderImpl builder) {
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * An array of <code>Permission</code> objects that describe the stack permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
     * permissions for each of the stack IAM ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
     * permissions for each of the user's stack IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
     * with permissions for the specified stack and IAM ARN.
     * </p>
     * </li>
     * </ul>
     * 
     * @return An array of <code>Permission</code> objects that describe the stack permissions.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
     *         permissions for each of the stack IAM ARNs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
     *         permissions for each of the user's stack IDs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code>
     *         object with permissions for the specified stack and IAM ARN.
     *         </p>
     *         </li>
     */
    public List<Permission> permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((permissions() == null) ? 0 : permissions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePermissionsResponse)) {
            return false;
        }
        DescribePermissionsResponse other = (DescribePermissionsResponse) obj;
        if (other.permissions() == null ^ this.permissions() == null) {
            return false;
        }
        if (other.permissions() != null && !other.permissions().equals(this.permissions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (permissions() != null) {
            sb.append("Permissions: ").append(permissions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribePermissionsResponse> {
        /**
         * <p>
         * An array of <code>Permission</code> objects that describe the stack permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
         * permissions for each of the stack IAM ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
         * permissions for each of the user's stack IDs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
         * with permissions for the specified stack and IAM ARN.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissions
         *        An array of <code>Permission</code> objects that describe the stack permissions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the request object contains only a stack ID, the array contains a <code>Permission</code> object
         *        with permissions for each of the stack IAM ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object
         *        with permissions for each of the user's stack IDs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code>
         *        object with permissions for the specified stack and IAM ARN.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * An array of <code>Permission</code> objects that describe the stack permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
         * permissions for each of the stack IAM ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
         * permissions for each of the user's stack IDs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
         * with permissions for the specified stack and IAM ARN.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setPermissions(java.util.Collection)} or {@link #withPermissions(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param permissions
         *        An array of <code>Permission</code> objects that describe the stack permissions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the request object contains only a stack ID, the array contains a <code>Permission</code> object
         *        with permissions for each of the stack IAM ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object
         *        with permissions for each of the user's stack IDs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code>
         *        object with permissions for the specified stack and IAM ARN.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);
    }

    private static final class BuilderImpl implements Builder {
        private List<Permission> permissions = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePermissionsResponse model) {
            setPermissions(model.permissions);
        }

        public final Collection<Permission> getPermissions() {
            return permissions;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            if (this.permissions == null) {
                this.permissions = new SdkInternalList<>(permissions.length);
            }
            for (Permission e : permissions) {
                this.permissions.add(e);
            }
            return this;
        }

        public final void setPermissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
        }

        @SafeVarargs
        public final void setPermissions(Permission... permissions) {
            if (this.permissions == null) {
                this.permissions = new SdkInternalList<>(permissions.length);
            }
            for (Permission e : permissions) {
                this.permissions.add(e);
            }
        }

        @Override
        public DescribePermissionsResponse build() {
            return new DescribePermissionsResponse(this);
        }
    }
}
