/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeServiceErrors</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeServiceErrorsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeServiceErrorsResponse.Builder, DescribeServiceErrorsResponse> {
    private final List<ServiceError> serviceErrors;

    private DescribeServiceErrorsResponse(BuilderImpl builder) {
        this.serviceErrors = builder.serviceErrors;
    }

    /**
     * <p>
     * An array of <code>ServiceError</code> objects that describe the specified service errors.
     * </p>
     * 
     * @return An array of <code>ServiceError</code> objects that describe the specified service errors.
     */
    public List<ServiceError> serviceErrors() {
        return serviceErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((serviceErrors() == null) ? 0 : serviceErrors().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceErrorsResponse)) {
            return false;
        }
        DescribeServiceErrorsResponse other = (DescribeServiceErrorsResponse) obj;
        if (other.serviceErrors() == null ^ this.serviceErrors() == null) {
            return false;
        }
        if (other.serviceErrors() != null && !other.serviceErrors().equals(this.serviceErrors())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (serviceErrors() != null) {
            sb.append("ServiceErrors: ").append(serviceErrors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeServiceErrorsResponse> {
        /**
         * <p>
         * An array of <code>ServiceError</code> objects that describe the specified service errors.
         * </p>
         * 
         * @param serviceErrors
         *        An array of <code>ServiceError</code> objects that describe the specified service errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceErrors(Collection<ServiceError> serviceErrors);

        /**
         * <p>
         * An array of <code>ServiceError</code> objects that describe the specified service errors.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setServiceErrors(java.util.Collection)} or {@link #withServiceErrors(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param serviceErrors
         *        An array of <code>ServiceError</code> objects that describe the specified service errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceErrors(ServiceError... serviceErrors);
    }

    private static final class BuilderImpl implements Builder {
        private List<ServiceError> serviceErrors = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceErrorsResponse model) {
            setServiceErrors(model.serviceErrors);
        }

        public final Collection<ServiceError> getServiceErrors() {
            return serviceErrors;
        }

        @Override
        public final Builder serviceErrors(Collection<ServiceError> serviceErrors) {
            this.serviceErrors = ServiceErrorsCopier.copy(serviceErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceErrors(ServiceError... serviceErrors) {
            if (this.serviceErrors == null) {
                this.serviceErrors = new SdkInternalList<>(serviceErrors.length);
            }
            for (ServiceError e : serviceErrors) {
                this.serviceErrors.add(e);
            }
            return this;
        }

        public final void setServiceErrors(Collection<ServiceError> serviceErrors) {
            this.serviceErrors = ServiceErrorsCopier.copy(serviceErrors);
        }

        @SafeVarargs
        public final void setServiceErrors(ServiceError... serviceErrors) {
            if (this.serviceErrors == null) {
                this.serviceErrors = new SdkInternalList<>(serviceErrors.length);
            }
            for (ServiceError e : serviceErrors) {
                this.serviceErrors.add(e);
            }
        }

        @Override
        public DescribeServiceErrorsResponse build() {
            return new DescribeServiceErrorsResponse(this);
        }
    }
}
