/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.EbsBlockDeviceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon EBS volume. This data type maps directly to the Amazon EC2 <a
 * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EbsBlockDevice implements StructuredPojo, ToCopyableBuilder<EbsBlockDevice.Builder, EbsBlockDevice> {
    private final String snapshotId;

    private final Integer iops;

    private final Integer volumeSize;

    private final String volumeType;

    private final Boolean deleteOnTermination;

    private EbsBlockDevice(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.iops = builder.iops;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    /**
     * <p>
     * The snapshot ID.
     * </p>
     * 
     * @return The snapshot ID.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS) that the volume supports. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS) that the volume supports. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The volume size, in GiB. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
     * </p>
     * 
     * @return The volume size, in GiB. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
     */
    public Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned IOPS (SSD)
     * volumes, and <code>standard</code> for Magnetic volumes.
     * </p>
     * 
     * @return The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned
     *         IOPS (SSD) volumes, and <code>standard</code> for Magnetic volumes.
     * @see VolumeType
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * Whether the volume is deleted on instance termination.
     * </p>
     * 
     * @return Whether the volume is deleted on instance termination.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((snapshotId() == null) ? 0 : snapshotId().hashCode());
        hashCode = 31 * hashCode + ((iops() == null) ? 0 : iops().hashCode());
        hashCode = 31 * hashCode + ((volumeSize() == null) ? 0 : volumeSize().hashCode());
        hashCode = 31 * hashCode + ((volumeType() == null) ? 0 : volumeType().hashCode());
        hashCode = 31 * hashCode + ((deleteOnTermination() == null) ? 0 : deleteOnTermination().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDevice)) {
            return false;
        }
        EbsBlockDevice other = (EbsBlockDevice) obj;
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.volumeSize() == null ^ this.volumeSize() == null) {
            return false;
        }
        if (other.volumeSize() != null && !other.volumeSize().equals(this.volumeSize())) {
            return false;
        }
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.deleteOnTermination() == null ^ this.deleteOnTermination() == null) {
            return false;
        }
        if (other.deleteOnTermination() != null && !other.deleteOnTermination().equals(this.deleteOnTermination())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (snapshotId() != null) {
            sb.append("SnapshotId: ").append(snapshotId()).append(",");
        }
        if (iops() != null) {
            sb.append("Iops: ").append(iops()).append(",");
        }
        if (volumeSize() != null) {
            sb.append("VolumeSize: ").append(volumeSize()).append(",");
        }
        if (volumeType() != null) {
            sb.append("VolumeType: ").append(volumeType()).append(",");
        }
        if (deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(deleteOnTermination()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EbsBlockDeviceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EbsBlockDevice> {
        /**
         * <p>
         * The snapshot ID.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The number of I/O operations per second (IOPS) that the volume supports. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS) that the volume supports. For more information, see <a
         *        href
         *        ="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The volume size, in GiB. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
         * </p>
         * 
         * @param volumeSize
         *        The volume size, in GiB. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html"
         *        >EbsBlockDevice</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned IOPS
         * (SSD) volumes, and <code>standard</code> for Magnetic volumes.
         * </p>
         * 
         * @param volumeType
         *        The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned
         *        IOPS (SSD) volumes, and <code>standard</code> for Magnetic volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned IOPS
         * (SSD) volumes, and <code>standard</code> for Magnetic volumes.
         * </p>
         * 
         * @param volumeType
         *        The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned
         *        IOPS (SSD) volumes, and <code>standard</code> for Magnetic volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * Whether the volume is deleted on instance termination.
         * </p>
         * 
         * @param deleteOnTermination
         *        Whether the volume is deleted on instance termination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);
    }

    private static final class BuilderImpl implements Builder {
        private String snapshotId;

        private Integer iops;

        private Integer volumeSize;

        private String volumeType;

        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDevice model) {
            setSnapshotId(model.snapshotId);
            setIops(model.iops);
            setVolumeSize(model.volumeSize);
            setVolumeType(model.volumeType);
            setDeleteOnTermination(model.deleteOnTermination);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final void setVolumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public EbsBlockDevice build() {
            return new EbsBlockDevice(this);
        }
    }
}
