/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.opsworks.transform.LayerMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Layer implements StructuredPojo, ToCopyableBuilder<Layer.Builder, Layer> {
    private final String arn;

    private final String stackId;

    private final String layerId;

    private final String type;

    private final String name;

    private final String shortname;

    private final Map<String, String> attributes;

    private final CloudWatchLogsConfiguration cloudWatchLogsConfiguration;

    private final String customInstanceProfileArn;

    private final String customJson;

    private final List<String> customSecurityGroupIds;

    private final List<String> defaultSecurityGroupNames;

    private final List<String> packages;

    private final List<VolumeConfiguration> volumeConfigurations;

    private final Boolean enableAutoHealing;

    private final Boolean autoAssignElasticIps;

    private final Boolean autoAssignPublicIps;

    private final Recipes defaultRecipes;

    private final Recipes customRecipes;

    private final String createdAt;

    private final Boolean installUpdatesOnBoot;

    private final Boolean useEbsOptimizedInstances;

    private final LifecycleEventConfiguration lifecycleEventConfiguration;

    private Layer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.type = builder.type;
        this.name = builder.name;
        this.shortname = builder.shortname;
        this.attributes = builder.attributes;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.customInstanceProfileArn = builder.customInstanceProfileArn;
        this.customJson = builder.customJson;
        this.customSecurityGroupIds = builder.customSecurityGroupIds;
        this.defaultSecurityGroupNames = builder.defaultSecurityGroupNames;
        this.packages = builder.packages;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.enableAutoHealing = builder.enableAutoHealing;
        this.autoAssignElasticIps = builder.autoAssignElasticIps;
        this.autoAssignPublicIps = builder.autoAssignPublicIps;
        this.defaultRecipes = builder.defaultRecipes;
        this.customRecipes = builder.customRecipes;
        this.createdAt = builder.createdAt;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.useEbsOptimizedInstances = builder.useEbsOptimizedInstances;
        this.lifecycleEventConfiguration = builder.lifecycleEventConfiguration;
    }

    /**
     *
     * @return
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The layer stack ID.
     * </p>
     * 
     * @return The layer stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The layer ID.
     * </p>
     * 
     * @return The layer ID.
     */
    public String layerId() {
        return layerId;
    }

    /**
     * <p>
     * The layer type.
     * </p>
     * 
     * @return The layer type.
     * @see LayerType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The layer name.
     * </p>
     * 
     * @return The layer name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The layer short name.
     * </p>
     * 
     * @return The layer short name.
     */
    public String shortname() {
        return shortname;
    }

    /**
     * <p>
     * The layer attributes.
     * </p>
     * <p>
     * For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and <code>GangliaPassword</code>
     * attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value
     * </p>
     * <p>
     * For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's
     * ARN.
     * </p>
     * 
     * @return The layer attributes.</p>
     *         <p>
     *         For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
     *         <code>GangliaPassword</code> attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code>
     *         instead of the actual value
     *         </p>
     *         <p>
     *         For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
     *         cluster's ARN.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The Amazon CloudWatch Logs configuration settings for the layer.
     * </p>
     * 
     * @return The Amazon CloudWatch Logs configuration settings for the layer.
     */
    public CloudWatchLogsConfiguration cloudWatchLogsConfiguration() {
        return cloudWatchLogsConfiguration;
    }

    /**
     * <p>
     * The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs,
     * see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about
     *         IAM ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
     *         Identifiers</a>.
     */
    public String customInstanceProfileArn() {
        return customInstanceProfileArn;
    }

    /**
     * <p>
     * A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
     * </p>
     * 
     * @return A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
     */
    public String customJson() {
        return customJson;
    }

    /**
     * <p>
     * An array containing the layer's custom security group IDs.
     * </p>
     * 
     * @return An array containing the layer's custom security group IDs.
     */
    public List<String> customSecurityGroupIds() {
        return customSecurityGroupIds;
    }

    /**
     * <p>
     * An array containing the layer's security group names.
     * </p>
     * 
     * @return An array containing the layer's security group names.
     */
    public List<String> defaultSecurityGroupNames() {
        return defaultSecurityGroupNames;
    }

    /**
     * <p>
     * An array of <code>Package</code> objects that describe the layer's packages.
     * </p>
     * 
     * @return An array of <code>Package</code> objects that describe the layer's packages.
     */
    public List<String> packages() {
        return packages;
    }

    /**
     * <p>
     * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
     * </p>
     * 
     * @return A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
     */
    public List<VolumeConfiguration> volumeConfigurations() {
        return volumeConfigurations;
    }

    /**
     * <p>
     * Whether auto healing is disabled for the layer.
     * </p>
     * 
     * @return Whether auto healing is disabled for the layer.
     */
    public Boolean enableAutoHealing() {
        return enableAutoHealing;
    }

    /**
     * <p>
     * Whether to automatically assign an <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to
     * the layer's instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     * Layer</a>.
     * </p>
     * 
     * @return Whether to automatically assign an <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     *         address</a> to the layer's instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     *         Layer</a>.
     */
    public Boolean autoAssignElasticIps() {
        return autoAssignElasticIps;
    }

    /**
     * <p>
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
     * instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     * Layer</a>.
     * </p>
     * 
     * @return For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
     *         instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     *         Layer</a>.
     */
    public Boolean autoAssignPublicIps() {
        return autoAssignPublicIps;
    }

    /**
     *
     * @return
     */
    public Recipes defaultRecipes() {
        return defaultRecipes;
    }

    /**
     * <p>
     * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
     * </p>
     * 
     * @return A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
     */
    public Recipes customRecipes() {
        return customRecipes;
    }

    /**
     * <p>
     * Date when the layer was created.
     * </p>
     * 
     * @return Date when the layer was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Whether to install operating system and package updates when the instance boots. The default value is
     * <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually by
     * using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or manually running
     * <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * </p>
     * <note>
     * <p>
     * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest
     * security updates.
     * </p>
     * </note>
     * 
     * @return Whether to install operating system and package updates when the instance boots. The default value is
     *         <code>true</code>. If this value is set to <code>false</code>, you must then update your instances
     *         manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or
     *         manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
     *         <note>
     *         <p>
     *         We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
     *         the latest security updates.
     *         </p>
     */
    public Boolean installUpdatesOnBoot() {
        return installUpdatesOnBoot;
    }

    /**
     * <p>
     * Whether the layer uses Amazon EBS-optimized instances.
     * </p>
     * 
     * @return Whether the layer uses Amazon EBS-optimized instances.
     */
    public Boolean useEbsOptimizedInstances() {
        return useEbsOptimizedInstances;
    }

    /**
     * <p>
     * A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
     * </p>
     * 
     * @return A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
     */
    public LifecycleEventConfiguration lifecycleEventConfiguration() {
        return lifecycleEventConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((layerId() == null) ? 0 : layerId().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((shortname() == null) ? 0 : shortname().hashCode());
        hashCode = 31 * hashCode + ((attributes() == null) ? 0 : attributes().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchLogsConfiguration() == null) ? 0 : cloudWatchLogsConfiguration().hashCode());
        hashCode = 31 * hashCode + ((customInstanceProfileArn() == null) ? 0 : customInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + ((customJson() == null) ? 0 : customJson().hashCode());
        hashCode = 31 * hashCode + ((customSecurityGroupIds() == null) ? 0 : customSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + ((defaultSecurityGroupNames() == null) ? 0 : defaultSecurityGroupNames().hashCode());
        hashCode = 31 * hashCode + ((packages() == null) ? 0 : packages().hashCode());
        hashCode = 31 * hashCode + ((volumeConfigurations() == null) ? 0 : volumeConfigurations().hashCode());
        hashCode = 31 * hashCode + ((enableAutoHealing() == null) ? 0 : enableAutoHealing().hashCode());
        hashCode = 31 * hashCode + ((autoAssignElasticIps() == null) ? 0 : autoAssignElasticIps().hashCode());
        hashCode = 31 * hashCode + ((autoAssignPublicIps() == null) ? 0 : autoAssignPublicIps().hashCode());
        hashCode = 31 * hashCode + ((defaultRecipes() == null) ? 0 : defaultRecipes().hashCode());
        hashCode = 31 * hashCode + ((customRecipes() == null) ? 0 : customRecipes().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((installUpdatesOnBoot() == null) ? 0 : installUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + ((useEbsOptimizedInstances() == null) ? 0 : useEbsOptimizedInstances().hashCode());
        hashCode = 31 * hashCode + ((lifecycleEventConfiguration() == null) ? 0 : lifecycleEventConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.layerId() == null ^ this.layerId() == null) {
            return false;
        }
        if (other.layerId() != null && !other.layerId().equals(this.layerId())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.shortname() == null ^ this.shortname() == null) {
            return false;
        }
        if (other.shortname() != null && !other.shortname().equals(this.shortname())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.cloudWatchLogsConfiguration() == null ^ this.cloudWatchLogsConfiguration() == null) {
            return false;
        }
        if (other.cloudWatchLogsConfiguration() != null
                && !other.cloudWatchLogsConfiguration().equals(this.cloudWatchLogsConfiguration())) {
            return false;
        }
        if (other.customInstanceProfileArn() == null ^ this.customInstanceProfileArn() == null) {
            return false;
        }
        if (other.customInstanceProfileArn() != null && !other.customInstanceProfileArn().equals(this.customInstanceProfileArn())) {
            return false;
        }
        if (other.customJson() == null ^ this.customJson() == null) {
            return false;
        }
        if (other.customJson() != null && !other.customJson().equals(this.customJson())) {
            return false;
        }
        if (other.customSecurityGroupIds() == null ^ this.customSecurityGroupIds() == null) {
            return false;
        }
        if (other.customSecurityGroupIds() != null && !other.customSecurityGroupIds().equals(this.customSecurityGroupIds())) {
            return false;
        }
        if (other.defaultSecurityGroupNames() == null ^ this.defaultSecurityGroupNames() == null) {
            return false;
        }
        if (other.defaultSecurityGroupNames() != null
                && !other.defaultSecurityGroupNames().equals(this.defaultSecurityGroupNames())) {
            return false;
        }
        if (other.packages() == null ^ this.packages() == null) {
            return false;
        }
        if (other.packages() != null && !other.packages().equals(this.packages())) {
            return false;
        }
        if (other.volumeConfigurations() == null ^ this.volumeConfigurations() == null) {
            return false;
        }
        if (other.volumeConfigurations() != null && !other.volumeConfigurations().equals(this.volumeConfigurations())) {
            return false;
        }
        if (other.enableAutoHealing() == null ^ this.enableAutoHealing() == null) {
            return false;
        }
        if (other.enableAutoHealing() != null && !other.enableAutoHealing().equals(this.enableAutoHealing())) {
            return false;
        }
        if (other.autoAssignElasticIps() == null ^ this.autoAssignElasticIps() == null) {
            return false;
        }
        if (other.autoAssignElasticIps() != null && !other.autoAssignElasticIps().equals(this.autoAssignElasticIps())) {
            return false;
        }
        if (other.autoAssignPublicIps() == null ^ this.autoAssignPublicIps() == null) {
            return false;
        }
        if (other.autoAssignPublicIps() != null && !other.autoAssignPublicIps().equals(this.autoAssignPublicIps())) {
            return false;
        }
        if (other.defaultRecipes() == null ^ this.defaultRecipes() == null) {
            return false;
        }
        if (other.defaultRecipes() != null && !other.defaultRecipes().equals(this.defaultRecipes())) {
            return false;
        }
        if (other.customRecipes() == null ^ this.customRecipes() == null) {
            return false;
        }
        if (other.customRecipes() != null && !other.customRecipes().equals(this.customRecipes())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.installUpdatesOnBoot() == null ^ this.installUpdatesOnBoot() == null) {
            return false;
        }
        if (other.installUpdatesOnBoot() != null && !other.installUpdatesOnBoot().equals(this.installUpdatesOnBoot())) {
            return false;
        }
        if (other.useEbsOptimizedInstances() == null ^ this.useEbsOptimizedInstances() == null) {
            return false;
        }
        if (other.useEbsOptimizedInstances() != null && !other.useEbsOptimizedInstances().equals(this.useEbsOptimizedInstances())) {
            return false;
        }
        if (other.lifecycleEventConfiguration() == null ^ this.lifecycleEventConfiguration() == null) {
            return false;
        }
        if (other.lifecycleEventConfiguration() != null
                && !other.lifecycleEventConfiguration().equals(this.lifecycleEventConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (layerId() != null) {
            sb.append("LayerId: ").append(layerId()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (shortname() != null) {
            sb.append("Shortname: ").append(shortname()).append(",");
        }
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        if (cloudWatchLogsConfiguration() != null) {
            sb.append("CloudWatchLogsConfiguration: ").append(cloudWatchLogsConfiguration()).append(",");
        }
        if (customInstanceProfileArn() != null) {
            sb.append("CustomInstanceProfileArn: ").append(customInstanceProfileArn()).append(",");
        }
        if (customJson() != null) {
            sb.append("CustomJson: ").append(customJson()).append(",");
        }
        if (customSecurityGroupIds() != null) {
            sb.append("CustomSecurityGroupIds: ").append(customSecurityGroupIds()).append(",");
        }
        if (defaultSecurityGroupNames() != null) {
            sb.append("DefaultSecurityGroupNames: ").append(defaultSecurityGroupNames()).append(",");
        }
        if (packages() != null) {
            sb.append("Packages: ").append(packages()).append(",");
        }
        if (volumeConfigurations() != null) {
            sb.append("VolumeConfigurations: ").append(volumeConfigurations()).append(",");
        }
        if (enableAutoHealing() != null) {
            sb.append("EnableAutoHealing: ").append(enableAutoHealing()).append(",");
        }
        if (autoAssignElasticIps() != null) {
            sb.append("AutoAssignElasticIps: ").append(autoAssignElasticIps()).append(",");
        }
        if (autoAssignPublicIps() != null) {
            sb.append("AutoAssignPublicIps: ").append(autoAssignPublicIps()).append(",");
        }
        if (defaultRecipes() != null) {
            sb.append("DefaultRecipes: ").append(defaultRecipes()).append(",");
        }
        if (customRecipes() != null) {
            sb.append("CustomRecipes: ").append(customRecipes()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (installUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(installUpdatesOnBoot()).append(",");
        }
        if (useEbsOptimizedInstances() != null) {
            sb.append("UseEbsOptimizedInstances: ").append(useEbsOptimizedInstances()).append(",");
        }
        if (lifecycleEventConfiguration() != null) {
            sb.append("LifecycleEventConfiguration: ").append(lifecycleEventConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LayerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Layer> {
        /**
         *
         * @param arn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The layer stack ID.
         * </p>
         * 
         * @param stackId
         *        The layer stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The layer ID.
         * </p>
         * 
         * @param layerId
         *        The layer ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * The layer type.
         * </p>
         * 
         * @param type
         *        The layer type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerType
         */
        Builder type(String type);

        /**
         * <p>
         * The layer type.
         * </p>
         * 
         * @param type
         *        The layer type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerType
         */
        Builder type(LayerType type);

        /**
         * <p>
         * The layer name.
         * </p>
         * 
         * @param name
         *        The layer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The layer short name.
         * </p>
         * 
         * @param shortname
         *        The layer short name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortname(String shortname);

        /**
         * <p>
         * The layer attributes.
         * </p>
         * <p>
         * For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and <code>GangliaPassword</code>
         * attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value
         * </p>
         * <p>
         * For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
         * cluster's ARN.
         * </p>
         * 
         * @param attributes
         *        The layer attributes.</p>
         *        <p>
         *        For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
         *        <code>GangliaPassword</code> attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code>
         *        instead of the actual value
         *        </p>
         *        <p>
         *        For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
         *        cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration settings for the layer.
         * </p>
         * 
         * @param cloudWatchLogsConfiguration
         *        The Amazon CloudWatch Logs configuration settings for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration);

        /**
         * <p>
         * The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about IAM
         * ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
         * Identifiers</a>.
         * </p>
         * 
         * @param customInstanceProfileArn
         *        The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information
         *        about IAM ARNs, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customInstanceProfileArn(String customInstanceProfileArn);

        /**
         * <p>
         * A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
         * </p>
         * 
         * @param customJson
         *        A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * An array containing the layer's custom security group IDs.
         * </p>
         * 
         * @param customSecurityGroupIds
         *        An array containing the layer's custom security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds);

        /**
         * <p>
         * An array containing the layer's custom security group IDs.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setCustomSecurityGroupIds(java.util.Collection)} or
         * {@link #withCustomSecurityGroupIds(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param customSecurityGroupIds
         *        An array containing the layer's custom security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupIds(String... customSecurityGroupIds);

        /**
         * <p>
         * An array containing the layer's security group names.
         * </p>
         * 
         * @param defaultSecurityGroupNames
         *        An array containing the layer's security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames);

        /**
         * <p>
         * An array containing the layer's security group names.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDefaultSecurityGroupNames(java.util.Collection)} or
         * {@link #withDefaultSecurityGroupNames(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param defaultSecurityGroupNames
         *        An array containing the layer's security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSecurityGroupNames(String... defaultSecurityGroupNames);

        /**
         * <p>
         * An array of <code>Package</code> objects that describe the layer's packages.
         * </p>
         * 
         * @param packages
         *        An array of <code>Package</code> objects that describe the layer's packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(Collection<String> packages);

        /**
         * <p>
         * An array of <code>Package</code> objects that describe the layer's packages.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setPackages(java.util.Collection)} or {@link #withPackages(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param packages
         *        An array of <code>Package</code> objects that describe the layer's packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(String... packages);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * 
         * @param volumeConfigurations
         *        A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setVolumeConfigurations(java.util.Collection)} or
         * {@link #withVolumeConfigurations(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param volumeConfigurations
         *        A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(VolumeConfiguration... volumeConfigurations);

        /**
         * <p>
         * Whether auto healing is disabled for the layer.
         * </p>
         * 
         * @param enableAutoHealing
         *        Whether auto healing is disabled for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoHealing(Boolean enableAutoHealing);

        /**
         * <p>
         * Whether to automatically assign an <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         * address</a> to the layer's instances. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
         * Layer</a>.
         * </p>
         * 
         * @param autoAssignElasticIps
         *        Whether to automatically assign an <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         *        address</a> to the layer's instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
         *        a Layer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssignElasticIps(Boolean autoAssignElasticIps);

        /**
         * <p>
         * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
         * instances. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
         * Layer</a>.
         * </p>
         * 
         * @param autoAssignPublicIps
         *        For stacks that are running in a VPC, whether to automatically assign a public IP address to the
         *        layer's instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
         *        a Layer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssignPublicIps(Boolean autoAssignPublicIps);

        /**
         *
         * @param defaultRecipes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRecipes(Recipes defaultRecipes);

        /**
         * <p>
         * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * </p>
         * 
         * @param customRecipes
         *        A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRecipes(Recipes customRecipes);

        /**
         * <p>
         * Date when the layer was created.
         * </p>
         * 
         * @param createdAt
         *        Date when the layer was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * Whether to install operating system and package updates when the instance boots. The default value is
         * <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually
         * by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or manually
         * running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         * </p>
         * <note>
         * <p>
         * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the
         * latest security updates.
         * </p>
         * </note>
         * 
         * @param installUpdatesOnBoot
         *        Whether to install operating system and package updates when the instance boots. The default value is
         *        <code>true</code>. If this value is set to <code>false</code>, you must then update your instances
         *        manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or
         *        manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         *        </p> <note>
         *        <p>
         *        We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
         *        the latest security updates.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot);

        /**
         * <p>
         * Whether the layer uses Amazon EBS-optimized instances.
         * </p>
         * 
         * @param useEbsOptimizedInstances
         *        Whether the layer uses Amazon EBS-optimized instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances);

        /**
         * <p>
         * A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
         * </p>
         * 
         * @param lifecycleEventConfiguration
         *        A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private String stackId;

        private String layerId;

        private String type;

        private String name;

        private String shortname;

        private Map<String, String> attributes = new SdkInternalMap<>();

        private CloudWatchLogsConfiguration cloudWatchLogsConfiguration;

        private String customInstanceProfileArn;

        private String customJson;

        private List<String> customSecurityGroupIds = new SdkInternalList<>();

        private List<String> defaultSecurityGroupNames = new SdkInternalList<>();

        private List<String> packages = new SdkInternalList<>();

        private List<VolumeConfiguration> volumeConfigurations = new SdkInternalList<>();

        private Boolean enableAutoHealing;

        private Boolean autoAssignElasticIps;

        private Boolean autoAssignPublicIps;

        private Recipes defaultRecipes;

        private Recipes customRecipes;

        private String createdAt;

        private Boolean installUpdatesOnBoot;

        private Boolean useEbsOptimizedInstances;

        private LifecycleEventConfiguration lifecycleEventConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Layer model) {
            setArn(model.arn);
            setStackId(model.stackId);
            setLayerId(model.layerId);
            setType(model.type);
            setName(model.name);
            setShortname(model.shortname);
            setAttributes(model.attributes);
            setCloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            setCustomInstanceProfileArn(model.customInstanceProfileArn);
            setCustomJson(model.customJson);
            setCustomSecurityGroupIds(model.customSecurityGroupIds);
            setDefaultSecurityGroupNames(model.defaultSecurityGroupNames);
            setPackages(model.packages);
            setVolumeConfigurations(model.volumeConfigurations);
            setEnableAutoHealing(model.enableAutoHealing);
            setAutoAssignElasticIps(model.autoAssignElasticIps);
            setAutoAssignPublicIps(model.autoAssignPublicIps);
            setDefaultRecipes(model.defaultRecipes);
            setCustomRecipes(model.customRecipes);
            setCreatedAt(model.createdAt);
            setInstallUpdatesOnBoot(model.installUpdatesOnBoot);
            setUseEbsOptimizedInstances(model.useEbsOptimizedInstances);
            setLifecycleEventConfiguration(model.lifecycleEventConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LayerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(LayerType type) {
            this.type(type.toString());
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getShortname() {
            return shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
        }

        public final CloudWatchLogsConfiguration getCloudWatchLogsConfiguration() {
            return cloudWatchLogsConfiguration;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
        }

        public final String getCustomInstanceProfileArn() {
            return customInstanceProfileArn;
        }

        @Override
        public final Builder customInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
            return this;
        }

        public final void setCustomInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getCustomSecurityGroupIds() {
            return customSecurityGroupIds;
        }

        @Override
        public final Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customSecurityGroupIds(String... customSecurityGroupIds) {
            if (this.customSecurityGroupIds == null) {
                this.customSecurityGroupIds = new SdkInternalList<>(customSecurityGroupIds.length);
            }
            for (String e : customSecurityGroupIds) {
                this.customSecurityGroupIds.add(e);
            }
            return this;
        }

        public final void setCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
        }

        @SafeVarargs
        public final void setCustomSecurityGroupIds(String... customSecurityGroupIds) {
            if (this.customSecurityGroupIds == null) {
                this.customSecurityGroupIds = new SdkInternalList<>(customSecurityGroupIds.length);
            }
            for (String e : customSecurityGroupIds) {
                this.customSecurityGroupIds.add(e);
            }
        }

        public final Collection<String> getDefaultSecurityGroupNames() {
            return defaultSecurityGroupNames;
        }

        @Override
        public final Builder defaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames) {
            this.defaultSecurityGroupNames = StringsCopier.copy(defaultSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultSecurityGroupNames(String... defaultSecurityGroupNames) {
            if (this.defaultSecurityGroupNames == null) {
                this.defaultSecurityGroupNames = new SdkInternalList<>(defaultSecurityGroupNames.length);
            }
            for (String e : defaultSecurityGroupNames) {
                this.defaultSecurityGroupNames.add(e);
            }
            return this;
        }

        public final void setDefaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames) {
            this.defaultSecurityGroupNames = StringsCopier.copy(defaultSecurityGroupNames);
        }

        @SafeVarargs
        public final void setDefaultSecurityGroupNames(String... defaultSecurityGroupNames) {
            if (this.defaultSecurityGroupNames == null) {
                this.defaultSecurityGroupNames = new SdkInternalList<>(defaultSecurityGroupNames.length);
            }
            for (String e : defaultSecurityGroupNames) {
                this.defaultSecurityGroupNames.add(e);
            }
        }

        public final Collection<String> getPackages() {
            return packages;
        }

        @Override
        public final Builder packages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(String... packages) {
            if (this.packages == null) {
                this.packages = new SdkInternalList<>(packages.length);
            }
            for (String e : packages) {
                this.packages.add(e);
            }
            return this;
        }

        public final void setPackages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
        }

        @SafeVarargs
        public final void setPackages(String... packages) {
            if (this.packages == null) {
                this.packages = new SdkInternalList<>(packages.length);
            }
            for (String e : packages) {
                this.packages.add(e);
            }
        }

        public final Collection<VolumeConfiguration> getVolumeConfigurations() {
            return volumeConfigurations;
        }

        @Override
        public final Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(VolumeConfiguration... volumeConfigurations) {
            if (this.volumeConfigurations == null) {
                this.volumeConfigurations = new SdkInternalList<>(volumeConfigurations.length);
            }
            for (VolumeConfiguration e : volumeConfigurations) {
                this.volumeConfigurations.add(e);
            }
            return this;
        }

        public final void setVolumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copy(volumeConfigurations);
        }

        @SafeVarargs
        public final void setVolumeConfigurations(VolumeConfiguration... volumeConfigurations) {
            if (this.volumeConfigurations == null) {
                this.volumeConfigurations = new SdkInternalList<>(volumeConfigurations.length);
            }
            for (VolumeConfiguration e : volumeConfigurations) {
                this.volumeConfigurations.add(e);
            }
        }

        public final Boolean getEnableAutoHealing() {
            return enableAutoHealing;
        }

        @Override
        public final Builder enableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
            return this;
        }

        public final void setEnableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
        }

        public final Boolean getAutoAssignElasticIps() {
            return autoAssignElasticIps;
        }

        @Override
        public final Builder autoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
            return this;
        }

        public final void setAutoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
        }

        public final Boolean getAutoAssignPublicIps() {
            return autoAssignPublicIps;
        }

        @Override
        public final Builder autoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
            return this;
        }

        public final void setAutoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
        }

        public final Recipes getDefaultRecipes() {
            return defaultRecipes;
        }

        @Override
        public final Builder defaultRecipes(Recipes defaultRecipes) {
            this.defaultRecipes = defaultRecipes;
            return this;
        }

        public final void setDefaultRecipes(Recipes defaultRecipes) {
            this.defaultRecipes = defaultRecipes;
        }

        public final Recipes getCustomRecipes() {
            return customRecipes;
        }

        @Override
        public final Builder customRecipes(Recipes customRecipes) {
            this.customRecipes = customRecipes;
            return this;
        }

        public final void setCustomRecipes(Recipes customRecipes) {
            this.customRecipes = customRecipes;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getUseEbsOptimizedInstances() {
            return useEbsOptimizedInstances;
        }

        @Override
        public final Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
            return this;
        }

        public final void setUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
        }

        public final LifecycleEventConfiguration getLifecycleEventConfiguration() {
            return lifecycleEventConfiguration;
        }

        @Override
        public final Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
            return this;
        }

        public final void setLifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
        }

        @Override
        public Layer build() {
            return new Layer(this);
        }
    }
}
