/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>RegisterElasticIp</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterElasticIpResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RegisterElasticIpResponse.Builder, RegisterElasticIpResponse> {
    private final String elasticIp;

    private RegisterElasticIpResponse(BuilderImpl builder) {
        this.elasticIp = builder.elasticIp;
    }

    /**
     * <p>
     * The Elastic IP address.
     * </p>
     * 
     * @return The Elastic IP address.
     */
    public String elasticIp() {
        return elasticIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((elasticIp() == null) ? 0 : elasticIp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterElasticIpResponse)) {
            return false;
        }
        RegisterElasticIpResponse other = (RegisterElasticIpResponse) obj;
        if (other.elasticIp() == null ^ this.elasticIp() == null) {
            return false;
        }
        if (other.elasticIp() != null && !other.elasticIp().equals(this.elasticIp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (elasticIp() != null) {
            sb.append("ElasticIp: ").append(elasticIp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterElasticIpResponse> {
        /**
         * <p>
         * The Elastic IP address.
         * </p>
         * 
         * @param elasticIp
         *        The Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIp(String elasticIp);
    }

    private static final class BuilderImpl implements Builder {
        private String elasticIp;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterElasticIpResponse model) {
            setElasticIp(model.elasticIp);
        }

        public final String getElasticIp() {
            return elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        @Override
        public RegisterElasticIpResponse build() {
            return new RegisterElasticIpResponse(this);
        }
    }
}
