/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.opsworks.transform.StackMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Stack implements StructuredPojo, ToCopyableBuilder<Stack.Builder, Stack> {
    private final String stackId;

    private final String name;

    private final String arn;

    private final String region;

    private final String vpcId;

    private final Map<String, String> attributes;

    private final String serviceRoleArn;

    private final String defaultInstanceProfileArn;

    private final String defaultOs;

    private final String hostnameTheme;

    private final String defaultAvailabilityZone;

    private final String defaultSubnetId;

    private final String customJson;

    private final StackConfigurationManager configurationManager;

    private final ChefConfiguration chefConfiguration;

    private final Boolean useCustomCookbooks;

    private final Boolean useOpsworksSecurityGroups;

    private final Source customCookbooksSource;

    private final String defaultSshKeyName;

    private final String createdAt;

    private final String defaultRootDeviceType;

    private final String agentVersion;

    private Stack(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.region = builder.region;
        this.vpcId = builder.vpcId;
        this.attributes = builder.attributes;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.defaultInstanceProfileArn = builder.defaultInstanceProfileArn;
        this.defaultOs = builder.defaultOs;
        this.hostnameTheme = builder.hostnameTheme;
        this.defaultAvailabilityZone = builder.defaultAvailabilityZone;
        this.defaultSubnetId = builder.defaultSubnetId;
        this.customJson = builder.customJson;
        this.configurationManager = builder.configurationManager;
        this.chefConfiguration = builder.chefConfiguration;
        this.useCustomCookbooks = builder.useCustomCookbooks;
        this.useOpsworksSecurityGroups = builder.useOpsworksSecurityGroups;
        this.customCookbooksSource = builder.customCookbooksSource;
        this.defaultSshKeyName = builder.defaultSshKeyName;
        this.createdAt = builder.createdAt;
        this.defaultRootDeviceType = builder.defaultRootDeviceType;
        this.agentVersion = builder.agentVersion;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The stack name.
     * </p>
     * 
     * @return The stack name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The stack's ARN.
     * </p>
     * 
     * @return The stack's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The VPC ID; applicable only if the stack is running in a VPC.
     * </p>
     * 
     * @return The VPC ID; applicable only if the stack is running in a VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The stack's attributes.
     * </p>
     * 
     * @return The stack's attributes.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The stack AWS Identity and Access Management (IAM) role.
     * </p>
     * 
     * @return The stack AWS Identity and Access Management (IAM) role.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information
     * about IAM ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
     * Identifiers</a>.
     * </p>
     * 
     * @return The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more
     *         information about IAM ARNs, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     */
    public String defaultInstanceProfileArn() {
        return defaultInstanceProfileArn;
    }

    /**
     * <p>
     * The stack's default operating system.
     * </p>
     * 
     * @return The stack's default operating system.
     */
    public String defaultOs() {
        return defaultOs;
    }

    /**
     * <p>
     * The stack host name theme, with spaces replaced by underscores.
     * </p>
     * 
     * @return The stack host name theme, with spaces replaced by underscores.
     */
    public String hostnameTheme() {
        return hostnameTheme;
    }

    /**
     * <p>
     * The stack's default Availability Zone. For more information, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The stack's default Availability Zone. For more information, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String defaultAvailabilityZone() {
        return defaultAvailabilityZone;
    }

    /**
     * <p>
     * The default subnet ID; applicable only if the stack is running in a VPC.
     * </p>
     * 
     * @return The default subnet ID; applicable only if the stack is running in a VPC.
     */
    public String defaultSubnetId() {
        return defaultSubnetId;
    }

    /**
     * <p>
     * A JSON object that contains user-defined attributes to be added to the stack configuration and deployment
     * attributes. You can use custom JSON to override the corresponding default stack configuration attribute values or
     * to pass data to recipes. The string should be in the following format:
     * </p>
     * <p>
     * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     * </p>
     * <p>
     * For more information on custom JSON, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the
     * Stack Configuration Attributes</a>.
     * </p>
     * 
     * @return A JSON object that contains user-defined attributes to be added to the stack configuration and deployment
     *         attributes. You can use custom JSON to override the corresponding default stack configuration attribute
     *         values or to pass data to recipes. The string should be in the following format:</p>
     *         <p>
     *         <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     *         </p>
     *         <p>
     *         For more information on custom JSON, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
     *         Modify the Stack Configuration Attributes</a>.
     */
    public String customJson() {
        return customJson;
    }

    /**
     * <p>
     * The configuration manager.
     * </p>
     * 
     * @return The configuration manager.
     */
    public StackConfigurationManager configurationManager() {
        return configurationManager;
    }

    /**
     * <p>
     * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version. For
     * more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.
     * </p>
     * 
     * @return A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf
     *         version. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
     *         Stack</a>.
     */
    public ChefConfiguration chefConfiguration() {
        return chefConfiguration;
    }

    /**
     * <p>
     * Whether the stack uses custom cookbooks.
     * </p>
     * 
     * @return Whether the stack uses custom cookbooks.
     */
    public Boolean useCustomCookbooks() {
        return useCustomCookbooks;
    }

    /**
     * <p>
     * Whether the stack automatically associates the AWS OpsWorks Stacks built-in security groups with the stack's
     * layers.
     * </p>
     * 
     * @return Whether the stack automatically associates the AWS OpsWorks Stacks built-in security groups with the
     *         stack's layers.
     */
    public Boolean useOpsworksSecurityGroups() {
        return useOpsworksSecurityGroups;
    }

    /**
     *
     * @return
     */
    public Source customCookbooksSource() {
        return customCookbooksSource;
    }

    /**
     * <p>
     * A default Amazon EC2 key pair for the stack's instances. You can override this value when you create or update an
     * instance.
     * </p>
     * 
     * @return A default Amazon EC2 key pair for the stack's instances. You can override this value when you create or
     *         update an instance.
     */
    public String defaultSshKeyName() {
        return defaultSshKeyName;
    }

    /**
     * <p>
     * The date when the stack was created.
     * </p>
     * 
     * @return The date when the stack was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The default root device type. This value is used by default for all instances in the stack, but you can override
     * it when you create an instance. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage
     * for the Root Device</a>.
     * </p>
     * 
     * @return The default root device type. This value is used by default for all instances in the stack, but you can
     *         override it when you create an instance. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public String defaultRootDeviceType() {
        return defaultRootDeviceType;
    }

    /**
     * <p>
     * The agent version. This parameter is set to <code>LATEST</code> for auto-update. or a version number for a fixed
     * agent version.
     * </p>
     * 
     * @return The agent version. This parameter is set to <code>LATEST</code> for auto-update. or a version number for
     *         a fixed agent version.
     */
    public String agentVersion() {
        return agentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((region() == null) ? 0 : region().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        hashCode = 31 * hashCode + ((attributes() == null) ? 0 : attributes().hashCode());
        hashCode = 31 * hashCode + ((serviceRoleArn() == null) ? 0 : serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + ((defaultInstanceProfileArn() == null) ? 0 : defaultInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + ((defaultOs() == null) ? 0 : defaultOs().hashCode());
        hashCode = 31 * hashCode + ((hostnameTheme() == null) ? 0 : hostnameTheme().hashCode());
        hashCode = 31 * hashCode + ((defaultAvailabilityZone() == null) ? 0 : defaultAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + ((defaultSubnetId() == null) ? 0 : defaultSubnetId().hashCode());
        hashCode = 31 * hashCode + ((customJson() == null) ? 0 : customJson().hashCode());
        hashCode = 31 * hashCode + ((configurationManager() == null) ? 0 : configurationManager().hashCode());
        hashCode = 31 * hashCode + ((chefConfiguration() == null) ? 0 : chefConfiguration().hashCode());
        hashCode = 31 * hashCode + ((useCustomCookbooks() == null) ? 0 : useCustomCookbooks().hashCode());
        hashCode = 31 * hashCode + ((useOpsworksSecurityGroups() == null) ? 0 : useOpsworksSecurityGroups().hashCode());
        hashCode = 31 * hashCode + ((customCookbooksSource() == null) ? 0 : customCookbooksSource().hashCode());
        hashCode = 31 * hashCode + ((defaultSshKeyName() == null) ? 0 : defaultSshKeyName().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((defaultRootDeviceType() == null) ? 0 : defaultRootDeviceType().hashCode());
        hashCode = 31 * hashCode + ((agentVersion() == null) ? 0 : agentVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.defaultInstanceProfileArn() == null ^ this.defaultInstanceProfileArn() == null) {
            return false;
        }
        if (other.defaultInstanceProfileArn() != null
                && !other.defaultInstanceProfileArn().equals(this.defaultInstanceProfileArn())) {
            return false;
        }
        if (other.defaultOs() == null ^ this.defaultOs() == null) {
            return false;
        }
        if (other.defaultOs() != null && !other.defaultOs().equals(this.defaultOs())) {
            return false;
        }
        if (other.hostnameTheme() == null ^ this.hostnameTheme() == null) {
            return false;
        }
        if (other.hostnameTheme() != null && !other.hostnameTheme().equals(this.hostnameTheme())) {
            return false;
        }
        if (other.defaultAvailabilityZone() == null ^ this.defaultAvailabilityZone() == null) {
            return false;
        }
        if (other.defaultAvailabilityZone() != null && !other.defaultAvailabilityZone().equals(this.defaultAvailabilityZone())) {
            return false;
        }
        if (other.defaultSubnetId() == null ^ this.defaultSubnetId() == null) {
            return false;
        }
        if (other.defaultSubnetId() != null && !other.defaultSubnetId().equals(this.defaultSubnetId())) {
            return false;
        }
        if (other.customJson() == null ^ this.customJson() == null) {
            return false;
        }
        if (other.customJson() != null && !other.customJson().equals(this.customJson())) {
            return false;
        }
        if (other.configurationManager() == null ^ this.configurationManager() == null) {
            return false;
        }
        if (other.configurationManager() != null && !other.configurationManager().equals(this.configurationManager())) {
            return false;
        }
        if (other.chefConfiguration() == null ^ this.chefConfiguration() == null) {
            return false;
        }
        if (other.chefConfiguration() != null && !other.chefConfiguration().equals(this.chefConfiguration())) {
            return false;
        }
        if (other.useCustomCookbooks() == null ^ this.useCustomCookbooks() == null) {
            return false;
        }
        if (other.useCustomCookbooks() != null && !other.useCustomCookbooks().equals(this.useCustomCookbooks())) {
            return false;
        }
        if (other.useOpsworksSecurityGroups() == null ^ this.useOpsworksSecurityGroups() == null) {
            return false;
        }
        if (other.useOpsworksSecurityGroups() != null
                && !other.useOpsworksSecurityGroups().equals(this.useOpsworksSecurityGroups())) {
            return false;
        }
        if (other.customCookbooksSource() == null ^ this.customCookbooksSource() == null) {
            return false;
        }
        if (other.customCookbooksSource() != null && !other.customCookbooksSource().equals(this.customCookbooksSource())) {
            return false;
        }
        if (other.defaultSshKeyName() == null ^ this.defaultSshKeyName() == null) {
            return false;
        }
        if (other.defaultSshKeyName() != null && !other.defaultSshKeyName().equals(this.defaultSshKeyName())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.defaultRootDeviceType() == null ^ this.defaultRootDeviceType() == null) {
            return false;
        }
        if (other.defaultRootDeviceType() != null && !other.defaultRootDeviceType().equals(this.defaultRootDeviceType())) {
            return false;
        }
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        if (other.agentVersion() != null && !other.agentVersion().equals(this.agentVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (region() != null) {
            sb.append("Region: ").append(region()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        if (serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(serviceRoleArn()).append(",");
        }
        if (defaultInstanceProfileArn() != null) {
            sb.append("DefaultInstanceProfileArn: ").append(defaultInstanceProfileArn()).append(",");
        }
        if (defaultOs() != null) {
            sb.append("DefaultOs: ").append(defaultOs()).append(",");
        }
        if (hostnameTheme() != null) {
            sb.append("HostnameTheme: ").append(hostnameTheme()).append(",");
        }
        if (defaultAvailabilityZone() != null) {
            sb.append("DefaultAvailabilityZone: ").append(defaultAvailabilityZone()).append(",");
        }
        if (defaultSubnetId() != null) {
            sb.append("DefaultSubnetId: ").append(defaultSubnetId()).append(",");
        }
        if (customJson() != null) {
            sb.append("CustomJson: ").append(customJson()).append(",");
        }
        if (configurationManager() != null) {
            sb.append("ConfigurationManager: ").append(configurationManager()).append(",");
        }
        if (chefConfiguration() != null) {
            sb.append("ChefConfiguration: ").append(chefConfiguration()).append(",");
        }
        if (useCustomCookbooks() != null) {
            sb.append("UseCustomCookbooks: ").append(useCustomCookbooks()).append(",");
        }
        if (useOpsworksSecurityGroups() != null) {
            sb.append("UseOpsworksSecurityGroups: ").append(useOpsworksSecurityGroups()).append(",");
        }
        if (customCookbooksSource() != null) {
            sb.append("CustomCookbooksSource: ").append(customCookbooksSource()).append(",");
        }
        if (defaultSshKeyName() != null) {
            sb.append("DefaultSshKeyName: ").append(defaultSshKeyName()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (defaultRootDeviceType() != null) {
            sb.append("DefaultRootDeviceType: ").append(defaultRootDeviceType()).append(",");
        }
        if (agentVersion() != null) {
            sb.append("AgentVersion: ").append(agentVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Stack> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The stack name.
         * </p>
         * 
         * @param name
         *        The stack name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The stack's ARN.
         * </p>
         * 
         * @param arn
         *        The stack's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param region
         *        The stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The VPC ID; applicable only if the stack is running in a VPC.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID; applicable only if the stack is running in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The stack's attributes.
         * </p>
         * 
         * @param attributes
         *        The stack's attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The stack AWS Identity and Access Management (IAM) role.
         * </p>
         * 
         * @param serviceRoleArn
         *        The stack AWS Identity and Access Management (IAM) role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more
         * information about IAM ARNs, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * </p>
         * 
         * @param defaultInstanceProfileArn
         *        The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more
         *        information about IAM ARNs, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceProfileArn(String defaultInstanceProfileArn);

        /**
         * <p>
         * The stack's default operating system.
         * </p>
         * 
         * @param defaultOs
         *        The stack's default operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOs(String defaultOs);

        /**
         * <p>
         * The stack host name theme, with spaces replaced by underscores.
         * </p>
         * 
         * @param hostnameTheme
         *        The stack host name theme, with spaces replaced by underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostnameTheme(String hostnameTheme);

        /**
         * <p>
         * The stack's default Availability Zone. For more information, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param defaultAvailabilityZone
         *        The stack's default Availability Zone. For more information, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAvailabilityZone(String defaultAvailabilityZone);

        /**
         * <p>
         * The default subnet ID; applicable only if the stack is running in a VPC.
         * </p>
         * 
         * @param defaultSubnetId
         *        The default subnet ID; applicable only if the stack is running in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubnetId(String defaultSubnetId);

        /**
         * <p>
         * A JSON object that contains user-defined attributes to be added to the stack configuration and deployment
         * attributes. You can use custom JSON to override the corresponding default stack configuration attribute
         * values or to pass data to recipes. The string should be in the following format:
         * </p>
         * <p>
         * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         * </p>
         * <p>
         * For more information on custom JSON, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify
         * the Stack Configuration Attributes</a>.
         * </p>
         * 
         * @param customJson
         *        A JSON object that contains user-defined attributes to be added to the stack configuration and
         *        deployment attributes. You can use custom JSON to override the corresponding default stack
         *        configuration attribute values or to pass data to recipes. The string should be in the following
         *        format:</p>
         *        <p>
         *        <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         *        </p>
         *        <p>
         *        For more information on custom JSON, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
         *        Modify the Stack Configuration Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * The configuration manager.
         * </p>
         * 
         * @param configurationManager
         *        The configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManager(StackConfigurationManager configurationManager);

        /**
         * <p>
         * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version.
         * For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         * Stack</a>.
         * </p>
         * 
         * @param chefConfiguration
         *        A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf
         *        version. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         *        Stack</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chefConfiguration(ChefConfiguration chefConfiguration);

        /**
         * <p>
         * Whether the stack uses custom cookbooks.
         * </p>
         * 
         * @param useCustomCookbooks
         *        Whether the stack uses custom cookbooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCustomCookbooks(Boolean useCustomCookbooks);

        /**
         * <p>
         * Whether the stack automatically associates the AWS OpsWorks Stacks built-in security groups with the stack's
         * layers.
         * </p>
         * 
         * @param useOpsworksSecurityGroups
         *        Whether the stack automatically associates the AWS OpsWorks Stacks built-in security groups with the
         *        stack's layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups);

        /**
         *
         * @param customCookbooksSource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCookbooksSource(Source customCookbooksSource);

        /**
         * <p>
         * A default Amazon EC2 key pair for the stack's instances. You can override this value when you create or
         * update an instance.
         * </p>
         * 
         * @param defaultSshKeyName
         *        A default Amazon EC2 key pair for the stack's instances. You can override this value when you create
         *        or update an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSshKeyName(String defaultSshKeyName);

        /**
         * <p>
         * The date when the stack was created.
         * </p>
         * 
         * @param createdAt
         *        The date when the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The default root device type. This value is used by default for all instances in the stack, but you can
         * override it when you create an instance. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         * >Storage for the Root Device</a>.
         * </p>
         * 
         * @param defaultRootDeviceType
         *        The default root device type. This value is used by default for all instances in the stack, but you
         *        can override it when you create an instance. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder defaultRootDeviceType(String defaultRootDeviceType);

        /**
         * <p>
         * The default root device type. This value is used by default for all instances in the stack, but you can
         * override it when you create an instance. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         * >Storage for the Root Device</a>.
         * </p>
         * 
         * @param defaultRootDeviceType
         *        The default root device type. This value is used by default for all instances in the stack, but you
         *        can override it when you create an instance. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType);

        /**
         * <p>
         * The agent version. This parameter is set to <code>LATEST</code> for auto-update. or a version number for a
         * fixed agent version.
         * </p>
         * 
         * @param agentVersion
         *        The agent version. This parameter is set to <code>LATEST</code> for auto-update. or a version number
         *        for a fixed agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String stackId;

        private String name;

        private String arn;

        private String region;

        private String vpcId;

        private Map<String, String> attributes = new SdkInternalMap<>();

        private String serviceRoleArn;

        private String defaultInstanceProfileArn;

        private String defaultOs;

        private String hostnameTheme;

        private String defaultAvailabilityZone;

        private String defaultSubnetId;

        private String customJson;

        private StackConfigurationManager configurationManager;

        private ChefConfiguration chefConfiguration;

        private Boolean useCustomCookbooks;

        private Boolean useOpsworksSecurityGroups;

        private Source customCookbooksSource;

        private String defaultSshKeyName;

        private String createdAt;

        private String defaultRootDeviceType;

        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            setStackId(model.stackId);
            setName(model.name);
            setArn(model.arn);
            setRegion(model.region);
            setVpcId(model.vpcId);
            setAttributes(model.attributes);
            setServiceRoleArn(model.serviceRoleArn);
            setDefaultInstanceProfileArn(model.defaultInstanceProfileArn);
            setDefaultOs(model.defaultOs);
            setHostnameTheme(model.hostnameTheme);
            setDefaultAvailabilityZone(model.defaultAvailabilityZone);
            setDefaultSubnetId(model.defaultSubnetId);
            setCustomJson(model.customJson);
            setConfigurationManager(model.configurationManager);
            setChefConfiguration(model.chefConfiguration);
            setUseCustomCookbooks(model.useCustomCookbooks);
            setUseOpsworksSecurityGroups(model.useOpsworksSecurityGroups);
            setCustomCookbooksSource(model.customCookbooksSource);
            setDefaultSshKeyName(model.defaultSshKeyName);
            setCreatedAt(model.createdAt);
            setDefaultRootDeviceType(model.defaultRootDeviceType);
            setAgentVersion(model.agentVersion);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getDefaultInstanceProfileArn() {
            return defaultInstanceProfileArn;
        }

        @Override
        public final Builder defaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
            return this;
        }

        public final void setDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
        }

        public final String getDefaultOs() {
            return defaultOs;
        }

        @Override
        public final Builder defaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
            return this;
        }

        public final void setDefaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
        }

        public final String getHostnameTheme() {
            return hostnameTheme;
        }

        @Override
        public final Builder hostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
            return this;
        }

        public final void setHostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
        }

        public final String getDefaultAvailabilityZone() {
            return defaultAvailabilityZone;
        }

        @Override
        public final Builder defaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
            return this;
        }

        public final void setDefaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
        }

        public final String getDefaultSubnetId() {
            return defaultSubnetId;
        }

        @Override
        public final Builder defaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
            return this;
        }

        public final void setDefaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final StackConfigurationManager getConfigurationManager() {
            return configurationManager;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
        }

        public final ChefConfiguration getChefConfiguration() {
            return chefConfiguration;
        }

        @Override
        public final Builder chefConfiguration(ChefConfiguration chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
            return this;
        }

        public final void setChefConfiguration(ChefConfiguration chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
        }

        public final Boolean getUseCustomCookbooks() {
            return useCustomCookbooks;
        }

        @Override
        public final Builder useCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
            return this;
        }

        public final void setUseCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
        }

        public final Boolean getUseOpsworksSecurityGroups() {
            return useOpsworksSecurityGroups;
        }

        @Override
        public final Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
            return this;
        }

        public final void setUseOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
        }

        public final Source getCustomCookbooksSource() {
            return customCookbooksSource;
        }

        @Override
        public final Builder customCookbooksSource(Source customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
            return this;
        }

        public final void setCustomCookbooksSource(Source customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
        }

        public final String getDefaultSshKeyName() {
            return defaultSshKeyName;
        }

        @Override
        public final Builder defaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
            return this;
        }

        public final void setDefaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDefaultRootDeviceType() {
            return defaultRootDeviceType;
        }

        @Override
        public final Builder defaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
            return this;
        }

        @Override
        public final Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
            this.defaultRootDeviceType(defaultRootDeviceType.toString());
            return this;
        }

        public final void setDefaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
        }

        public final void setDefaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
            this.defaultRootDeviceType(defaultRootDeviceType.toString());
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public Stack build() {
            return new Stack(this);
        }
    }
}
