/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.VolumeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance's Amazon EBS volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Volume implements StructuredPojo, ToCopyableBuilder<Volume.Builder, Volume> {
    private final String volumeId;

    private final String ec2VolumeId;

    private final String name;

    private final String raidArrayId;

    private final String instanceId;

    private final String status;

    private final Integer size;

    private final String device;

    private final String mountPoint;

    private final String region;

    private final String availabilityZone;

    private final String volumeType;

    private final Integer iops;

    private Volume(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.ec2VolumeId = builder.ec2VolumeId;
        this.name = builder.name;
        this.raidArrayId = builder.raidArrayId;
        this.instanceId = builder.instanceId;
        this.status = builder.status;
        this.size = builder.size;
        this.device = builder.device;
        this.mountPoint = builder.mountPoint;
        this.region = builder.region;
        this.availabilityZone = builder.availabilityZone;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
    }

    /**
     * <p>
     * The volume ID.
     * </p>
     * 
     * @return The volume ID.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The Amazon EC2 volume ID.
     * </p>
     * 
     * @return The Amazon EC2 volume ID.
     */
    public String ec2VolumeId() {
        return ec2VolumeId;
    }

    /**
     * <p>
     * The volume name.
     * </p>
     * 
     * @return The volume name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The RAID array ID.
     * </p>
     * 
     * @return The RAID array ID.
     */
    public String raidArrayId() {
        return raidArrayId;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The value returned by <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html"
     * >DescribeVolumes</a>.
     * </p>
     * 
     * @return The value returned by <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html"
     *         >DescribeVolumes</a>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The volume size.
     * </p>
     * 
     * @return The volume size.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * The device name.
     * </p>
     * 
     * @return The device name.
     */
    public String device() {
        return device;
    }

    /**
     * <p>
     * The volume mount point. For example, "/mnt/disk1".
     * </p>
     * 
     * @return The volume mount point. For example, "/mnt/disk1".
     */
    public String mountPoint() {
        return mountPoint;
    }

    /**
     * <p>
     * The AWS region. For more information about AWS regions, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The AWS region. For more information about AWS regions, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The volume Availability Zone. For more information, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The volume Availability Zone. For more information, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The volume type, standard or PIOPS.
     * </p>
     * 
     * @return The volume type, standard or PIOPS.
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * For PIOPS volumes, the IOPS per disk.
     * </p>
     * 
     * @return For PIOPS volumes, the IOPS per disk.
     */
    public Integer iops() {
        return iops;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((volumeId() == null) ? 0 : volumeId().hashCode());
        hashCode = 31 * hashCode + ((ec2VolumeId() == null) ? 0 : ec2VolumeId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((raidArrayId() == null) ? 0 : raidArrayId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((size() == null) ? 0 : size().hashCode());
        hashCode = 31 * hashCode + ((device() == null) ? 0 : device().hashCode());
        hashCode = 31 * hashCode + ((mountPoint() == null) ? 0 : mountPoint().hashCode());
        hashCode = 31 * hashCode + ((region() == null) ? 0 : region().hashCode());
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((volumeType() == null) ? 0 : volumeType().hashCode());
        hashCode = 31 * hashCode + ((iops() == null) ? 0 : iops().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume) obj;
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.ec2VolumeId() == null ^ this.ec2VolumeId() == null) {
            return false;
        }
        if (other.ec2VolumeId() != null && !other.ec2VolumeId().equals(this.ec2VolumeId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.raidArrayId() == null ^ this.raidArrayId() == null) {
            return false;
        }
        if (other.raidArrayId() != null && !other.raidArrayId().equals(this.raidArrayId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.mountPoint() == null ^ this.mountPoint() == null) {
            return false;
        }
        if (other.mountPoint() != null && !other.mountPoint().equals(this.mountPoint())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        if (ec2VolumeId() != null) {
            sb.append("Ec2VolumeId: ").append(ec2VolumeId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (raidArrayId() != null) {
            sb.append("RaidArrayId: ").append(raidArrayId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        if (device() != null) {
            sb.append("Device: ").append(device()).append(",");
        }
        if (mountPoint() != null) {
            sb.append("MountPoint: ").append(mountPoint()).append(",");
        }
        if (region() != null) {
            sb.append("Region: ").append(region()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (volumeType() != null) {
            sb.append("VolumeType: ").append(volumeType()).append(",");
        }
        if (iops() != null) {
            sb.append("Iops: ").append(iops()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VolumeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Volume> {
        /**
         * <p>
         * The volume ID.
         * </p>
         * 
         * @param volumeId
         *        The volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The Amazon EC2 volume ID.
         * </p>
         * 
         * @param ec2VolumeId
         *        The Amazon EC2 volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2VolumeId(String ec2VolumeId);

        /**
         * <p>
         * The volume name.
         * </p>
         * 
         * @param name
         *        The volume name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The RAID array ID.
         * </p>
         * 
         * @param raidArrayId
         *        The RAID array ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrayId(String raidArrayId);

        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The value returned by <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html"
         * >DescribeVolumes</a>.
         * </p>
         * 
         * @param status
         *        The value returned by <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html"
         *        >DescribeVolumes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The volume size.
         * </p>
         * 
         * @param size
         *        The volume size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The device name.
         * </p>
         * 
         * @param device
         *        The device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * The volume mount point. For example, "/mnt/disk1".
         * </p>
         * 
         * @param mountPoint
         *        The volume mount point. For example, "/mnt/disk1".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoint(String mountPoint);

        /**
         * <p>
         * The AWS region. For more information about AWS regions, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param region
         *        The AWS region. For more information about AWS regions, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The volume Availability Zone. For more information, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param availabilityZone
         *        The volume Availability Zone. For more information, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The volume type, standard or PIOPS.
         * </p>
         * 
         * @param volumeType
         *        The volume type, standard or PIOPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * For PIOPS volumes, the IOPS per disk.
         * </p>
         * 
         * @param iops
         *        For PIOPS volumes, the IOPS per disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);
    }

    private static final class BuilderImpl implements Builder {
        private String volumeId;

        private String ec2VolumeId;

        private String name;

        private String raidArrayId;

        private String instanceId;

        private String status;

        private Integer size;

        private String device;

        private String mountPoint;

        private String region;

        private String availabilityZone;

        private String volumeType;

        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            setVolumeId(model.volumeId);
            setEc2VolumeId(model.ec2VolumeId);
            setName(model.name);
            setRaidArrayId(model.raidArrayId);
            setInstanceId(model.instanceId);
            setStatus(model.status);
            setSize(model.size);
            setDevice(model.device);
            setMountPoint(model.mountPoint);
            setRegion(model.region);
            setAvailabilityZone(model.availabilityZone);
            setVolumeType(model.volumeType);
            setIops(model.iops);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final String getEc2VolumeId() {
            return ec2VolumeId;
        }

        @Override
        public final Builder ec2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
            return this;
        }

        public final void setEc2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRaidArrayId() {
            return raidArrayId;
        }

        @Override
        public final Builder raidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
            return this;
        }

        public final void setRaidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getDevice() {
            return device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getMountPoint() {
            return mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public Volume build() {
            return new Volume(this);
        }
    }
}
