/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.opsworks.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * InstancesCount JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstancesCountUnmarshaller implements Unmarshaller<InstancesCount, JsonUnmarshallerContext> {

    public InstancesCount unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstancesCount.Builder instancesCountBuilder = InstancesCount.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Assigning", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.assigning(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Booting", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.booting(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ConnectionLost", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.connectionLost(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Deregistering", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.deregistering(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Online", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.online(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Pending", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.pending(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Rebooting", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.rebooting(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Registered", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.registered(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Registering", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.registering(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Requested", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.requested(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("RunningSetup", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.runningSetup(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("SetupFailed", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.setupFailed(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ShuttingDown", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.shuttingDown(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("StartFailed", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.startFailed(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Stopped", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.stopped(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Stopping", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.stopping(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Terminated", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.terminated(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Terminating", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.terminating(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Unassigning", targetDepth)) {
                    context.nextToken();
                    instancesCountBuilder.unassigning(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return instancesCountBuilder.build();
    }

    private static InstancesCountUnmarshaller INSTANCE;

    public static InstancesCountUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new InstancesCountUnmarshaller();
        return INSTANCE;
    }
}