/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.DeploymentCommand;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.services.opsworks.transform.DeploymentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Deployment
implements StructuredPojo,
ToCopyableBuilder<Builder, Deployment> {
    private final String deploymentId;
    private final String stackId;
    private final String appId;
    private final String createdAt;
    private final String completedAt;
    private final Integer duration;
    private final String iamUserArn;
    private final String comment;
    private final DeploymentCommand command;
    private final String status;
    private final String customJson;
    private final List<String> instanceIds;

    private Deployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.duration = builder.duration;
        this.iamUserArn = builder.iamUserArn;
        this.comment = builder.comment;
        this.command = builder.command;
        this.status = builder.status;
        this.customJson = builder.customJson;
        this.instanceIds = builder.instanceIds;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String stackId() {
        return this.stackId;
    }

    public String appId() {
        return this.appId;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public String completedAt() {
        return this.completedAt;
    }

    public Integer duration() {
        return this.duration;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public String comment() {
        return this.comment;
    }

    public DeploymentCommand command() {
        return this.command;
    }

    public String status() {
        return this.status;
    }

    public String customJson() {
        return this.customJson;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentId() == null ? 0 : this.deploymentId().hashCode());
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.appId() == null ? 0 : this.appId().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.completedAt() == null ? 0 : this.completedAt().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.iamUserArn() == null ? 0 : this.iamUserArn().hashCode());
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        hashCode = 31 * hashCode + (this.command() == null ? 0 : this.command().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.customJson() == null ? 0 : this.customJson().hashCode());
        hashCode = 31 * hashCode + (this.instanceIds() == null ? 0 : this.instanceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.appId() == null ^ this.appId() == null) {
            return false;
        }
        if (other.appId() != null && !other.appId().equals(this.appId())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.completedAt() == null ^ this.completedAt() == null) {
            return false;
        }
        if (other.completedAt() != null && !other.completedAt().equals(this.completedAt())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.iamUserArn() == null ^ this.iamUserArn() == null) {
            return false;
        }
        if (other.iamUserArn() != null && !other.iamUserArn().equals(this.iamUserArn())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.command() == null ^ this.command() == null) {
            return false;
        }
        if (other.command() != null && !other.command().equals(this.command())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.customJson() == null ^ this.customJson() == null) {
            return false;
        }
        if (other.customJson() != null && !other.customJson().equals(this.customJson())) {
            return false;
        }
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        return other.instanceIds() == null || other.instanceIds().equals(this.instanceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deploymentId() != null) {
            sb.append("DeploymentId: ").append(this.deploymentId()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.appId() != null) {
            sb.append("AppId: ").append(this.appId()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.completedAt() != null) {
            sb.append("CompletedAt: ").append(this.completedAt()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.iamUserArn() != null) {
            sb.append("IamUserArn: ").append(this.iamUserArn()).append(",");
        }
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (this.command() != null) {
            sb.append("Command: ").append(this.command()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.customJson() != null) {
            sb.append("CustomJson: ").append(this.customJson()).append(",");
        }
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String stackId;
        private String appId;
        private String createdAt;
        private String completedAt;
        private Integer duration;
        private String iamUserArn;
        private String comment;
        private DeploymentCommand command;
        private String status;
        private String customJson;
        private List<String> instanceIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.setDeploymentId(model.deploymentId);
            this.setStackId(model.stackId);
            this.setAppId(model.appId);
            this.setCreatedAt(model.createdAt);
            this.setCompletedAt(model.completedAt);
            this.setDuration(model.duration);
            this.setIamUserArn(model.iamUserArn);
            this.setComment(model.comment);
            this.setCommand(model.command);
            this.setStatus(model.status);
            this.setCustomJson(model.customJson);
            this.setInstanceIds(model.instanceIds);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCompletedAt() {
            return this.completedAt;
        }

        @Override
        public final Builder completedAt(String completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(String completedAt) {
            this.completedAt = completedAt;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final DeploymentCommand getCommand() {
            return this.command;
        }

        @Override
        public final Builder command(DeploymentCommand command) {
            this.command = command;
            return this;
        }

        public final void setCommand(DeploymentCommand command) {
            this.command = command;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCustomJson() {
            return this.customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
        }

        @SafeVarargs
        public final void setInstanceIds(String ... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
        }

        public Deployment build() {
            return new Deployment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Deployment> {
        public Builder deploymentId(String var1);

        public Builder stackId(String var1);

        public Builder appId(String var1);

        public Builder createdAt(String var1);

        public Builder completedAt(String var1);

        public Builder duration(Integer var1);

        public Builder iamUserArn(String var1);

        public Builder comment(String var1);

        public Builder command(DeploymentCommand var1);

        public Builder status(String var1);

        public Builder customJson(String var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);
    }
}

