/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticIpsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeElasticIpsRequest> {
    private final String instanceId;
    private final String stackId;
    private final List<String> ips;

    private DescribeElasticIpsRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.ips = builder.ips;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> ips() {
        return this.ips;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.ips() == null ? 0 : this.ips().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticIpsRequest)) {
            return false;
        }
        DescribeElasticIpsRequest other = (DescribeElasticIpsRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.ips() == null ^ this.ips() == null) {
            return false;
        }
        return other.ips() == null || other.ips().equals(this.ips());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.ips() != null) {
            sb.append("Ips: ").append(this.ips()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String stackId;
        private List<String> ips = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticIpsRequest model) {
            this.setInstanceId(model.instanceId);
            this.setStackId(model.stackId);
            this.setIps(model.ips);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getIps() {
            return this.ips;
        }

        @Override
        public final Builder ips(Collection<String> ips) {
            this.ips = StringsCopier.copy(ips);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ips(String ... ips) {
            if (this.ips == null) {
                this.ips = new SdkInternalList(ips.length);
            }
            for (String e : ips) {
                this.ips.add(e);
            }
            return this;
        }

        public final void setIps(Collection<String> ips) {
            this.ips = StringsCopier.copy(ips);
        }

        @SafeVarargs
        public final void setIps(String ... ips) {
            if (this.ips == null) {
                this.ips = new SdkInternalList(ips.length);
            }
            for (String e : ips) {
                this.ips.add(e);
            }
        }

        public DescribeElasticIpsRequest build() {
            return new DescribeElasticIpsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticIpsRequest> {
        public Builder instanceId(String var1);

        public Builder stackId(String var1);

        public Builder ips(Collection<String> var1);

        public Builder ips(String ... var1);
    }
}

