/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.CreateAppRequest;

@SdkInternalApi
public class CreateAppRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").build();
    private static final MarshallingInfo<String> SHORTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shortname").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> DATASOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSources").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<StructuredPojo> APPSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppSource").build();
    private static final MarshallingInfo<List> DOMAINS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Domains").build();
    private static final MarshallingInfo<Boolean> ENABLESSL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableSsl").build();
    private static final MarshallingInfo<StructuredPojo> SSLCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SslConfiguration").build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").build();
    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").build();
    private static final CreateAppRequestModelMarshaller instance = new CreateAppRequestModelMarshaller();

    public static CreateAppRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(CreateAppRequest createAppRequest, ProtocolMarshaller protocolMarshaller) {
        if (createAppRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createAppRequest.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.shortname(), SHORTNAME_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(createAppRequest.dataSources(), DATASOURCES_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.appSource(), APPSOURCE_BINDING);
            protocolMarshaller.marshall(createAppRequest.domains(), DOMAINS_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.enableSsl(), ENABLESSL_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.sslConfiguration(), SSLCONFIGURATION_BINDING);
            protocolMarshaller.marshall(createAppRequest.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(createAppRequest.environment(), ENVIRONMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

