/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.TemporaryCredential;

@SdkInternalApi
public class TemporaryCredentialMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").build();
    private static final MarshallingInfo<Integer> VALIDFORINMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidForInMinutes").build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final TemporaryCredentialMarshaller instance = new TemporaryCredentialMarshaller();

    public static TemporaryCredentialMarshaller getInstance() {
        return instance;
    }

    public void marshall(TemporaryCredential temporaryCredential, ProtocolMarshaller protocolMarshaller) {
        if (temporaryCredential == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)temporaryCredential.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)temporaryCredential.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)temporaryCredential.validForInMinutes(), VALIDFORINMINUTES_BINDING);
            protocolMarshaller.marshall((Object)temporaryCredential.instanceId(), INSTANCEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

