/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.opsworks.OpsWorksClient;
import software.amazon.awssdk.services.opsworks.model.DescribeAppsRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeDeploymentsRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.opsworks.waiters.DeploymentSuccessful;
import software.amazon.awssdk.services.opsworks.waiters.DescribeAppsFunction;
import software.amazon.awssdk.services.opsworks.waiters.DescribeDeploymentsFunction;
import software.amazon.awssdk.services.opsworks.waiters.DescribeInstancesFunction;
import software.amazon.awssdk.services.opsworks.waiters.InstanceOnline;
import software.amazon.awssdk.services.opsworks.waiters.InstanceRegistered;
import software.amazon.awssdk.services.opsworks.waiters.InstanceStopped;
import software.amazon.awssdk.services.opsworks.waiters.InstanceTerminated;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.HttpFailureStatusAcceptor;
import software.amazon.awssdk.waiters.HttpSuccessStatusAcceptor;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;
import software.amazon.awssdk.waiters.WaiterState;

public class OpsWorksClientWaiters {
    private final OpsWorksClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public OpsWorksClientWaiters(OpsWorksClient client) {
        this.client = client;
    }

    public Waiter<DescribeInstancesRequest> instanceTerminated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceTerminated.IsTerminatedMatcher(), new InstanceTerminated.IsResourceNotFoundExceptionMatcher(), new InstanceTerminated.IsBootingMatcher(), new InstanceTerminated.IsOnlineMatcher(), new InstanceTerminated.IsPendingMatcher(), new InstanceTerminated.IsRebootingMatcher(), new InstanceTerminated.IsRequestedMatcher(), new InstanceTerminated.IsRunning_setupMatcher(), new InstanceTerminated.IsSetup_failedMatcher(), new InstanceTerminated.IsStart_failedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAppsRequest> appExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAppsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(400, WaiterState.FAILURE)}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstancesRequest> instanceOnline() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceOnline.IsOnlineMatcher(), new InstanceOnline.IsSetup_failedMatcher(), new InstanceOnline.IsShutting_downMatcher(), new InstanceOnline.IsStart_failedMatcher(), new InstanceOnline.IsStoppedMatcher(), new InstanceOnline.IsStoppingMatcher(), new InstanceOnline.IsTerminatingMatcher(), new InstanceOnline.IsTerminatedMatcher(), new InstanceOnline.IsStop_failedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDeploymentsRequest> deploymentSuccessful() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeDeploymentsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DeploymentSuccessful.IsSuccessfulMatcher(), new DeploymentSuccessful.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstancesRequest> instanceStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceStopped.IsStoppedMatcher(), new InstanceStopped.IsBootingMatcher(), new InstanceStopped.IsOnlineMatcher(), new InstanceStopped.IsPendingMatcher(), new InstanceStopped.IsRebootingMatcher(), new InstanceStopped.IsRequestedMatcher(), new InstanceStopped.IsRunning_setupMatcher(), new InstanceStopped.IsSetup_failedMatcher(), new InstanceStopped.IsStart_failedMatcher(), new InstanceStopped.IsStop_failedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstancesRequest> instanceRegistered() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceRegistered.IsRegisteredMatcher(), new InstanceRegistered.IsSetup_failedMatcher(), new InstanceRegistered.IsShutting_downMatcher(), new InstanceRegistered.IsStoppedMatcher(), new InstanceRegistered.IsStoppingMatcher(), new InstanceRegistered.IsTerminatingMatcher(), new InstanceRegistered.IsTerminatedMatcher(), new InstanceRegistered.IsStop_failedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

