/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>CreateLayer</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateLayerResponse extends OpsWorksResponse implements
        ToCopyableBuilder<CreateLayerResponse.Builder, CreateLayerResponse> {
    private final String layerId;

    private CreateLayerResponse(BuilderImpl builder) {
        super(builder);
        this.layerId = builder.layerId;
    }

    /**
     * <p>
     * The layer ID.
     * </p>
     * 
     * @return The layer ID.
     */
    public String layerId() {
        return layerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLayerResponse)) {
            return false;
        }
        CreateLayerResponse other = (CreateLayerResponse) obj;
        return Objects.equals(layerId(), other.layerId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateLayerResponse").add("LayerId", layerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerId":
            return Optional.of(clazz.cast(layerId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, CreateLayerResponse> {
        /**
         * <p>
         * The layer ID.
         * </p>
         * 
         * @param layerId
         *        The layer ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private String layerId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLayerResponse model) {
            super(model);
            layerId(model.layerId);
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        public CreateLayerResponse build() {
            return new CreateLayerResponse(this);
        }
    }
}
