/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>CreateUserProfile</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateUserProfileResponse extends OpsWorksResponse implements
        ToCopyableBuilder<CreateUserProfileResponse.Builder, CreateUserProfileResponse> {
    private final String iamUserArn;

    private CreateUserProfileResponse(BuilderImpl builder) {
        super(builder);
        this.iamUserArn = builder.iamUserArn;
    }

    /**
     * <p>
     * The user's IAM ARN.
     * </p>
     * 
     * @return The user's IAM ARN.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserProfileResponse)) {
            return false;
        }
        CreateUserProfileResponse other = (CreateUserProfileResponse) obj;
        return Objects.equals(iamUserArn(), other.iamUserArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateUserProfileResponse").add("IamUserArn", iamUserArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamUserArn":
            return Optional.of(clazz.cast(iamUserArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, CreateUserProfileResponse> {
        /**
         * <p>
         * The user's IAM ARN.
         * </p>
         * 
         * @param iamUserArn
         *        The user's IAM ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private String iamUserArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserProfileResponse model) {
            super(model);
            iamUserArn(model.iamUserArn);
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        public CreateUserProfileResponse build() {
            return new CreateUserProfileResponse(this);
        }
    }
}
