/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeregisterElasticIpRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DeregisterElasticIpRequest.Builder, DeregisterElasticIpRequest> {
    private final String elasticIp;

    private DeregisterElasticIpRequest(BuilderImpl builder) {
        super(builder);
        this.elasticIp = builder.elasticIp;
    }

    /**
     * <p>
     * The Elastic IP address.
     * </p>
     * 
     * @return The Elastic IP address.
     */
    public String elasticIp() {
        return elasticIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticIp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterElasticIpRequest)) {
            return false;
        }
        DeregisterElasticIpRequest other = (DeregisterElasticIpRequest) obj;
        return Objects.equals(elasticIp(), other.elasticIp());
    }

    @Override
    public String toString() {
        return ToString.builder("DeregisterElasticIpRequest").add("ElasticIp", elasticIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticIp":
            return Optional.of(clazz.cast(elasticIp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DeregisterElasticIpRequest> {
        /**
         * <p>
         * The Elastic IP address.
         * </p>
         * 
         * @param elasticIp
         *        The Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIp(String elasticIp);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String elasticIp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterElasticIpRequest model) {
            super(model);
            elasticIp(model.elasticIp);
        }

        public final String getElasticIp() {
            return elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeregisterElasticIpRequest build() {
            return new DeregisterElasticIpRequest(this);
        }
    }
}
