/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAgentVersionsRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeAgentVersionsRequest.Builder, DescribeAgentVersionsRequest> {
    private final String stackId;

    private final StackConfigurationManager configurationManager;

    private DescribeAgentVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.configurationManager = builder.configurationManager;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The configuration manager.
     * </p>
     * 
     * @return The configuration manager.
     */
    public StackConfigurationManager configurationManager() {
        return configurationManager;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationManager());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentVersionsRequest)) {
            return false;
        }
        DescribeAgentVersionsRequest other = (DescribeAgentVersionsRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(configurationManager(), other.configurationManager());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAgentVersionsRequest").add("StackId", stackId())
                .add("ConfigurationManager", configurationManager()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "ConfigurationManager":
            return Optional.of(clazz.cast(configurationManager()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DescribeAgentVersionsRequest> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The configuration manager.
         * </p>
         * 
         * @param configurationManager
         *        The configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManager(StackConfigurationManager configurationManager);

        /**
         * <p>
         * The configuration manager.
         * </p>
         * This is a convenience that creates an instance of the {@link StackConfigurationManager.Builder} avoiding the
         * need to create one manually via {@link StackConfigurationManager#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackConfigurationManager.Builder#build()} is called immediately
         * and its result is passed to {@link #configurationManager(StackConfigurationManager)}.
         * 
         * @param configurationManager
         *        a consumer that will call methods on {@link StackConfigurationManager.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationManager(StackConfigurationManager)
         */
        default Builder configurationManager(Consumer<StackConfigurationManager.Builder> configurationManager) {
            return configurationManager(StackConfigurationManager.builder().apply(configurationManager).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private StackConfigurationManager configurationManager;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentVersionsRequest model) {
            super(model);
            stackId(model.stackId);
            configurationManager(model.configurationManager);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return configurationManager != null ? configurationManager.toBuilder() : null;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeAgentVersionsRequest build() {
            return new DescribeAgentVersionsRequest(this);
        }
    }
}
