/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDeploymentsRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeDeploymentsRequest.Builder, DescribeDeploymentsRequest> {
    private final String stackId;

    private final String appId;

    private final List<String> deploymentIds;

    private DescribeDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.deploymentIds = builder.deploymentIds;
    }

    /**
     * <p>
     * The stack ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of the
     * commands associated with the specified stack.
     * </p>
     * 
     * @return The stack ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of
     *         the commands associated with the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The app ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of the commands
     * associated with the specified app.
     * </p>
     * 
     * @return The app ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of the
     *         commands associated with the specified app.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * An array of deployment IDs to be described. If you include this parameter, <code>DescribeDeployments</code>
     * returns a description of the specified deployments. Otherwise, it returns a description of every deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of deployment IDs to be described. If you include this parameter,
     *         <code>DescribeDeployments</code> returns a description of the specified deployments. Otherwise, it
     *         returns a description of every deployment.
     */
    public List<String> deploymentIds() {
        return deploymentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentsRequest)) {
            return false;
        }
        DescribeDeploymentsRequest other = (DescribeDeploymentsRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(appId(), other.appId())
                && Objects.equals(deploymentIds(), other.deploymentIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDeploymentsRequest").add("StackId", stackId()).add("AppId", appId())
                .add("DeploymentIds", deploymentIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "AppId":
            return Optional.of(clazz.cast(appId()));
        case "DeploymentIds":
            return Optional.of(clazz.cast(deploymentIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DescribeDeploymentsRequest> {
        /**
         * <p>
         * The stack ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of the
         * commands associated with the specified stack.
         * </p>
         * 
         * @param stackId
         *        The stack ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of
         *        the commands associated with the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The app ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of the
         * commands associated with the specified app.
         * </p>
         * 
         * @param appId
         *        The app ID. If you include this parameter, <code>DescribeDeployments</code> returns a description of
         *        the commands associated with the specified app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * An array of deployment IDs to be described. If you include this parameter, <code>DescribeDeployments</code>
         * returns a description of the specified deployments. Otherwise, it returns a description of every deployment.
         * </p>
         * 
         * @param deploymentIds
         *        An array of deployment IDs to be described. If you include this parameter,
         *        <code>DescribeDeployments</code> returns a description of the specified deployments. Otherwise, it
         *        returns a description of every deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(Collection<String> deploymentIds);

        /**
         * <p>
         * An array of deployment IDs to be described. If you include this parameter, <code>DescribeDeployments</code>
         * returns a description of the specified deployments. Otherwise, it returns a description of every deployment.
         * </p>
         * 
         * @param deploymentIds
         *        An array of deployment IDs to be described. If you include this parameter,
         *        <code>DescribeDeployments</code> returns a description of the specified deployments. Otherwise, it
         *        returns a description of every deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(String... deploymentIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private String appId;

        private List<String> deploymentIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentsRequest model) {
            super(model);
            stackId(model.stackId);
            appId(model.appId);
            deploymentIds(model.deploymentIds);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final Collection<String> getDeploymentIds() {
            return deploymentIds;
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = StringsCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String... deploymentIds) {
            deploymentIds(Arrays.asList(deploymentIds));
            return this;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = StringsCopier.copy(deploymentIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeploymentsRequest build() {
            return new DescribeDeploymentsRequest(this);
        }
    }
}
