/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeElasticIpsRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeElasticIpsRequest.Builder, DescribeElasticIpsRequest> {
    private final String instanceId;

    private final String stackId;

    private final List<String> ips;

    private DescribeElasticIpsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.ips = builder.ips;
    }

    /**
     * <p>
     * The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the
     * Elastic IP addresses associated with the specified instance.
     * </p>
     * 
     * @return The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of
     *         the Elastic IP addresses associated with the specified instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic
     * IP addresses that are registered with the specified stack.
     * </p>
     * 
     * @return A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the
     *         Elastic IP addresses that are registered with the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * An array of Elastic IP addresses to be described. If you include this parameter, <code>DescribeElasticIps</code>
     * returns a description of the specified Elastic IP addresses. Otherwise, it returns a description of every Elastic
     * IP address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of Elastic IP addresses to be described. If you include this parameter,
     *         <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise,
     *         it returns a description of every Elastic IP address.
     */
    public List<String> ips() {
        return ips;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(ips());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticIpsRequest)) {
            return false;
        }
        DescribeElasticIpsRequest other = (DescribeElasticIpsRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(ips(), other.ips());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeElasticIpsRequest").add("InstanceId", instanceId()).add("StackId", stackId())
                .add("Ips", ips()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "Ips":
            return Optional.of(clazz.cast(ips()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DescribeElasticIpsRequest> {
        /**
         * <p>
         * The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the
         * Elastic IP addresses associated with the specified instance.
         * </p>
         * 
         * @param instanceId
         *        The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description
         *        of the Elastic IP addresses associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the
         * Elastic IP addresses that are registered with the specified stack.
         * </p>
         * 
         * @param stackId
         *        A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of
         *        the Elastic IP addresses that are registered with the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array of Elastic IP addresses to be described. If you include this parameter,
         * <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise, it
         * returns a description of every Elastic IP address.
         * </p>
         * 
         * @param ips
         *        An array of Elastic IP addresses to be described. If you include this parameter,
         *        <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses.
         *        Otherwise, it returns a description of every Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ips(Collection<String> ips);

        /**
         * <p>
         * An array of Elastic IP addresses to be described. If you include this parameter,
         * <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise, it
         * returns a description of every Elastic IP address.
         * </p>
         * 
         * @param ips
         *        An array of Elastic IP addresses to be described. If you include this parameter,
         *        <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses.
         *        Otherwise, it returns a description of every Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ips(String... ips);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String stackId;

        private List<String> ips;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticIpsRequest model) {
            super(model);
            instanceId(model.instanceId);
            stackId(model.stackId);
            ips(model.ips);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getIps() {
            return ips;
        }

        @Override
        public final Builder ips(Collection<String> ips) {
            this.ips = StringsCopier.copy(ips);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ips(String... ips) {
            ips(Arrays.asList(ips));
            return this;
        }

        public final void setIps(Collection<String> ips) {
            this.ips = StringsCopier.copy(ips);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeElasticIpsRequest build() {
            return new DescribeElasticIpsRequest(this);
        }
    }
}
