/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeElasticIps</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeElasticIpsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeElasticIpsResponse.Builder, DescribeElasticIpsResponse> {
    private final List<ElasticIp> elasticIps;

    private DescribeElasticIpsResponse(BuilderImpl builder) {
        super(builder);
        this.elasticIps = builder.elasticIps;
    }

    /**
     * <p>
     * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
     */
    public List<ElasticIp> elasticIps() {
        return elasticIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticIps());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticIpsResponse)) {
            return false;
        }
        DescribeElasticIpsResponse other = (DescribeElasticIpsResponse) obj;
        return Objects.equals(elasticIps(), other.elasticIps());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeElasticIpsResponse").add("ElasticIps", elasticIps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticIps":
            return Optional.of(clazz.cast(elasticIps()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeElasticIpsResponse> {
        /**
         * <p>
         * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * </p>
         * 
         * @param elasticIps
         *        An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIps(Collection<ElasticIp> elasticIps);

        /**
         * <p>
         * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * </p>
         * 
         * @param elasticIps
         *        An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIps(ElasticIp... elasticIps);

        /**
         * <p>
         * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticIp>.Builder} avoiding the need to
         * create one manually via {@link List<ElasticIp>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticIp>.Builder#build()} is called immediately and its
         * result is passed to {@link #elasticIps(List<ElasticIp>)}.
         * 
         * @param elasticIps
         *        a consumer that will call methods on {@link List<ElasticIp>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticIps(List<ElasticIp>)
         */
        Builder elasticIps(Consumer<ElasticIp.Builder>... elasticIps);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<ElasticIp> elasticIps;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticIpsResponse model) {
            super(model);
            elasticIps(model.elasticIps);
        }

        public final Collection<ElasticIp.Builder> getElasticIps() {
            return elasticIps != null ? elasticIps.stream().map(ElasticIp::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticIps(Collection<ElasticIp> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copy(elasticIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticIps(ElasticIp... elasticIps) {
            elasticIps(Arrays.asList(elasticIps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticIps(Consumer<ElasticIp.Builder>... elasticIps) {
            elasticIps(Stream.of(elasticIps).map(c -> ElasticIp.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticIps(Collection<ElasticIp.BuilderImpl> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copyFromBuilder(elasticIps);
        }

        @Override
        public DescribeElasticIpsResponse build() {
            return new DescribeElasticIpsResponse(this);
        }
    }
}
