/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeMyUserProfile</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMyUserProfileResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeMyUserProfileResponse.Builder, DescribeMyUserProfileResponse> {
    private final SelfUserProfile userProfile;

    private DescribeMyUserProfileResponse(BuilderImpl builder) {
        super(builder);
        this.userProfile = builder.userProfile;
    }

    /**
     * <p>
     * A <code>UserProfile</code> object that describes the user's SSH information.
     * </p>
     * 
     * @return A <code>UserProfile</code> object that describes the user's SSH information.
     */
    public SelfUserProfile userProfile() {
        return userProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userProfile());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMyUserProfileResponse)) {
            return false;
        }
        DescribeMyUserProfileResponse other = (DescribeMyUserProfileResponse) obj;
        return Objects.equals(userProfile(), other.userProfile());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMyUserProfileResponse").add("UserProfile", userProfile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserProfile":
            return Optional.of(clazz.cast(userProfile()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeMyUserProfileResponse> {
        /**
         * <p>
         * A <code>UserProfile</code> object that describes the user's SSH information.
         * </p>
         * 
         * @param userProfile
         *        A <code>UserProfile</code> object that describes the user's SSH information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfile(SelfUserProfile userProfile);

        /**
         * <p>
         * A <code>UserProfile</code> object that describes the user's SSH information.
         * </p>
         * This is a convenience that creates an instance of the {@link SelfUserProfile.Builder} avoiding the need to
         * create one manually via {@link SelfUserProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link SelfUserProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #userProfile(SelfUserProfile)}.
         * 
         * @param userProfile
         *        a consumer that will call methods on {@link SelfUserProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userProfile(SelfUserProfile)
         */
        default Builder userProfile(Consumer<SelfUserProfile.Builder> userProfile) {
            return userProfile(SelfUserProfile.builder().apply(userProfile).build());
        }
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private SelfUserProfile userProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMyUserProfileResponse model) {
            super(model);
            userProfile(model.userProfile);
        }

        public final SelfUserProfile.Builder getUserProfile() {
            return userProfile != null ? userProfile.toBuilder() : null;
        }

        @Override
        public final Builder userProfile(SelfUserProfile userProfile) {
            this.userProfile = userProfile;
            return this;
        }

        public final void setUserProfile(SelfUserProfile.BuilderImpl userProfile) {
            this.userProfile = userProfile != null ? userProfile.build() : null;
        }

        @Override
        public DescribeMyUserProfileResponse build() {
            return new DescribeMyUserProfileResponse(this);
        }
    }
}
