/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribePermissions</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePermissionsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribePermissionsResponse.Builder, DescribePermissionsResponse> {
    private final List<Permission> permissions;

    private DescribePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * An array of <code>Permission</code> objects that describe the stack permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
     * permissions for each of the stack IAM ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
     * permissions for each of the user's stack IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
     * with permissions for the specified stack and IAM ARN.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Permission</code> objects that describe the stack permissions.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
     *         permissions for each of the stack IAM ARNs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
     *         permissions for each of the user's stack IDs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code>
     *         object with permissions for the specified stack and IAM ARN.
     *         </p>
     *         </li>
     */
    public List<Permission> permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePermissionsResponse)) {
            return false;
        }
        DescribePermissionsResponse other = (DescribePermissionsResponse) obj;
        return Objects.equals(permissions(), other.permissions());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribePermissionsResponse").add("Permissions", permissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Permissions":
            return Optional.of(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribePermissionsResponse> {
        /**
         * <p>
         * An array of <code>Permission</code> objects that describe the stack permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
         * permissions for each of the stack IAM ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
         * permissions for each of the user's stack IDs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
         * with permissions for the specified stack and IAM ARN.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissions
         *        An array of <code>Permission</code> objects that describe the stack permissions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the request object contains only a stack ID, the array contains a <code>Permission</code> object
         *        with permissions for each of the stack IAM ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object
         *        with permissions for each of the user's stack IDs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code>
         *        object with permissions for the specified stack and IAM ARN.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * An array of <code>Permission</code> objects that describe the stack permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
         * permissions for each of the stack IAM ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
         * permissions for each of the user's stack IDs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
         * with permissions for the specified stack and IAM ARN.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissions
         *        An array of <code>Permission</code> objects that describe the stack permissions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the request object contains only a stack ID, the array contains a <code>Permission</code> object
         *        with permissions for each of the stack IAM ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object
         *        with permissions for each of the user's stack IDs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code>
         *        object with permissions for the specified stack and IAM ARN.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * An array of <code>Permission</code> objects that describe the stack permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
         * permissions for each of the stack IAM ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
         * permissions for each of the user's stack IDs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
         * with permissions for the specified stack and IAM ARN.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Permission>.Builder} avoiding the need to
         * create one manually via {@link List<Permission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Permission>.Builder#build()} is called immediately and its
         * result is passed to {@link #permissions(List<Permission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<Permission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<Permission>)
         */
        Builder permissions(Consumer<Permission.Builder>... permissions);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<Permission> permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePermissionsResponse model) {
            super(model);
            permissions(model.permissions);
        }

        public final Collection<Permission.Builder> getPermissions() {
            return permissions != null ? permissions.stream().map(Permission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<Permission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> Permission.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<Permission.BuilderImpl> permissions) {
            this.permissions = PermissionsCopier.copyFromBuilder(permissions);
        }

        @Override
        public DescribePermissionsResponse build() {
            return new DescribePermissionsResponse(this);
        }
    }
}
