/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeRdsDbInstancesRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeRdsDbInstancesRequest.Builder, DescribeRdsDbInstancesRequest> {
    private final String stackId;

    private final List<String> rdsDbInstanceArns;

    private DescribeRdsDbInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.rdsDbInstanceArns = builder.rdsDbInstanceArns;
    }

    /**
     * <p>
     * The stack ID that the instances are registered with. The operation returns descriptions of all registered Amazon
     * RDS instances.
     * </p>
     * 
     * @return The stack ID that the instances are registered with. The operation returns descriptions of all registered
     *         Amazon RDS instances.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * An array containing the ARNs of the instances to be described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array containing the ARNs of the instances to be described.
     */
    public List<String> rdsDbInstanceArns() {
        return rdsDbInstanceArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbInstanceArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRdsDbInstancesRequest)) {
            return false;
        }
        DescribeRdsDbInstancesRequest other = (DescribeRdsDbInstancesRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(rdsDbInstanceArns(), other.rdsDbInstanceArns());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeRdsDbInstancesRequest").add("StackId", stackId())
                .add("RdsDbInstanceArns", rdsDbInstanceArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "RdsDbInstanceArns":
            return Optional.of(clazz.cast(rdsDbInstanceArns()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DescribeRdsDbInstancesRequest> {
        /**
         * <p>
         * The stack ID that the instances are registered with. The operation returns descriptions of all registered
         * Amazon RDS instances.
         * </p>
         * 
         * @param stackId
         *        The stack ID that the instances are registered with. The operation returns descriptions of all
         *        registered Amazon RDS instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array containing the ARNs of the instances to be described.
         * </p>
         * 
         * @param rdsDbInstanceArns
         *        An array containing the ARNs of the instances to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArns(Collection<String> rdsDbInstanceArns);

        /**
         * <p>
         * An array containing the ARNs of the instances to be described.
         * </p>
         * 
         * @param rdsDbInstanceArns
         *        An array containing the ARNs of the instances to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArns(String... rdsDbInstanceArns);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private List<String> rdsDbInstanceArns;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRdsDbInstancesRequest model) {
            super(model);
            stackId(model.stackId);
            rdsDbInstanceArns(model.rdsDbInstanceArns);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getRdsDbInstanceArns() {
            return rdsDbInstanceArns;
        }

        @Override
        public final Builder rdsDbInstanceArns(Collection<String> rdsDbInstanceArns) {
            this.rdsDbInstanceArns = StringsCopier.copy(rdsDbInstanceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstanceArns(String... rdsDbInstanceArns) {
            rdsDbInstanceArns(Arrays.asList(rdsDbInstanceArns));
            return this;
        }

        public final void setRdsDbInstanceArns(Collection<String> rdsDbInstanceArns) {
            this.rdsDbInstanceArns = StringsCopier.copy(rdsDbInstanceArns);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeRdsDbInstancesRequest build() {
            return new DescribeRdsDbInstancesRequest(this);
        }
    }
}
