/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeStackProvisioningParameters</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackProvisioningParametersResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeStackProvisioningParametersResponse.Builder, DescribeStackProvisioningParametersResponse> {
    private final String agentInstallerUrl;

    private final Map<String, String> parameters;

    private DescribeStackProvisioningParametersResponse(BuilderImpl builder) {
        super(builder);
        this.agentInstallerUrl = builder.agentInstallerUrl;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The AWS OpsWorks Stacks agent installer's URL.
     * </p>
     * 
     * @return The AWS OpsWorks Stacks agent installer's URL.
     */
    public String agentInstallerUrl() {
        return agentInstallerUrl;
    }

    /**
     * <p>
     * An embedded object that contains the provisioning parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An embedded object that contains the provisioning parameters.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentInstallerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackProvisioningParametersResponse)) {
            return false;
        }
        DescribeStackProvisioningParametersResponse other = (DescribeStackProvisioningParametersResponse) obj;
        return Objects.equals(agentInstallerUrl(), other.agentInstallerUrl()) && Objects.equals(parameters(), other.parameters());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeStackProvisioningParametersResponse").add("AgentInstallerUrl", agentInstallerUrl())
                .add("Parameters", parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentInstallerUrl":
            return Optional.of(clazz.cast(agentInstallerUrl()));
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder,
            CopyableBuilder<Builder, DescribeStackProvisioningParametersResponse> {
        /**
         * <p>
         * The AWS OpsWorks Stacks agent installer's URL.
         * </p>
         * 
         * @param agentInstallerUrl
         *        The AWS OpsWorks Stacks agent installer's URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentInstallerUrl(String agentInstallerUrl);

        /**
         * <p>
         * An embedded object that contains the provisioning parameters.
         * </p>
         * 
         * @param parameters
         *        An embedded object that contains the provisioning parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private String agentInstallerUrl;

        private Map<String, String> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackProvisioningParametersResponse model) {
            super(model);
            agentInstallerUrl(model.agentInstallerUrl);
            parameters(model.parameters);
        }

        public final String getAgentInstallerUrl() {
            return agentInstallerUrl;
        }

        @Override
        public final Builder agentInstallerUrl(String agentInstallerUrl) {
            this.agentInstallerUrl = agentInstallerUrl;
            return this;
        }

        public final void setAgentInstallerUrl(String agentInstallerUrl) {
            this.agentInstallerUrl = agentInstallerUrl;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @Override
        public DescribeStackProvisioningParametersResponse build() {
            return new DescribeStackProvisioningParametersResponse(this);
        }
    }
}
