/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeUserProfilesRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeUserProfilesRequest.Builder, DescribeUserProfilesRequest> {
    private final List<String> iamUserArns;

    private DescribeUserProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.iamUserArns = builder.iamUserArns;
    }

    /**
     * <p>
     * An array of IAM or federated user ARNs that identify the users to be described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of IAM or federated user ARNs that identify the users to be described.
     */
    public List<String> iamUserArns() {
        return iamUserArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesRequest)) {
            return false;
        }
        DescribeUserProfilesRequest other = (DescribeUserProfilesRequest) obj;
        return Objects.equals(iamUserArns(), other.iamUserArns());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeUserProfilesRequest").add("IamUserArns", iamUserArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamUserArns":
            return Optional.of(clazz.cast(iamUserArns()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DescribeUserProfilesRequest> {
        /**
         * <p>
         * An array of IAM or federated user ARNs that identify the users to be described.
         * </p>
         * 
         * @param iamUserArns
         *        An array of IAM or federated user ARNs that identify the users to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArns(Collection<String> iamUserArns);

        /**
         * <p>
         * An array of IAM or federated user ARNs that identify the users to be described.
         * </p>
         * 
         * @param iamUserArns
         *        An array of IAM or federated user ARNs that identify the users to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArns(String... iamUserArns);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private List<String> iamUserArns;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesRequest model) {
            super(model);
            iamUserArns(model.iamUserArns);
        }

        public final Collection<String> getIamUserArns() {
            return iamUserArns;
        }

        @Override
        public final Builder iamUserArns(Collection<String> iamUserArns) {
            this.iamUserArns = StringsCopier.copy(iamUserArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamUserArns(String... iamUserArns) {
            iamUserArns(Arrays.asList(iamUserArns));
            return this;
        }

        public final void setIamUserArns(Collection<String> iamUserArns) {
            this.iamUserArns = StringsCopier.copy(iamUserArns);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeUserProfilesRequest build() {
            return new DescribeUserProfilesRequest(this);
        }
    }
}
