/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeUserProfiles</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeUserProfilesResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeUserProfilesResponse.Builder, DescribeUserProfilesResponse> {
    private final List<UserProfile> userProfiles;

    private DescribeUserProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.userProfiles = builder.userProfiles;
    }

    /**
     * <p>
     * A <code>Users</code> object that describes the specified users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A <code>Users</code> object that describes the specified users.
     */
    public List<UserProfile> userProfiles() {
        return userProfiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userProfiles());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesResponse)) {
            return false;
        }
        DescribeUserProfilesResponse other = (DescribeUserProfilesResponse) obj;
        return Objects.equals(userProfiles(), other.userProfiles());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeUserProfilesResponse").add("UserProfiles", userProfiles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserProfiles":
            return Optional.of(clazz.cast(userProfiles()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeUserProfilesResponse> {
        /**
         * <p>
         * A <code>Users</code> object that describes the specified users.
         * </p>
         * 
         * @param userProfiles
         *        A <code>Users</code> object that describes the specified users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfiles(Collection<UserProfile> userProfiles);

        /**
         * <p>
         * A <code>Users</code> object that describes the specified users.
         * </p>
         * 
         * @param userProfiles
         *        A <code>Users</code> object that describes the specified users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfiles(UserProfile... userProfiles);

        /**
         * <p>
         * A <code>Users</code> object that describes the specified users.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserProfile>.Builder} avoiding the need to
         * create one manually via {@link List<UserProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserProfile>.Builder#build()} is called immediately and its
         * result is passed to {@link #userProfiles(List<UserProfile>)}.
         * 
         * @param userProfiles
         *        a consumer that will call methods on {@link List<UserProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userProfiles(List<UserProfile>)
         */
        Builder userProfiles(Consumer<UserProfile.Builder>... userProfiles);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<UserProfile> userProfiles;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesResponse model) {
            super(model);
            userProfiles(model.userProfiles);
        }

        public final Collection<UserProfile.Builder> getUserProfiles() {
            return userProfiles != null ? userProfiles.stream().map(UserProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userProfiles(Collection<UserProfile> userProfiles) {
            this.userProfiles = UserProfilesCopier.copy(userProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(UserProfile... userProfiles) {
            userProfiles(Arrays.asList(userProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(Consumer<UserProfile.Builder>... userProfiles) {
            userProfiles(Stream.of(userProfiles).map(c -> UserProfile.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserProfiles(Collection<UserProfile.BuilderImpl> userProfiles) {
            this.userProfiles = UserProfilesCopier.copyFromBuilder(userProfiles);
        }

        @Override
        public DescribeUserProfilesResponse build() {
            return new DescribeUserProfilesResponse(this);
        }
    }
}
