/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.SourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information required to retrieve an app or cookbook from a repository. For more information, see <a
 * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Creating Apps</a> or <a
 * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Custom Recipes and Cookbooks</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Source implements StructuredPojo, ToCopyableBuilder<Source.Builder, Source> {
    private final String type;

    private final String url;

    private final String username;

    private final String password;

    private final String sshKey;

    private final String revision;

    private Source(BuilderImpl builder) {
        this.type = builder.type;
        this.url = builder.url;
        this.username = builder.username;
        this.password = builder.password;
        this.sshKey = builder.sshKey;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The repository type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The repository type.
     * @see SourceType
     */
    public SourceType type() {
        return SourceType.fromValue(type);
    }

    /**
     * <p>
     * The repository type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The repository type.
     * @see SourceType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The source URL. The following is an example of an Amazon S3 source URL:
     * <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code>.
     * </p>
     * 
     * @return The source URL. The following is an example of an Amazon S3 source URL:
     *         <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code>.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * This parameter depends on the repository type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code> to the user name.
     * </p>
     * </li>
     * </ul>
     * 
     * @return This parameter depends on the repository type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code> to the user
     *         name.
     *         </p>
     *         </li>
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * When included in a request, the parameter depends on the repository type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access key.
     * </p>
     * </li>
     * <li>
     * <p>
     * For HTTP bundles and Subversion repositories, set <code>Password</code> to the password.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on how to safely handle IAM credentials, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html"
     * >http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html</a>.
     * </p>
     * <p>
     * In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
     * </p>
     * 
     * @return When included in a request, the parameter depends on the repository type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For HTTP bundles and Subversion repositories, set <code>Password</code> to the password.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information on how to safely handle IAM credentials, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html"
     *         >http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html</a>.
     *         </p>
     *         <p>
     *         In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * In requests, the repository's SSH key.
     * </p>
     * <p>
     * In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
     * </p>
     * 
     * @return In requests, the repository's SSH key.</p>
     *         <p>
     *         In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
     */
    public String sshKey() {
        return sshKey;
    }

    /**
     * <p>
     * The application's version. AWS OpsWorks Stacks enables you to easily deploy new versions of an application. One
     * of the simplest approaches is to have branches or revisions in your repository that represent different versions
     * that can potentially be deployed.
     * </p>
     * 
     * @return The application's version. AWS OpsWorks Stacks enables you to easily deploy new versions of an
     *         application. One of the simplest approaches is to have branches or revisions in your repository that
     *         represent different versions that can potentially be deployed.
     */
    public String revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(sshKey());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(url(), other.url())
                && Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && Objects.equals(sshKey(), other.sshKey()) && Objects.equals(revision(), other.revision());
    }

    @Override
    public String toString() {
        return ToString.builder("Source").add("Type", typeAsString()).add("Url", url()).add("Username", username())
                .add("Password", password()).add("SshKey", sshKey()).add("Revision", revision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.of(clazz.cast(typeAsString()));
        case "Url":
            return Optional.of(clazz.cast(url()));
        case "Username":
            return Optional.of(clazz.cast(username()));
        case "Password":
            return Optional.of(clazz.cast(password()));
        case "SshKey":
            return Optional.of(clazz.cast(sshKey()));
        case "Revision":
            return Optional.of(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Source> {
        /**
         * <p>
         * The repository type.
         * </p>
         * 
         * @param type
         *        The repository type.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The repository type.
         * </p>
         * 
         * @param type
         *        The repository type.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder type(SourceType type);

        /**
         * <p>
         * The source URL. The following is an example of an Amazon S3 source URL:
         * <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code>.
         * </p>
         * 
         * @param url
         *        The source URL. The following is an example of an Amazon S3 source URL:
         *        <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * This parameter depends on the repository type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code> to the user name.
         * </p>
         * </li>
         * </ul>
         * 
         * @param username
         *        This parameter depends on the repository type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code> to the user
         *        name.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * When included in a request, the parameter depends on the repository type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access key.
         * </p>
         * </li>
         * <li>
         * <p>
         * For HTTP bundles and Subversion repositories, set <code>Password</code> to the password.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information on how to safely handle IAM credentials, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html"
         * >http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html</a>.
         * </p>
         * <p>
         * In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
         * </p>
         * 
         * @param password
         *        When included in a request, the parameter depends on the repository type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For HTTP bundles and Subversion repositories, set <code>Password</code> to the password.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information on how to safely handle IAM credentials, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html"
         *        >http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html</a>.
         *        </p>
         *        <p>
         *        In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * In requests, the repository's SSH key.
         * </p>
         * <p>
         * In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
         * </p>
         * 
         * @param sshKey
         *        In requests, the repository's SSH key.</p>
         *        <p>
         *        In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKey(String sshKey);

        /**
         * <p>
         * The application's version. AWS OpsWorks Stacks enables you to easily deploy new versions of an application.
         * One of the simplest approaches is to have branches or revisions in your repository that represent different
         * versions that can potentially be deployed.
         * </p>
         * 
         * @param revision
         *        The application's version. AWS OpsWorks Stacks enables you to easily deploy new versions of an
         *        application. One of the simplest approaches is to have branches or revisions in your repository that
         *        represent different versions that can potentially be deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String url;

        private String username;

        private String password;

        private String sshKey;

        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            type(model.type);
            url(model.url);
            username(model.username);
            password(model.password);
            sshKey(model.sshKey);
            revision(model.revision);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getSshKey() {
            return sshKey;
        }

        @Override
        public final Builder sshKey(String sshKey) {
            this.sshKey = sshKey;
            return this;
        }

        public final void setSshKey(String sshKey) {
            this.sshKey = sshKey;
        }

        public final String getRevision() {
            return revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public Source build() {
            return new Source(this);
        }
    }
}
