/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateUserProfileRequest extends OpsWorksRequest implements
        ToCopyableBuilder<UpdateUserProfileRequest.Builder, UpdateUserProfileRequest> {
    private final String iamUserArn;

    private final String sshUsername;

    private final String sshPublicKey;

    private final Boolean allowSelfManagement;

    private UpdateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.iamUserArn = builder.iamUserArn;
        this.sshUsername = builder.sshUsername;
        this.sshPublicKey = builder.sshPublicKey;
        this.allowSelfManagement = builder.allowSelfManagement;
    }

    /**
     * <p>
     * The user IAM ARN. This can also be a federated user's ARN.
     * </p>
     * 
     * @return The user IAM ARN. This can also be a federated user's ARN.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name
     * includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code> will be
     * changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from
     * the IAM user name.
     * </p>
     * 
     * @return The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the
     *         specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example,
     *         <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS
     *         OpsWorks Stacks generates one from the IAM user name.
     */
    public String sshUsername() {
        return sshUsername;
    }

    /**
     * <p>
     * The user's new SSH public key.
     * </p>
     * 
     * @return The user's new SSH public key.
     */
    public String sshPublicKey() {
        return sshPublicKey;
    }

    /**
     * <p>
     * Whether users can specify their own SSH public key through the My Settings page. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User
     * Permissions</a>.
     * </p>
     * 
     * @return Whether users can specify their own SSH public key through the My Settings page. For more information,
     *         see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing
     *         User Permissions</a>.
     */
    public Boolean allowSelfManagement() {
        return allowSelfManagement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(sshUsername());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(allowSelfManagement());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserProfileRequest)) {
            return false;
        }
        UpdateUserProfileRequest other = (UpdateUserProfileRequest) obj;
        return Objects.equals(iamUserArn(), other.iamUserArn()) && Objects.equals(sshUsername(), other.sshUsername())
                && Objects.equals(sshPublicKey(), other.sshPublicKey())
                && Objects.equals(allowSelfManagement(), other.allowSelfManagement());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateUserProfileRequest").add("IamUserArn", iamUserArn()).add("SshUsername", sshUsername())
                .add("SshPublicKey", sshPublicKey()).add("AllowSelfManagement", allowSelfManagement()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamUserArn":
            return Optional.of(clazz.cast(iamUserArn()));
        case "SshUsername":
            return Optional.of(clazz.cast(sshUsername()));
        case "SshPublicKey":
            return Optional.of(clazz.cast(sshPublicKey()));
        case "AllowSelfManagement":
            return Optional.of(clazz.cast(allowSelfManagement()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, UpdateUserProfileRequest> {
        /**
         * <p>
         * The user IAM ARN. This can also be a federated user's ARN.
         * </p>
         * 
         * @param iamUserArn
         *        The user IAM ARN. This can also be a federated user's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified
         * name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, <code>my.name</code>
         * will be changed to <code>myname</code>. If you do not specify an SSH user name, AWS OpsWorks Stacks generates
         * one from the IAM user name.
         * </p>
         * 
         * @param sshUsername
         *        The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the
         *        specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example,
         *        <code>my.name</code> will be changed to <code>myname</code>. If you do not specify an SSH user name,
         *        AWS OpsWorks Stacks generates one from the IAM user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshUsername(String sshUsername);

        /**
         * <p>
         * The user's new SSH public key.
         * </p>
         * 
         * @param sshPublicKey
         *        The user's new SSH public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);

        /**
         * <p>
         * Whether users can specify their own SSH public key through the My Settings page. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User
         * Permissions</a>.
         * </p>
         * 
         * @param allowSelfManagement
         *        Whether users can specify their own SSH public key through the My Settings page. For more information,
         *        see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User
         *        Permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowSelfManagement(Boolean allowSelfManagement);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String iamUserArn;

        private String sshUsername;

        private String sshPublicKey;

        private Boolean allowSelfManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserProfileRequest model) {
            super(model);
            iamUserArn(model.iamUserArn);
            sshUsername(model.sshUsername);
            sshPublicKey(model.sshPublicKey);
            allowSelfManagement(model.allowSelfManagement);
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getSshUsername() {
            return sshUsername;
        }

        @Override
        public final Builder sshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
            return this;
        }

        public final void setSshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final Boolean getAllowSelfManagement() {
            return allowSelfManagement;
        }

        @Override
        public final Builder allowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
            return this;
        }

        public final void setAllowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserProfileRequest build() {
            return new UpdateUserProfileRequest(this);
        }
    }
}
