/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.opsworks.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * App JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AppUnmarshaller implements Unmarshaller<App, JsonUnmarshallerContext> {

    public App unmarshall(JsonUnmarshallerContext context) throws Exception {
        App.Builder appBuilder = App.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("AppId", targetDepth)) {
                    context.nextToken();
                    appBuilder.appId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StackId", targetDepth)) {
                    context.nextToken();
                    appBuilder.stackId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Shortname", targetDepth)) {
                    context.nextToken();
                    appBuilder.shortname(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    appBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    appBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DataSources", targetDepth)) {
                    context.nextToken();
                    appBuilder.dataSources(new ListUnmarshaller<DataSource>(DataSourceUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    appBuilder.type(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AppSource", targetDepth)) {
                    context.nextToken();
                    appBuilder.appSource(SourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Domains", targetDepth)) {
                    context.nextToken();
                    appBuilder.domains(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("EnableSsl", targetDepth)) {
                    context.nextToken();
                    appBuilder.enableSsl(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("SslConfiguration", targetDepth)) {
                    context.nextToken();
                    appBuilder.sslConfiguration(SslConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    appBuilder.attributes(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    appBuilder.createdAt(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Environment", targetDepth)) {
                    context.nextToken();
                    appBuilder.environment(new ListUnmarshaller<EnvironmentVariable>(EnvironmentVariableUnmarshaller
                            .getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return appBuilder.build();
    }

    private static final AppUnmarshaller INSTANCE = new AppUnmarshaller();

    public static AppUnmarshaller getInstance() {
        return INSTANCE;
    }
}
