/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.Layer;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Layer} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class LayerMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();

    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();

    private static final MarshallingInfo<String> LAYERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerId").isBinary(false).build();

    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> SHORTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shortname").isBinary(false).build();

    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGSCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CloudWatchLogsConfiguration").isBinary(false).build();

    private static final MarshallingInfo<String> CUSTOMINSTANCEPROFILEARN_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CustomInstanceProfileArn").isBinary(false).build();

    private static final MarshallingInfo<String> CUSTOMJSON_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomJson").isBinary(false).build();

    private static final MarshallingInfo<List> CUSTOMSECURITYGROUPIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomSecurityGroupIds").isBinary(false).build();

    private static final MarshallingInfo<List> DEFAULTSECURITYGROUPNAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultSecurityGroupNames").isBinary(false).build();

    private static final MarshallingInfo<List> PACKAGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Packages").isBinary(false).build();

    private static final MarshallingInfo<List> VOLUMECONFIGURATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeConfigurations").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ENABLEAUTOHEALING_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableAutoHealing").isBinary(false).build();

    private static final MarshallingInfo<Boolean> AUTOASSIGNELASTICIPS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoAssignElasticIps").isBinary(false).build();

    private static final MarshallingInfo<Boolean> AUTOASSIGNPUBLICIPS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoAssignPublicIps").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DEFAULTRECIPES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DefaultRecipes").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CUSTOMRECIPES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomRecipes")
            .isBinary(false).build();

    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();

    private static final MarshallingInfo<Boolean> INSTALLUPDATESONBOOT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstallUpdatesOnBoot").isBinary(false).build();

    private static final MarshallingInfo<Boolean> USEEBSOPTIMIZEDINSTANCES_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("UseEbsOptimizedInstances").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LIFECYCLEEVENTCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LifecycleEventConfiguration").isBinary(false).build();

    private static final LayerMarshaller INSTANCE = new LayerMarshaller();

    private LayerMarshaller() {
    }

    public static LayerMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Layer layer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(layer, "layer");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(layer.arn(), ARN_BINDING);
            protocolMarshaller.marshall(layer.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall(layer.layerId(), LAYERID_BINDING);
            protocolMarshaller.marshall(layer.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall(layer.name(), NAME_BINDING);
            protocolMarshaller.marshall(layer.shortname(), SHORTNAME_BINDING);
            protocolMarshaller.marshall(layer.attributesAsStrings(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(layer.cloudWatchLogsConfiguration(), CLOUDWATCHLOGSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(layer.customInstanceProfileArn(), CUSTOMINSTANCEPROFILEARN_BINDING);
            protocolMarshaller.marshall(layer.customJson(), CUSTOMJSON_BINDING);
            protocolMarshaller.marshall(layer.customSecurityGroupIds(), CUSTOMSECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall(layer.defaultSecurityGroupNames(), DEFAULTSECURITYGROUPNAMES_BINDING);
            protocolMarshaller.marshall(layer.packages(), PACKAGES_BINDING);
            protocolMarshaller.marshall(layer.volumeConfigurations(), VOLUMECONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(layer.enableAutoHealing(), ENABLEAUTOHEALING_BINDING);
            protocolMarshaller.marshall(layer.autoAssignElasticIps(), AUTOASSIGNELASTICIPS_BINDING);
            protocolMarshaller.marshall(layer.autoAssignPublicIps(), AUTOASSIGNPUBLICIPS_BINDING);
            protocolMarshaller.marshall(layer.defaultRecipes(), DEFAULTRECIPES_BINDING);
            protocolMarshaller.marshall(layer.customRecipes(), CUSTOMRECIPES_BINDING);
            protocolMarshaller.marshall(layer.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(layer.installUpdatesOnBoot(), INSTALLUPDATESONBOOT_BINDING);
            protocolMarshaller.marshall(layer.useEbsOptimizedInstances(), USEEBSOPTIMIZEDINSTANCES_BINDING);
            protocolMarshaller.marshall(layer.lifecycleEventConfiguration(), LIFECYCLEEVENTCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
