/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.opsworks.model.ElasticLoadBalancer;
import software.amazon.awssdk.services.opsworks.model.ElasticLoadBalancersCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticLoadBalancersResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeElasticLoadBalancersResponse> {
    private final List<ElasticLoadBalancer> elasticLoadBalancers;

    private DescribeElasticLoadBalancersResponse(BuilderImpl builder) {
        super(builder);
        this.elasticLoadBalancers = builder.elasticLoadBalancers;
    }

    public List<ElasticLoadBalancer> elasticLoadBalancers() {
        return this.elasticLoadBalancers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticLoadBalancers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticLoadBalancersResponse)) {
            return false;
        }
        DescribeElasticLoadBalancersResponse other = (DescribeElasticLoadBalancersResponse)((Object)obj);
        return Objects.equals(this.elasticLoadBalancers(), other.elasticLoadBalancers());
    }

    public String toString() {
        return ToString.builder((String)"DescribeElasticLoadBalancersResponse").add("ElasticLoadBalancers", this.elasticLoadBalancers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticLoadBalancers": {
                return Optional.of(clazz.cast(this.elasticLoadBalancers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<ElasticLoadBalancer> elasticLoadBalancers;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticLoadBalancersResponse model) {
            super(model);
            this.elasticLoadBalancers(model.elasticLoadBalancers);
        }

        public final Collection<ElasticLoadBalancer.Builder> getElasticLoadBalancers() {
            return this.elasticLoadBalancers != null ? (Collection)this.elasticLoadBalancers.stream().map(ElasticLoadBalancer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copy(elasticLoadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticLoadBalancers(ElasticLoadBalancer ... elasticLoadBalancers) {
            this.elasticLoadBalancers(Arrays.asList(elasticLoadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticLoadBalancers(Consumer<ElasticLoadBalancer.Builder> ... elasticLoadBalancers) {
            this.elasticLoadBalancers(Stream.of(elasticLoadBalancers).map(c -> (ElasticLoadBalancer)((ElasticLoadBalancer.Builder)ElasticLoadBalancer.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticLoadBalancers(Collection<ElasticLoadBalancer.BuilderImpl> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copyFromBuilder(elasticLoadBalancers);
        }

        @Override
        public DescribeElasticLoadBalancersResponse build() {
            return new DescribeElasticLoadBalancersResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeElasticLoadBalancersResponse> {
        public Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> var1);

        public Builder elasticLoadBalancers(ElasticLoadBalancer ... var1);

        public Builder elasticLoadBalancers(Consumer<ElasticLoadBalancer.Builder> ... var1);
    }
}

