/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsConfiguration;
import software.amazon.awssdk.services.opsworks.model.LayerAttributesCopier;
import software.amazon.awssdk.services.opsworks.model.LayerAttributesKeys;
import software.amazon.awssdk.services.opsworks.model.LayerType;
import software.amazon.awssdk.services.opsworks.model.LifecycleEventConfiguration;
import software.amazon.awssdk.services.opsworks.model.Recipes;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.services.opsworks.model.VolumeConfiguration;
import software.amazon.awssdk.services.opsworks.model.VolumeConfigurationsCopier;
import software.amazon.awssdk.services.opsworks.transform.LayerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Layer
implements StructuredPojo,
ToCopyableBuilder<Builder, Layer> {
    private final String arn;
    private final String stackId;
    private final String layerId;
    private final String type;
    private final String name;
    private final String shortname;
    private final Map<String, String> attributes;
    private final CloudWatchLogsConfiguration cloudWatchLogsConfiguration;
    private final String customInstanceProfileArn;
    private final String customJson;
    private final List<String> customSecurityGroupIds;
    private final List<String> defaultSecurityGroupNames;
    private final List<String> packages;
    private final List<VolumeConfiguration> volumeConfigurations;
    private final Boolean enableAutoHealing;
    private final Boolean autoAssignElasticIps;
    private final Boolean autoAssignPublicIps;
    private final Recipes defaultRecipes;
    private final Recipes customRecipes;
    private final String createdAt;
    private final Boolean installUpdatesOnBoot;
    private final Boolean useEbsOptimizedInstances;
    private final LifecycleEventConfiguration lifecycleEventConfiguration;

    private Layer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.type = builder.type;
        this.name = builder.name;
        this.shortname = builder.shortname;
        this.attributes = builder.attributes;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.customInstanceProfileArn = builder.customInstanceProfileArn;
        this.customJson = builder.customJson;
        this.customSecurityGroupIds = builder.customSecurityGroupIds;
        this.defaultSecurityGroupNames = builder.defaultSecurityGroupNames;
        this.packages = builder.packages;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.enableAutoHealing = builder.enableAutoHealing;
        this.autoAssignElasticIps = builder.autoAssignElasticIps;
        this.autoAssignPublicIps = builder.autoAssignPublicIps;
        this.defaultRecipes = builder.defaultRecipes;
        this.customRecipes = builder.customRecipes;
        this.createdAt = builder.createdAt;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.useEbsOptimizedInstances = builder.useEbsOptimizedInstances;
        this.lifecycleEventConfiguration = builder.lifecycleEventConfiguration;
    }

    public String arn() {
        return this.arn;
    }

    public String stackId() {
        return this.stackId;
    }

    public String layerId() {
        return this.layerId;
    }

    public LayerType type() {
        return LayerType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String shortname() {
        return this.shortname;
    }

    public Map<LayerAttributesKeys, String> attributes() {
        return TypeConverter.convert(this.attributes, LayerAttributesKeys::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)LayerAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesAsStrings() {
        return this.attributes;
    }

    public CloudWatchLogsConfiguration cloudWatchLogsConfiguration() {
        return this.cloudWatchLogsConfiguration;
    }

    public String customInstanceProfileArn() {
        return this.customInstanceProfileArn;
    }

    public String customJson() {
        return this.customJson;
    }

    public List<String> customSecurityGroupIds() {
        return this.customSecurityGroupIds;
    }

    public List<String> defaultSecurityGroupNames() {
        return this.defaultSecurityGroupNames;
    }

    public List<String> packages() {
        return this.packages;
    }

    public List<VolumeConfiguration> volumeConfigurations() {
        return this.volumeConfigurations;
    }

    public Boolean enableAutoHealing() {
        return this.enableAutoHealing;
    }

    public Boolean autoAssignElasticIps() {
        return this.autoAssignElasticIps;
    }

    public Boolean autoAssignPublicIps() {
        return this.autoAssignPublicIps;
    }

    public Recipes defaultRecipes() {
        return this.defaultRecipes;
    }

    public Recipes customRecipes() {
        return this.customRecipes;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public Boolean installUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Boolean useEbsOptimizedInstances() {
        return this.useEbsOptimizedInstances;
    }

    public LifecycleEventConfiguration lifecycleEventConfiguration() {
        return this.lifecycleEventConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortname());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customJson());
        hashCode = 31 * hashCode + Objects.hashCode(this.customSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSecurityGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.packages());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoHealing());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAssignElasticIps());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAssignPublicIps());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRecipes());
        hashCode = 31 * hashCode + Objects.hashCode(this.customRecipes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(this.useEbsOptimizedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleEventConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.layerId(), other.layerId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.shortname(), other.shortname()) && Objects.equals(this.attributesAsStrings(), other.attributesAsStrings()) && Objects.equals(this.cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration()) && Objects.equals(this.customInstanceProfileArn(), other.customInstanceProfileArn()) && Objects.equals(this.customJson(), other.customJson()) && Objects.equals(this.customSecurityGroupIds(), other.customSecurityGroupIds()) && Objects.equals(this.defaultSecurityGroupNames(), other.defaultSecurityGroupNames()) && Objects.equals(this.packages(), other.packages()) && Objects.equals(this.volumeConfigurations(), other.volumeConfigurations()) && Objects.equals(this.enableAutoHealing(), other.enableAutoHealing()) && Objects.equals(this.autoAssignElasticIps(), other.autoAssignElasticIps()) && Objects.equals(this.autoAssignPublicIps(), other.autoAssignPublicIps()) && Objects.equals(this.defaultRecipes(), other.defaultRecipes()) && Objects.equals(this.customRecipes(), other.customRecipes()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.installUpdatesOnBoot(), other.installUpdatesOnBoot()) && Objects.equals(this.useEbsOptimizedInstances(), other.useEbsOptimizedInstances()) && Objects.equals(this.lifecycleEventConfiguration(), other.lifecycleEventConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"Layer").add("Arn", (Object)this.arn()).add("StackId", (Object)this.stackId()).add("LayerId", (Object)this.layerId()).add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("Shortname", (Object)this.shortname()).add("Attributes", this.attributesAsStrings()).add("CloudWatchLogsConfiguration", (Object)this.cloudWatchLogsConfiguration()).add("CustomInstanceProfileArn", (Object)this.customInstanceProfileArn()).add("CustomJson", (Object)this.customJson()).add("CustomSecurityGroupIds", this.customSecurityGroupIds()).add("DefaultSecurityGroupNames", this.defaultSecurityGroupNames()).add("Packages", this.packages()).add("VolumeConfigurations", this.volumeConfigurations()).add("EnableAutoHealing", (Object)this.enableAutoHealing()).add("AutoAssignElasticIps", (Object)this.autoAssignElasticIps()).add("AutoAssignPublicIps", (Object)this.autoAssignPublicIps()).add("DefaultRecipes", (Object)this.defaultRecipes()).add("CustomRecipes", (Object)this.customRecipes()).add("CreatedAt", (Object)this.createdAt()).add("InstallUpdatesOnBoot", (Object)this.installUpdatesOnBoot()).add("UseEbsOptimizedInstances", (Object)this.useEbsOptimizedInstances()).add("LifecycleEventConfiguration", (Object)this.lifecycleEventConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "LayerId": {
                return Optional.of(clazz.cast(this.layerId()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Shortname": {
                return Optional.of(clazz.cast(this.shortname()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributesAsStrings()));
            }
            case "CloudWatchLogsConfiguration": {
                return Optional.of(clazz.cast(this.cloudWatchLogsConfiguration()));
            }
            case "CustomInstanceProfileArn": {
                return Optional.of(clazz.cast(this.customInstanceProfileArn()));
            }
            case "CustomJson": {
                return Optional.of(clazz.cast(this.customJson()));
            }
            case "CustomSecurityGroupIds": {
                return Optional.of(clazz.cast(this.customSecurityGroupIds()));
            }
            case "DefaultSecurityGroupNames": {
                return Optional.of(clazz.cast(this.defaultSecurityGroupNames()));
            }
            case "Packages": {
                return Optional.of(clazz.cast(this.packages()));
            }
            case "VolumeConfigurations": {
                return Optional.of(clazz.cast(this.volumeConfigurations()));
            }
            case "EnableAutoHealing": {
                return Optional.of(clazz.cast(this.enableAutoHealing()));
            }
            case "AutoAssignElasticIps": {
                return Optional.of(clazz.cast(this.autoAssignElasticIps()));
            }
            case "AutoAssignPublicIps": {
                return Optional.of(clazz.cast(this.autoAssignPublicIps()));
            }
            case "DefaultRecipes": {
                return Optional.of(clazz.cast(this.defaultRecipes()));
            }
            case "CustomRecipes": {
                return Optional.of(clazz.cast(this.customRecipes()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "InstallUpdatesOnBoot": {
                return Optional.of(clazz.cast(this.installUpdatesOnBoot()));
            }
            case "UseEbsOptimizedInstances": {
                return Optional.of(clazz.cast(this.useEbsOptimizedInstances()));
            }
            case "LifecycleEventConfiguration": {
                return Optional.of(clazz.cast(this.lifecycleEventConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LayerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String stackId;
        private String layerId;
        private String type;
        private String name;
        private String shortname;
        private Map<String, String> attributes;
        private CloudWatchLogsConfiguration cloudWatchLogsConfiguration;
        private String customInstanceProfileArn;
        private String customJson;
        private List<String> customSecurityGroupIds;
        private List<String> defaultSecurityGroupNames;
        private List<String> packages;
        private List<VolumeConfiguration> volumeConfigurations;
        private Boolean enableAutoHealing;
        private Boolean autoAssignElasticIps;
        private Boolean autoAssignPublicIps;
        private Recipes defaultRecipes;
        private Recipes customRecipes;
        private String createdAt;
        private Boolean installUpdatesOnBoot;
        private Boolean useEbsOptimizedInstances;
        private LifecycleEventConfiguration lifecycleEventConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Layer model) {
            this.arn(model.arn);
            this.stackId(model.stackId);
            this.layerId(model.layerId);
            this.type(model.type);
            this.name(model.name);
            this.shortname(model.shortname);
            this.attributes(model.attributes);
            this.cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            this.customInstanceProfileArn(model.customInstanceProfileArn);
            this.customJson(model.customJson);
            this.customSecurityGroupIds(model.customSecurityGroupIds);
            this.defaultSecurityGroupNames(model.defaultSecurityGroupNames);
            this.packages(model.packages);
            this.volumeConfigurations(model.volumeConfigurations);
            this.enableAutoHealing(model.enableAutoHealing);
            this.autoAssignElasticIps(model.autoAssignElasticIps);
            this.autoAssignPublicIps(model.autoAssignPublicIps);
            this.defaultRecipes(model.defaultRecipes);
            this.customRecipes(model.customRecipes);
            this.createdAt(model.createdAt);
            this.installUpdatesOnBoot(model.installUpdatesOnBoot);
            this.useEbsOptimizedInstances(model.useEbsOptimizedInstances);
            this.lifecycleEventConfiguration(model.lifecycleEventConfiguration);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLayerId() {
            return this.layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LayerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getShortname() {
            return this.shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
        }

        public final CloudWatchLogsConfiguration.Builder getCloudWatchLogsConfiguration() {
            return this.cloudWatchLogsConfiguration != null ? this.cloudWatchLogsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfiguration.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        public final String getCustomInstanceProfileArn() {
            return this.customInstanceProfileArn;
        }

        @Override
        public final Builder customInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
            return this;
        }

        public final void setCustomInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
        }

        public final String getCustomJson() {
            return this.customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getCustomSecurityGroupIds() {
            return this.customSecurityGroupIds;
        }

        @Override
        public final Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customSecurityGroupIds(String ... customSecurityGroupIds) {
            this.customSecurityGroupIds(Arrays.asList(customSecurityGroupIds));
            return this;
        }

        public final void setCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
        }

        public final Collection<String> getDefaultSecurityGroupNames() {
            return this.defaultSecurityGroupNames;
        }

        @Override
        public final Builder defaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames) {
            this.defaultSecurityGroupNames = StringsCopier.copy(defaultSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultSecurityGroupNames(String ... defaultSecurityGroupNames) {
            this.defaultSecurityGroupNames(Arrays.asList(defaultSecurityGroupNames));
            return this;
        }

        public final void setDefaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames) {
            this.defaultSecurityGroupNames = StringsCopier.copy(defaultSecurityGroupNames);
        }

        public final Collection<String> getPackages() {
            return this.packages;
        }

        @Override
        public final Builder packages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(String ... packages) {
            this.packages(Arrays.asList(packages));
            return this;
        }

        public final void setPackages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
        }

        public final Collection<VolumeConfiguration.Builder> getVolumeConfigurations() {
            return this.volumeConfigurations != null ? (Collection)this.volumeConfigurations.stream().map(VolumeConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(VolumeConfiguration ... volumeConfigurations) {
            this.volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<VolumeConfiguration.Builder> ... volumeConfigurations) {
            this.volumeConfigurations(Stream.of(volumeConfigurations).map(c -> (VolumeConfiguration)((VolumeConfiguration.Builder)VolumeConfiguration.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumeConfigurations(Collection<VolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        public final Boolean getEnableAutoHealing() {
            return this.enableAutoHealing;
        }

        @Override
        public final Builder enableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
            return this;
        }

        public final void setEnableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
        }

        public final Boolean getAutoAssignElasticIps() {
            return this.autoAssignElasticIps;
        }

        @Override
        public final Builder autoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
            return this;
        }

        public final void setAutoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
        }

        public final Boolean getAutoAssignPublicIps() {
            return this.autoAssignPublicIps;
        }

        @Override
        public final Builder autoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
            return this;
        }

        public final void setAutoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
        }

        public final Recipes.Builder getDefaultRecipes() {
            return this.defaultRecipes != null ? this.defaultRecipes.toBuilder() : null;
        }

        @Override
        public final Builder defaultRecipes(Recipes defaultRecipes) {
            this.defaultRecipes = defaultRecipes;
            return this;
        }

        public final void setDefaultRecipes(Recipes.BuilderImpl defaultRecipes) {
            this.defaultRecipes = defaultRecipes != null ? defaultRecipes.build() : null;
        }

        public final Recipes.Builder getCustomRecipes() {
            return this.customRecipes != null ? this.customRecipes.toBuilder() : null;
        }

        @Override
        public final Builder customRecipes(Recipes customRecipes) {
            this.customRecipes = customRecipes;
            return this;
        }

        public final void setCustomRecipes(Recipes.BuilderImpl customRecipes) {
            this.customRecipes = customRecipes != null ? customRecipes.build() : null;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getUseEbsOptimizedInstances() {
            return this.useEbsOptimizedInstances;
        }

        @Override
        public final Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
            return this;
        }

        public final void setUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
        }

        public final LifecycleEventConfiguration.Builder getLifecycleEventConfiguration() {
            return this.lifecycleEventConfiguration != null ? this.lifecycleEventConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
            return this;
        }

        public final void setLifecycleEventConfiguration(LifecycleEventConfiguration.BuilderImpl lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration != null ? lifecycleEventConfiguration.build() : null;
        }

        public Layer build() {
            return new Layer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Layer> {
        public Builder arn(String var1);

        public Builder stackId(String var1);

        public Builder layerId(String var1);

        public Builder type(String var1);

        public Builder type(LayerType var1);

        public Builder name(String var1);

        public Builder shortname(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration var1);

        default public Builder cloudWatchLogsConfiguration(Consumer<CloudWatchLogsConfiguration.Builder> cloudWatchLogsConfiguration) {
            return this.cloudWatchLogsConfiguration((CloudWatchLogsConfiguration)((CloudWatchLogsConfiguration.Builder)CloudWatchLogsConfiguration.builder().apply(cloudWatchLogsConfiguration)).build());
        }

        public Builder customInstanceProfileArn(String var1);

        public Builder customJson(String var1);

        public Builder customSecurityGroupIds(Collection<String> var1);

        public Builder customSecurityGroupIds(String ... var1);

        public Builder defaultSecurityGroupNames(Collection<String> var1);

        public Builder defaultSecurityGroupNames(String ... var1);

        public Builder packages(Collection<String> var1);

        public Builder packages(String ... var1);

        public Builder volumeConfigurations(Collection<VolumeConfiguration> var1);

        public Builder volumeConfigurations(VolumeConfiguration ... var1);

        public Builder volumeConfigurations(Consumer<VolumeConfiguration.Builder> ... var1);

        public Builder enableAutoHealing(Boolean var1);

        public Builder autoAssignElasticIps(Boolean var1);

        public Builder autoAssignPublicIps(Boolean var1);

        public Builder defaultRecipes(Recipes var1);

        default public Builder defaultRecipes(Consumer<Recipes.Builder> defaultRecipes) {
            return this.defaultRecipes((Recipes)((Recipes.Builder)Recipes.builder().apply(defaultRecipes)).build());
        }

        public Builder customRecipes(Recipes var1);

        default public Builder customRecipes(Consumer<Recipes.Builder> customRecipes) {
            return this.customRecipes((Recipes)((Recipes.Builder)Recipes.builder().apply(customRecipes)).build());
        }

        public Builder createdAt(String var1);

        public Builder installUpdatesOnBoot(Boolean var1);

        public Builder useEbsOptimizedInstances(Boolean var1);

        public Builder lifecycleEventConfiguration(LifecycleEventConfiguration var1);

        default public Builder lifecycleEventConfiguration(Consumer<LifecycleEventConfiguration.Builder> lifecycleEventConfiguration) {
            return this.lifecycleEventConfiguration((LifecycleEventConfiguration)((LifecycleEventConfiguration.Builder)LifecycleEventConfiguration.builder().apply(lifecycleEventConfiguration)).build());
        }
    }
}

