/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.AutoScalingThresholds;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AutoScalingThresholdsMarshaller {
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> THRESHOLDSWAITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThresholdsWaitTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> IGNOREMETRICSTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IgnoreMetricsTime").isBinary(false).build();
    private static final MarshallingInfo<Double> CPUTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CpuThreshold").isBinary(false).build();
    private static final MarshallingInfo<Double> MEMORYTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MemoryThreshold").isBinary(false).build();
    private static final MarshallingInfo<Double> LOADTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoadThreshold").isBinary(false).build();
    private static final MarshallingInfo<List> ALARMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Alarms").isBinary(false).build();
    private static final AutoScalingThresholdsMarshaller INSTANCE = new AutoScalingThresholdsMarshaller();

    private AutoScalingThresholdsMarshaller() {
    }

    public static AutoScalingThresholdsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutoScalingThresholds autoScalingThresholds, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)autoScalingThresholds, (String)"autoScalingThresholds");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)autoScalingThresholds.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)autoScalingThresholds.thresholdsWaitTime(), THRESHOLDSWAITTIME_BINDING);
            protocolMarshaller.marshall((Object)autoScalingThresholds.ignoreMetricsTime(), IGNOREMETRICSTIME_BINDING);
            protocolMarshaller.marshall((Object)autoScalingThresholds.cpuThreshold(), CPUTHRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)autoScalingThresholds.memoryThreshold(), MEMORYTHRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)autoScalingThresholds.loadThreshold(), LOADTHRESHOLD_BINDING);
            protocolMarshaller.marshall(autoScalingThresholds.alarms(), ALARMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

