/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworks.model.Layer;
import software.amazon.awssdk.services.opsworks.transform.CloudWatchLogsConfigurationUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.LifecycleEventConfigurationUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.RecipesUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.VolumeConfigurationUnmarshaller;

public class LayerUnmarshaller
implements Unmarshaller<Layer, JsonUnmarshallerContext> {
    private static final LayerUnmarshaller INSTANCE = new LayerUnmarshaller();

    public Layer unmarshall(JsonUnmarshallerContext context) throws Exception {
        Layer.Builder layerBuilder = Layer.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    layerBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StackId", targetDepth)) {
                    context.nextToken();
                    layerBuilder.stackId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LayerId", targetDepth)) {
                    context.nextToken();
                    layerBuilder.layerId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    layerBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    layerBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Shortname", targetDepth)) {
                    context.nextToken();
                    layerBuilder.shortname((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    layerBuilder.attributes(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CloudWatchLogsConfiguration", targetDepth)) {
                    context.nextToken();
                    layerBuilder.cloudWatchLogsConfiguration(CloudWatchLogsConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CustomInstanceProfileArn", targetDepth)) {
                    context.nextToken();
                    layerBuilder.customInstanceProfileArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CustomJson", targetDepth)) {
                    context.nextToken();
                    layerBuilder.customJson((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CustomSecurityGroupIds", targetDepth)) {
                    context.nextToken();
                    layerBuilder.customSecurityGroupIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("DefaultSecurityGroupNames", targetDepth)) {
                    context.nextToken();
                    layerBuilder.defaultSecurityGroupNames(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Packages", targetDepth)) {
                    context.nextToken();
                    layerBuilder.packages(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("VolumeConfigurations", targetDepth)) {
                    context.nextToken();
                    layerBuilder.volumeConfigurations(new ListUnmarshaller((Unmarshaller)VolumeConfigurationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("EnableAutoHealing", targetDepth)) {
                    context.nextToken();
                    layerBuilder.enableAutoHealing((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("AutoAssignElasticIps", targetDepth)) {
                    context.nextToken();
                    layerBuilder.autoAssignElasticIps((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("AutoAssignPublicIps", targetDepth)) {
                    context.nextToken();
                    layerBuilder.autoAssignPublicIps((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultRecipes", targetDepth)) {
                    context.nextToken();
                    layerBuilder.defaultRecipes(RecipesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CustomRecipes", targetDepth)) {
                    context.nextToken();
                    layerBuilder.customRecipes(RecipesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    layerBuilder.createdAt((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstallUpdatesOnBoot", targetDepth)) {
                    context.nextToken();
                    layerBuilder.installUpdatesOnBoot((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("UseEbsOptimizedInstances", targetDepth)) {
                    context.nextToken();
                    layerBuilder.useEbsOptimizedInstances((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("LifecycleEventConfiguration", targetDepth)) {
                    context.nextToken();
                    layerBuilder.lifecycleEventConfiguration(LifecycleEventConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Layer)layerBuilder.build();
    }

    public static LayerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

