/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.services.opsworks.model.AssignInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.AssignInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.AssignVolumeRequest;
import software.amazon.awssdk.services.opsworks.model.AssignVolumeResponse;
import software.amazon.awssdk.services.opsworks.model.AssociateElasticIpRequest;
import software.amazon.awssdk.services.opsworks.model.AssociateElasticIpResponse;
import software.amazon.awssdk.services.opsworks.model.AttachElasticLoadBalancerRequest;
import software.amazon.awssdk.services.opsworks.model.AttachElasticLoadBalancerResponse;
import software.amazon.awssdk.services.opsworks.model.CloneStackRequest;
import software.amazon.awssdk.services.opsworks.model.CloneStackResponse;
import software.amazon.awssdk.services.opsworks.model.CreateAppRequest;
import software.amazon.awssdk.services.opsworks.model.CreateAppResponse;
import software.amazon.awssdk.services.opsworks.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.opsworks.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.opsworks.model.CreateInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.CreateInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.CreateLayerRequest;
import software.amazon.awssdk.services.opsworks.model.CreateLayerResponse;
import software.amazon.awssdk.services.opsworks.model.CreateStackRequest;
import software.amazon.awssdk.services.opsworks.model.CreateStackResponse;
import software.amazon.awssdk.services.opsworks.model.CreateUserProfileRequest;
import software.amazon.awssdk.services.opsworks.model.CreateUserProfileResponse;
import software.amazon.awssdk.services.opsworks.model.DeleteAppRequest;
import software.amazon.awssdk.services.opsworks.model.DeleteAppResponse;
import software.amazon.awssdk.services.opsworks.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.DeleteLayerRequest;
import software.amazon.awssdk.services.opsworks.model.DeleteLayerResponse;
import software.amazon.awssdk.services.opsworks.model.DeleteStackRequest;
import software.amazon.awssdk.services.opsworks.model.DeleteStackResponse;
import software.amazon.awssdk.services.opsworks.model.DeleteUserProfileRequest;
import software.amazon.awssdk.services.opsworks.model.DeleteUserProfileResponse;
import software.amazon.awssdk.services.opsworks.model.DeregisterEcsClusterRequest;
import software.amazon.awssdk.services.opsworks.model.DeregisterEcsClusterResponse;
import software.amazon.awssdk.services.opsworks.model.DeregisterElasticIpRequest;
import software.amazon.awssdk.services.opsworks.model.DeregisterElasticIpResponse;
import software.amazon.awssdk.services.opsworks.model.DeregisterInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.DeregisterInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.DeregisterRdsDbInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.DeregisterRdsDbInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.DeregisterVolumeRequest;
import software.amazon.awssdk.services.opsworks.model.DeregisterVolumeResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeAgentVersionsRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeAgentVersionsResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeAppsRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeAppsResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeCommandsRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeCommandsResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeDeploymentsRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeDeploymentsResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeEcsClustersRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeEcsClustersResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeElasticIpsRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeElasticIpsResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeElasticLoadBalancersRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeElasticLoadBalancersResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeLayersRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeLayersResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeLoadBasedAutoScalingRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeLoadBasedAutoScalingResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeMyUserProfileRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeMyUserProfileResponse;
import software.amazon.awssdk.services.opsworks.model.DescribePermissionsRequest;
import software.amazon.awssdk.services.opsworks.model.DescribePermissionsResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeRaidArraysRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeRaidArraysResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeRdsDbInstancesRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeRdsDbInstancesResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeServiceErrorsRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeServiceErrorsResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeStackProvisioningParametersRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeStackProvisioningParametersResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeStackSummaryRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeStackSummaryResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeStacksRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeStacksResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeTimeBasedAutoScalingRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeTimeBasedAutoScalingResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeUserProfilesRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeUserProfilesResponse;
import software.amazon.awssdk.services.opsworks.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.opsworks.model.DetachElasticLoadBalancerRequest;
import software.amazon.awssdk.services.opsworks.model.DetachElasticLoadBalancerResponse;
import software.amazon.awssdk.services.opsworks.model.DisassociateElasticIpRequest;
import software.amazon.awssdk.services.opsworks.model.DisassociateElasticIpResponse;
import software.amazon.awssdk.services.opsworks.model.GetHostnameSuggestionRequest;
import software.amazon.awssdk.services.opsworks.model.GetHostnameSuggestionResponse;
import software.amazon.awssdk.services.opsworks.model.GrantAccessRequest;
import software.amazon.awssdk.services.opsworks.model.GrantAccessResponse;
import software.amazon.awssdk.services.opsworks.model.ListTagsRequest;
import software.amazon.awssdk.services.opsworks.model.ListTagsResponse;
import software.amazon.awssdk.services.opsworks.model.RebootInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.RebootInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.RegisterEcsClusterRequest;
import software.amazon.awssdk.services.opsworks.model.RegisterEcsClusterResponse;
import software.amazon.awssdk.services.opsworks.model.RegisterElasticIpRequest;
import software.amazon.awssdk.services.opsworks.model.RegisterElasticIpResponse;
import software.amazon.awssdk.services.opsworks.model.RegisterInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.RegisterInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.RegisterRdsDbInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.RegisterRdsDbInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.RegisterVolumeRequest;
import software.amazon.awssdk.services.opsworks.model.RegisterVolumeResponse;
import software.amazon.awssdk.services.opsworks.model.ResourceNotFoundException;
import software.amazon.awssdk.services.opsworks.model.SetLoadBasedAutoScalingRequest;
import software.amazon.awssdk.services.opsworks.model.SetLoadBasedAutoScalingResponse;
import software.amazon.awssdk.services.opsworks.model.SetPermissionRequest;
import software.amazon.awssdk.services.opsworks.model.SetPermissionResponse;
import software.amazon.awssdk.services.opsworks.model.SetTimeBasedAutoScalingRequest;
import software.amazon.awssdk.services.opsworks.model.SetTimeBasedAutoScalingResponse;
import software.amazon.awssdk.services.opsworks.model.StartInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.StartInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.StartStackRequest;
import software.amazon.awssdk.services.opsworks.model.StartStackResponse;
import software.amazon.awssdk.services.opsworks.model.StopInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.StopInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.StopStackRequest;
import software.amazon.awssdk.services.opsworks.model.StopStackResponse;
import software.amazon.awssdk.services.opsworks.model.TagResourceRequest;
import software.amazon.awssdk.services.opsworks.model.TagResourceResponse;
import software.amazon.awssdk.services.opsworks.model.UnassignInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.UnassignInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.UnassignVolumeRequest;
import software.amazon.awssdk.services.opsworks.model.UnassignVolumeResponse;
import software.amazon.awssdk.services.opsworks.model.UntagResourceRequest;
import software.amazon.awssdk.services.opsworks.model.UntagResourceResponse;
import software.amazon.awssdk.services.opsworks.model.UpdateAppRequest;
import software.amazon.awssdk.services.opsworks.model.UpdateAppResponse;
import software.amazon.awssdk.services.opsworks.model.UpdateElasticIpRequest;
import software.amazon.awssdk.services.opsworks.model.UpdateElasticIpResponse;
import software.amazon.awssdk.services.opsworks.model.UpdateInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.UpdateInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.UpdateLayerRequest;
import software.amazon.awssdk.services.opsworks.model.UpdateLayerResponse;
import software.amazon.awssdk.services.opsworks.model.UpdateMyUserProfileRequest;
import software.amazon.awssdk.services.opsworks.model.UpdateMyUserProfileResponse;
import software.amazon.awssdk.services.opsworks.model.UpdateRdsDbInstanceRequest;
import software.amazon.awssdk.services.opsworks.model.UpdateRdsDbInstanceResponse;
import software.amazon.awssdk.services.opsworks.model.UpdateStackRequest;
import software.amazon.awssdk.services.opsworks.model.UpdateStackResponse;
import software.amazon.awssdk.services.opsworks.model.UpdateUserProfileRequest;
import software.amazon.awssdk.services.opsworks.model.UpdateUserProfileResponse;
import software.amazon.awssdk.services.opsworks.model.UpdateVolumeRequest;
import software.amazon.awssdk.services.opsworks.model.UpdateVolumeResponse;
import software.amazon.awssdk.services.opsworks.model.ValidationException;
import software.amazon.awssdk.services.opsworks.transform.AssignInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.AssignInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.AssignVolumeRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.AssignVolumeResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.AssociateElasticIpRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.AssociateElasticIpResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.AttachElasticLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.AttachElasticLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.CloneStackRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.CloneStackResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateAppResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateLayerRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateLayerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateStackRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateStackResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateUserProfileRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.CreateUserProfileResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeleteAppResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeleteInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeleteLayerRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeleteLayerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeleteStackRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeleteStackResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeleteUserProfileRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeleteUserProfileResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeregisterEcsClusterRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeregisterEcsClusterResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeregisterElasticIpRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeregisterElasticIpResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeregisterInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeregisterInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeregisterRdsDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeregisterRdsDbInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeregisterVolumeRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DeregisterVolumeResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeAgentVersionsRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeAgentVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeAppsRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeAppsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeCommandsRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeCommandsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeDeploymentsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeEcsClustersRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeEcsClustersResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeElasticIpsRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeElasticIpsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeElasticLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeElasticLoadBalancersResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeInstancesRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeLayersRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeLayersResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeLoadBasedAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeLoadBasedAutoScalingResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeMyUserProfileRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeMyUserProfileResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribePermissionsRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribePermissionsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeRaidArraysRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeRaidArraysResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeRdsDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeRdsDbInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeServiceErrorsRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeServiceErrorsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeStackProvisioningParametersRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeStackProvisioningParametersResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeStackSummaryRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeStackSummaryResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeStacksRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeStacksResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeTimeBasedAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeTimeBasedAutoScalingResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeUserProfilesRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeUserProfilesResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeVolumesRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DescribeVolumesResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DetachElasticLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DetachElasticLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.DisassociateElasticIpRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.DisassociateElasticIpResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.GetHostnameSuggestionRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.GetHostnameSuggestionResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.GrantAccessRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.GrantAccessResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.ListTagsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.RebootInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.RebootInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.RegisterEcsClusterRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.RegisterEcsClusterResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.RegisterElasticIpRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.RegisterElasticIpResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.RegisterInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.RegisterInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.RegisterRdsDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.RegisterRdsDbInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.RegisterVolumeRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.RegisterVolumeResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.SetLoadBasedAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.SetLoadBasedAutoScalingResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.SetPermissionRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.SetPermissionResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.SetTimeBasedAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.SetTimeBasedAutoScalingResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.StartInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.StartInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.StartStackRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.StartStackResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.StopInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.StopInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.StopStackRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.StopStackResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UnassignInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UnassignInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UnassignVolumeRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UnassignVolumeResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateAppRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateAppResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateElasticIpRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateElasticIpResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateLayerRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateLayerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateMyUserProfileRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateMyUserProfileResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateRdsDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateRdsDbInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateStackRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateStackResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateUserProfileRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateUserProfileResponseUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateVolumeRequestMarshaller;
import software.amazon.awssdk.services.opsworks.transform.UpdateVolumeResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link OpsWorksAsyncClient}.
 *
 * @see OpsWorksAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultOpsWorksAsyncClient implements OpsWorksAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultOpsWorksAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Assign a registered instance to a layer.
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can assign registered on-premises instances to any layer type.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can assign registered Amazon EC2 instances only to custom layers.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use this action with instances that were created with AWS OpsWorks Stacks.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Required Permissions</b>: To use this action, an AWS Identity and Access Management (IAM) user must have a
     * Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more
     * information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param assignInstanceRequest
     * @return A Java Future containing the result of the AssignInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.AssignInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssignInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssignInstanceResponse> assignInstance(AssignInstanceRequest assignInstanceRequest) {
        try {

            HttpResponseHandler<AssignInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AssignInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<AssignInstanceRequest, AssignInstanceResponse>()
                    .withMarshaller(new AssignInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(assignInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns one of the stack's registered Amazon EBS volumes to a specified instance. The volume must first be
     * registered with the stack by calling <a>RegisterVolume</a>. After you register the volume, you must call
     * <a>UpdateVolume</a> to specify a mount point before calling <code>AssignVolume</code>. For more information, see
     * <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param assignVolumeRequest
     * @return A Java Future containing the result of the AssignVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.AssignVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssignVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssignVolumeResponse> assignVolume(AssignVolumeRequest assignVolumeRequest) {
        try {

            HttpResponseHandler<AssignVolumeResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AssignVolumeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<AssignVolumeRequest, AssignVolumeResponse>()
                    .withMarshaller(new AssignVolumeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(assignVolumeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates one of the stack's registered Elastic IP addresses with a specified instance. The address must first
     * be registered with the stack by calling <a>RegisterElasticIp</a>. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param associateElasticIpRequest
     * @return A Java Future containing the result of the AssociateElasticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.AssociateElasticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssociateElasticIp" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateElasticIpResponse> associateElasticIp(AssociateElasticIpRequest associateElasticIpRequest) {
        try {

            HttpResponseHandler<AssociateElasticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AssociateElasticIpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<AssociateElasticIpRequest, AssociateElasticIpResponse>()
                    .withMarshaller(new AssociateElasticIpRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(associateElasticIpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches an Elastic Load Balancing load balancer to a specified layer. AWS OpsWorks Stacks does not support
     * Application Load Balancer. You can only use Classic Load Balancer with AWS OpsWorks Stacks. For more information,
     * see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/layers-elb.html">Elastic Load Balancing</a>.
     * </p>
     * <note>
     * <p>
     * You must create the Elastic Load Balancing instance separately, by using the Elastic Load Balancing console, API,
     * or CLI. For more information, see <a
     * href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/Welcome.html"> Elastic Load Balancing
     * Developer Guide</a>.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param attachElasticLoadBalancerRequest
     * @return A Java Future containing the result of the AttachElasticLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.AttachElasticLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AttachElasticLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachElasticLoadBalancerResponse> attachElasticLoadBalancer(
            AttachElasticLoadBalancerRequest attachElasticLoadBalancerRequest) {
        try {

            HttpResponseHandler<AttachElasticLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AttachElasticLoadBalancerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<AttachElasticLoadBalancerRequest, AttachElasticLoadBalancerResponse>()
                            .withMarshaller(new AttachElasticLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachElasticLoadBalancerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a clone of a specified stack. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-cloning.html">Clone a Stack</a>. By
     * default, all parameters are set to the values used by the parent stack.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants
     * permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param cloneStackRequest
     * @return A Java Future containing the result of the CloneStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.CloneStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CloneStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CloneStackResponse> cloneStack(CloneStackRequest cloneStackRequest) {
        try {

            HttpResponseHandler<CloneStackResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CloneStackResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CloneStackRequest, CloneStackResponse>()
                    .withMarshaller(new CloneStackRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(cloneStackRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an app for a specified stack. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Creating Apps</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param createAppRequest
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.CreateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        try {

            HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateAppResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>()
                    .withMarshaller(new CreateAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAppRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Runs deployment or stack commands. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploying.html">Deploying Apps</a> and <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-commands.html">Run Stack Commands</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Deploy or Manage permissions level for
     * the stack, or an attached policy that explicitly grants permissions. For more information on user permissions,
     * see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param createDeploymentRequest
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.CreateDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        try {

            HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateDeploymentResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                    .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDeploymentRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an instance in a specified stack. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html">Adding an Instance to a
     * Layer</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param createInstanceRequest
     * @return A Java Future containing the result of the CreateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.CreateInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceResponse> createInstance(CreateInstanceRequest createInstanceRequest) {
        try {

            HttpResponseHandler<CreateInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CreateInstanceRequest, CreateInstanceResponse>()
                    .withMarshaller(new CreateInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a layer. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-create.html">How to Create a
     * Layer</a>.
     * </p>
     * <note>
     * <p>
     * You should use <b>CreateLayer</b> for noncustom layer types such as PHP App Server only if the stack does not
     * have an existing layer of that type. A stack can have at most one instance of each noncustom layer; if you
     * attempt to create a second instance, <b>CreateLayer</b> fails. A stack can have an arbitrary number of custom
     * layers, so you can call <b>CreateLayer</b> as many times as you like for that layer type.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param createLayerRequest
     * @return A Java Future containing the result of the CreateLayer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.CreateLayer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateLayer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLayerResponse> createLayer(CreateLayerRequest createLayerRequest) {
        try {

            HttpResponseHandler<CreateLayerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateLayerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CreateLayerRequest, CreateLayerResponse>()
                    .withMarshaller(new CreateLayerRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createLayerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new stack. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-edit.html">Create a New Stack</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants
     * permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param createStackRequest
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStackResponse> createStack(CreateStackRequest createStackRequest) {
        try {

            HttpResponseHandler<CreateStackResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateStackResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CreateStackRequest, CreateStackResponse>()
                    .withMarshaller(new CreateStackRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createStackRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new user profile.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants
     * permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param createUserProfileRequest
     * @return A Java Future containing the result of the CreateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.CreateUserProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateUserProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserProfileResponse> createUserProfile(CreateUserProfileRequest createUserProfileRequest) {
        try {

            HttpResponseHandler<CreateUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateUserProfileResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CreateUserProfileRequest, CreateUserProfileResponse>()
                    .withMarshaller(new CreateUserProfileRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createUserProfileRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified app.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param deleteAppRequest
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DeleteApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        try {

            HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteAppResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>()
                    .withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAppRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified instance, which terminates the associated Amazon EC2 instance. You must stop an instance
     * before you can delete it.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-delete.html">Deleting Instances</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param deleteInstanceRequest
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DeleteInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {
        try {

            HttpResponseHandler<DeleteInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteInstanceRequest, DeleteInstanceResponse>()
                    .withMarshaller(new DeleteInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified layer. You must first stop and then delete all associated instances or unassign registered
     * instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-delete.html">How to Delete a
     * Layer</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param deleteLayerRequest
     * @return A Java Future containing the result of the DeleteLayer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DeleteLayer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteLayer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLayerResponse> deleteLayer(DeleteLayerRequest deleteLayerRequest) {
        try {

            HttpResponseHandler<DeleteLayerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteLayerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteLayerRequest, DeleteLayerResponse>()
                    .withMarshaller(new DeleteLayerRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteLayerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified stack. You must first delete all instances, layers, and apps or deregister registered
     * instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-shutting.html">Shut Down a Stack</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param deleteStackRequest
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStackResponse> deleteStack(DeleteStackRequest deleteStackRequest) {
        try {

            HttpResponseHandler<DeleteStackResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteStackResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteStackRequest, DeleteStackResponse>()
                    .withMarshaller(new DeleteStackRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteStackRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user profile.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants
     * permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param deleteUserProfileRequest
     * @return A Java Future containing the result of the DeleteUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DeleteUserProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteUserProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserProfileResponse> deleteUserProfile(DeleteUserProfileRequest deleteUserProfileRequest) {
        try {

            HttpResponseHandler<DeleteUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteUserProfileResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteUserProfileRequest, DeleteUserProfileResponse>()
                    .withMarshaller(new DeleteUserProfileRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserProfileRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters a specified Amazon ECS cluster from a stack. For more information, see <a href=
     * "http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html#workinglayers-ecscluster-delete"
     * > Resource Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html"
     * >http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html</a>.
     * </p>
     *
     * @param deregisterEcsClusterRequest
     * @return A Java Future containing the result of the DeregisterEcsCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DeregisterEcsCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterEcsCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterEcsClusterResponse> deregisterEcsCluster(
            DeregisterEcsClusterRequest deregisterEcsClusterRequest) {
        try {

            HttpResponseHandler<DeregisterEcsClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeregisterEcsClusterResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeregisterEcsClusterRequest, DeregisterEcsClusterResponse>()
                    .withMarshaller(new DeregisterEcsClusterRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deregisterEcsClusterRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters a specified Elastic IP address. The address can then be registered by another stack. For more
     * information, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource
     * Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param deregisterElasticIpRequest
     * @return A Java Future containing the result of the DeregisterElasticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DeregisterElasticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterElasticIp" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterElasticIpResponse> deregisterElasticIp(
            DeregisterElasticIpRequest deregisterElasticIpRequest) {
        try {

            HttpResponseHandler<DeregisterElasticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeregisterElasticIpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeregisterElasticIpRequest, DeregisterElasticIpResponse>()
                    .withMarshaller(new DeregisterElasticIpRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deregisterElasticIpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregister a registered Amazon EC2 or on-premises instance. This action removes the instance from the stack and
     * returns it to your control. This action can not be used with instances that were created with AWS OpsWorks
     * Stacks.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param deregisterInstanceRequest
     * @return A Java Future containing the result of the DeregisterInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DeregisterInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterInstanceResponse> deregisterInstance(DeregisterInstanceRequest deregisterInstanceRequest) {
        try {

            HttpResponseHandler<DeregisterInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeregisterInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeregisterInstanceRequest, DeregisterInstanceResponse>()
                    .withMarshaller(new DeregisterInstanceRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deregisterInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters an Amazon RDS instance.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param deregisterRdsDbInstanceRequest
     * @return A Java Future containing the result of the DeregisterRdsDbInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DeregisterRdsDbInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterRdsDbInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterRdsDbInstanceResponse> deregisterRdsDbInstance(
            DeregisterRdsDbInstanceRequest deregisterRdsDbInstanceRequest) {
        try {

            HttpResponseHandler<DeregisterRdsDbInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeregisterRdsDbInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterRdsDbInstanceRequest, DeregisterRdsDbInstanceResponse>()
                            .withMarshaller(new DeregisterRdsDbInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deregisterRdsDbInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters an Amazon EBS volume. The volume can then be registered by another stack. For more information, see
     * <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param deregisterVolumeRequest
     * @return A Java Future containing the result of the DeregisterVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DeregisterVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterVolumeResponse> deregisterVolume(DeregisterVolumeRequest deregisterVolumeRequest) {
        try {

            HttpResponseHandler<DeregisterVolumeResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeregisterVolumeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeregisterVolumeRequest, DeregisterVolumeResponse>()
                    .withMarshaller(new DeregisterVolumeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deregisterVolumeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the available AWS OpsWorks Stacks agent versions. You must specify a stack ID or a configuration
     * manager. <code>DescribeAgentVersions</code> returns a list of available agent versions for the specified stack or
     * configuration manager.
     * </p>
     *
     * @param describeAgentVersionsRequest
     * @return A Java Future containing the result of the DescribeAgentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeAgentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeAgentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAgentVersionsResponse> describeAgentVersions(
            DescribeAgentVersionsRequest describeAgentVersionsRequest) {
        try {

            HttpResponseHandler<DescribeAgentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeAgentVersionsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeAgentVersionsRequest, DescribeAgentVersionsResponse>()
                    .withMarshaller(new DescribeAgentVersionsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeAgentVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a description of a specified set of apps.
     * </p>
     * <note>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeAppsRequest
     * @return A Java Future containing the result of the DescribeApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeApps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAppsResponse> describeApps(DescribeAppsRequest describeAppsRequest) {
        try {

            HttpResponseHandler<DescribeAppsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeAppsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeAppsRequest, DescribeAppsResponse>()
                    .withMarshaller(new DescribeAppsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAppsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the results of specified commands.
     * </p>
     * <note>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeCommandsRequest
     * @return A Java Future containing the result of the DescribeCommands operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeCommands
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeCommands" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCommandsResponse> describeCommands(DescribeCommandsRequest describeCommandsRequest) {
        try {

            HttpResponseHandler<DescribeCommandsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeCommandsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeCommandsRequest, DescribeCommandsResponse>()
                    .withMarshaller(new DescribeCommandsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeCommandsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a description of a specified set of deployments.
     * </p>
     * <note>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeDeploymentsRequest
     * @return A Java Future containing the result of the DescribeDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDeploymentsResponse> describeDeployments(
            DescribeDeploymentsRequest describeDeploymentsRequest) {
        try {

            HttpResponseHandler<DescribeDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeDeploymentsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeDeploymentsRequest, DescribeDeploymentsResponse>()
                    .withMarshaller(new DescribeDeploymentsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeDeploymentsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes Amazon ECS clusters that are registered with a stack. If you specify only a stack ID, you can use the
     * <code>MaxResults</code> and <code>NextToken</code> parameters to paginate the response. However, AWS OpsWorks
     * Stacks currently supports only one cluster per layer, so the result set has a maximum of one element.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack or an attached policy that explicitly grants permission. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     *
     * @param describeEcsClustersRequest
     * @return A Java Future containing the result of the DescribeEcsClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeEcsClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeEcsClusters" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEcsClustersResponse> describeEcsClusters(
            DescribeEcsClustersRequest describeEcsClustersRequest) {
        try {

            HttpResponseHandler<DescribeEcsClustersResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeEcsClustersResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeEcsClustersRequest, DescribeEcsClustersResponse>()
                    .withMarshaller(new DescribeEcsClustersRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeEcsClustersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     * addresses</a>.
     * </p>
     * <note>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeElasticIpsRequest
     * @return A Java Future containing the result of the DescribeElasticIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeElasticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeElasticIps" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeElasticIpsResponse> describeElasticIps(DescribeElasticIpsRequest describeElasticIpsRequest) {
        try {

            HttpResponseHandler<DescribeElasticIpsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeElasticIpsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeElasticIpsRequest, DescribeElasticIpsResponse>()
                    .withMarshaller(new DescribeElasticIpsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeElasticIpsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a stack's Elastic Load Balancing instances.
     * </p>
     * <note>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeElasticLoadBalancersRequest
     * @return A Java Future containing the result of the DescribeElasticLoadBalancers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeElasticLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeElasticLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeElasticLoadBalancersResponse> describeElasticLoadBalancers(
            DescribeElasticLoadBalancersRequest describeElasticLoadBalancersRequest) {
        try {

            HttpResponseHandler<DescribeElasticLoadBalancersResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeElasticLoadBalancersResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeElasticLoadBalancersRequest, DescribeElasticLoadBalancersResponse>()
                            .withMarshaller(new DescribeElasticLoadBalancersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeElasticLoadBalancersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a description of a set of instances.
     * </p>
     * <note>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeInstancesRequest
     * @return A Java Future containing the result of the DescribeInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstancesResponse> describeInstances(DescribeInstancesRequest describeInstancesRequest) {
        try {

            HttpResponseHandler<DescribeInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeInstancesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeInstancesRequest, DescribeInstancesResponse>()
                    .withMarshaller(new DescribeInstancesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeInstancesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a description of one or more layers in a specified stack.
     * </p>
     * <note>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeLayersRequest
     * @return A Java Future containing the result of the DescribeLayers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeLayers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeLayers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLayersResponse> describeLayers(DescribeLayersRequest describeLayersRequest) {
        try {

            HttpResponseHandler<DescribeLayersResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeLayersResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeLayersRequest, DescribeLayersResponse>()
                    .withMarshaller(new DescribeLayersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeLayersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes load-based auto scaling configurations for specified layers.
     * </p>
     * <note>
     * <p>
     * You must specify at least one of the parameters.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeLoadBasedAutoScalingRequest
     * @return A Java Future containing the result of the DescribeLoadBasedAutoScaling operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeLoadBasedAutoScaling
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeLoadBasedAutoScaling"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoadBasedAutoScalingResponse> describeLoadBasedAutoScaling(
            DescribeLoadBasedAutoScalingRequest describeLoadBasedAutoScalingRequest) {
        try {

            HttpResponseHandler<DescribeLoadBasedAutoScalingResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeLoadBasedAutoScalingResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeLoadBasedAutoScalingRequest, DescribeLoadBasedAutoScalingResponse>()
                            .withMarshaller(new DescribeLoadBasedAutoScalingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLoadBasedAutoScalingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a user's SSH information.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have self-management enabled or an attached
     * policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeMyUserProfileRequest
     * @return A Java Future containing the result of the DescribeMyUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeMyUserProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeMyUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMyUserProfileResponse> describeMyUserProfile(
            DescribeMyUserProfileRequest describeMyUserProfileRequest) {
        try {

            HttpResponseHandler<DescribeMyUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeMyUserProfileResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeMyUserProfileRequest, DescribeMyUserProfileResponse>()
                    .withMarshaller(new DescribeMyUserProfileRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeMyUserProfileRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the permissions for a specified stack.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describePermissionsRequest
     * @return A Java Future containing the result of the DescribePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribePermissions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePermissionsResponse> describePermissions(
            DescribePermissionsRequest describePermissionsRequest) {
        try {

            HttpResponseHandler<DescribePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribePermissionsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribePermissionsRequest, DescribePermissionsResponse>()
                    .withMarshaller(new DescribePermissionsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describePermissionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe an instance's RAID arrays.
     * </p>
     * <note>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeRaidArraysRequest
     * @return A Java Future containing the result of the DescribeRaidArrays operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeRaidArrays
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeRaidArrays" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRaidArraysResponse> describeRaidArrays(DescribeRaidArraysRequest describeRaidArraysRequest) {
        try {

            HttpResponseHandler<DescribeRaidArraysResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeRaidArraysResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeRaidArraysRequest, DescribeRaidArraysResponse>()
                    .withMarshaller(new DescribeRaidArraysRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeRaidArraysRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes Amazon RDS instances.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     *
     * @param describeRdsDbInstancesRequest
     * @return A Java Future containing the result of the DescribeRdsDbInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeRdsDbInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeRdsDbInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRdsDbInstancesResponse> describeRdsDbInstances(
            DescribeRdsDbInstancesRequest describeRdsDbInstancesRequest) {
        try {

            HttpResponseHandler<DescribeRdsDbInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeRdsDbInstancesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRdsDbInstancesRequest, DescribeRdsDbInstancesResponse>()
                            .withMarshaller(new DescribeRdsDbInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeRdsDbInstancesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes AWS OpsWorks Stacks service errors.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     *
     * @param describeServiceErrorsRequest
     * @return A Java Future containing the result of the DescribeServiceErrors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeServiceErrors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeServiceErrors" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeServiceErrorsResponse> describeServiceErrors(
            DescribeServiceErrorsRequest describeServiceErrorsRequest) {
        try {

            HttpResponseHandler<DescribeServiceErrorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeServiceErrorsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeServiceErrorsRequest, DescribeServiceErrorsResponse>()
                    .withMarshaller(new DescribeServiceErrorsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeServiceErrorsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a description of a stack's provisioning parameters.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeStackProvisioningParametersRequest
     * @return A Java Future containing the result of the DescribeStackProvisioningParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeStackProvisioningParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeStackProvisioningParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStackProvisioningParametersResponse> describeStackProvisioningParameters(
            DescribeStackProvisioningParametersRequest describeStackProvisioningParametersRequest) {
        try {

            HttpResponseHandler<DescribeStackProvisioningParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(
                            new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                            new DescribeStackProvisioningParametersResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeStackProvisioningParametersRequest, DescribeStackProvisioningParametersResponse>()
                            .withMarshaller(new DescribeStackProvisioningParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeStackProvisioningParametersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the number of layers and apps in a specified stack, and the number of instances in each state, such as
     * <code>running_setup</code> or <code>online</code>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeStackSummaryRequest
     * @return A Java Future containing the result of the DescribeStackSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeStackSummary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeStackSummary" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStackSummaryResponse> describeStackSummary(
            DescribeStackSummaryRequest describeStackSummaryRequest) {
        try {

            HttpResponseHandler<DescribeStackSummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeStackSummaryResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeStackSummaryRequest, DescribeStackSummaryResponse>()
                    .withMarshaller(new DescribeStackSummaryRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeStackSummaryRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a description of one or more stacks.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeStacksRequest
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStacksResponse> describeStacks(DescribeStacksRequest describeStacksRequest) {
        try {

            HttpResponseHandler<DescribeStacksResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeStacksResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeStacksRequest, DescribeStacksResponse>()
                    .withMarshaller(new DescribeStacksRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeStacksRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes time-based auto scaling configurations for specified instances.
     * </p>
     * <note>
     * <p>
     * You must specify at least one of the parameters.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeTimeBasedAutoScalingRequest
     * @return A Java Future containing the result of the DescribeTimeBasedAutoScaling operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeTimeBasedAutoScaling
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeTimeBasedAutoScaling"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTimeBasedAutoScalingResponse> describeTimeBasedAutoScaling(
            DescribeTimeBasedAutoScalingRequest describeTimeBasedAutoScalingRequest) {
        try {

            HttpResponseHandler<DescribeTimeBasedAutoScalingResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeTimeBasedAutoScalingResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTimeBasedAutoScalingRequest, DescribeTimeBasedAutoScalingResponse>()
                            .withMarshaller(new DescribeTimeBasedAutoScalingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeTimeBasedAutoScalingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe specified users.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants
     * permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeUserProfilesRequest
     * @return A Java Future containing the result of the DescribeUserProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeUserProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeUserProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserProfilesResponse> describeUserProfiles(
            DescribeUserProfilesRequest describeUserProfilesRequest) {
        try {

            HttpResponseHandler<DescribeUserProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeUserProfilesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeUserProfilesRequest, DescribeUserProfilesResponse>()
                    .withMarshaller(new DescribeUserProfilesRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeUserProfilesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an instance's Amazon EBS volumes.
     * </p>
     * <note>
     * <p>
     * This call accepts only one resource-identifying parameter.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Show, Deploy, or Manage permissions
     * level for the stack, or an attached policy that explicitly grants permissions. For more information on user
     * permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param describeVolumesRequest
     * @return A Java Future containing the result of the DescribeVolumes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DescribeVolumes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeVolumes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVolumesResponse> describeVolumes(DescribeVolumesRequest describeVolumesRequest) {
        try {

            HttpResponseHandler<DescribeVolumesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeVolumesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeVolumesRequest, DescribeVolumesResponse>()
                    .withMarshaller(new DescribeVolumesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeVolumesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a specified Elastic Load Balancing instance from its layer.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param detachElasticLoadBalancerRequest
     * @return A Java Future containing the result of the DetachElasticLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DetachElasticLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DetachElasticLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachElasticLoadBalancerResponse> detachElasticLoadBalancer(
            DetachElasticLoadBalancerRequest detachElasticLoadBalancerRequest) {
        try {

            HttpResponseHandler<DetachElasticLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DetachElasticLoadBalancerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DetachElasticLoadBalancerRequest, DetachElasticLoadBalancerResponse>()
                            .withMarshaller(new DetachElasticLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachElasticLoadBalancerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates an Elastic IP address from its instance. The address remains registered with the stack. For more
     * information, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource
     * Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param disassociateElasticIpRequest
     * @return A Java Future containing the result of the DisassociateElasticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.DisassociateElasticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DisassociateElasticIp" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateElasticIpResponse> disassociateElasticIp(
            DisassociateElasticIpRequest disassociateElasticIpRequest) {
        try {

            HttpResponseHandler<DisassociateElasticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DisassociateElasticIpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DisassociateElasticIpRequest, DisassociateElasticIpResponse>()
                    .withMarshaller(new DisassociateElasticIpRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(disassociateElasticIpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a generated host name for the specified layer, based on the current host name theme.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param getHostnameSuggestionRequest
     * @return A Java Future containing the result of the GetHostnameSuggestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.GetHostnameSuggestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/GetHostnameSuggestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetHostnameSuggestionResponse> getHostnameSuggestion(
            GetHostnameSuggestionRequest getHostnameSuggestionRequest) {
        try {

            HttpResponseHandler<GetHostnameSuggestionResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetHostnameSuggestionResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GetHostnameSuggestionRequest, GetHostnameSuggestionResponse>()
                    .withMarshaller(new GetHostnameSuggestionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getHostnameSuggestionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action can be used only with Windows stacks.
     * </p>
     * </note>
     * <p>
     * Grants RDP access to a Windows instance for a specified time period.
     * </p>
     *
     * @param grantAccessRequest
     * @return A Java Future containing the result of the GrantAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.GrantAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/GrantAccess" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GrantAccessResponse> grantAccess(GrantAccessRequest grantAccessRequest) {
        try {

            HttpResponseHandler<GrantAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GrantAccessResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<GrantAccessRequest, GrantAccessResponse>()
                    .withMarshaller(new GrantAccessRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(grantAccessRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified stack or layer.
     * </p>
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        try {

            HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ListTagsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>()
                    .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Reboots a specified instance. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html">Starting, Stopping,
     * and Rebooting Instances</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param rebootInstanceRequest
     * @return A Java Future containing the result of the RebootInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.RebootInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RebootInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootInstanceResponse> rebootInstance(RebootInstanceRequest rebootInstanceRequest) {
        try {

            HttpResponseHandler<RebootInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new RebootInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<RebootInstanceRequest, RebootInstanceResponse>()
                    .withMarshaller(new RebootInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(rebootInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a specified Amazon ECS cluster with a stack. You can register only one cluster with a stack. A cluster
     * can be registered with only one stack. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html"> Resource
     * Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html"> Managing User
     * Permissions</a>.
     * </p>
     *
     * @param registerEcsClusterRequest
     * @return A Java Future containing the result of the RegisterEcsCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.RegisterEcsCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterEcsCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterEcsClusterResponse> registerEcsCluster(RegisterEcsClusterRequest registerEcsClusterRequest) {
        try {

            HttpResponseHandler<RegisterEcsClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new RegisterEcsClusterResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<RegisterEcsClusterRequest, RegisterEcsClusterResponse>()
                    .withMarshaller(new RegisterEcsClusterRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(registerEcsClusterRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers an Elastic IP address with a specified stack. An address can be registered with only one stack at a
     * time. If the address is already registered, you must first deregister it by calling <a>DeregisterElasticIp</a>.
     * For more information, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource
     * Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param registerElasticIpRequest
     * @return A Java Future containing the result of the RegisterElasticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.RegisterElasticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterElasticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterElasticIpResponse> registerElasticIp(RegisterElasticIpRequest registerElasticIpRequest) {
        try {

            HttpResponseHandler<RegisterElasticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new RegisterElasticIpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<RegisterElasticIpRequest, RegisterElasticIpResponse>()
                    .withMarshaller(new RegisterElasticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(registerElasticIpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers instances that were created outside of AWS OpsWorks Stacks with a specified stack.
     * </p>
     * <note>
     * <p>
     * We do not recommend using this action to register instances. The complete registration operation includes two
     * tasks: installing the AWS OpsWorks Stacks agent on the instance, and registering the instance with the stack.
     * <code>RegisterInstance</code> handles only the second step. You should instead use the AWS CLI
     * <code>register</code> command, which performs the entire registration operation. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register.html"> Registering an
     * Instance with an AWS OpsWorks Stacks Stack</a>.
     * </p>
     * </note>
     * <p>
     * Registered instances have the same requirements as instances that are created by using the <a>CreateInstance</a>
     * API. For example, registered instances must be running a supported Linux-based operating system, and they must
     * have a supported instance type. For more information about requirements for instances that you want to register,
     * see <a href=
     * "http://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register-registering-preparer.html">
     * Preparing the Instance</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param registerInstanceRequest
     * @return A Java Future containing the result of the RegisterInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.RegisterInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterInstanceResponse> registerInstance(RegisterInstanceRequest registerInstanceRequest) {
        try {

            HttpResponseHandler<RegisterInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new RegisterInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<RegisterInstanceRequest, RegisterInstanceResponse>()
                    .withMarshaller(new RegisterInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(registerInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers an Amazon RDS instance with a stack.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param registerRdsDbInstanceRequest
     * @return A Java Future containing the result of the RegisterRdsDbInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.RegisterRdsDbInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterRdsDbInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterRdsDbInstanceResponse> registerRdsDbInstance(
            RegisterRdsDbInstanceRequest registerRdsDbInstanceRequest) {
        try {

            HttpResponseHandler<RegisterRdsDbInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new RegisterRdsDbInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<RegisterRdsDbInstanceRequest, RegisterRdsDbInstanceResponse>()
                    .withMarshaller(new RegisterRdsDbInstanceRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(registerRdsDbInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers an Amazon EBS volume with a specified stack. A volume can be registered with only one stack at a time.
     * If the volume is already registered, you must first deregister it by calling <a>DeregisterVolume</a>. For more
     * information, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource
     * Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param registerVolumeRequest
     * @return A Java Future containing the result of the RegisterVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.RegisterVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterVolumeResponse> registerVolume(RegisterVolumeRequest registerVolumeRequest) {
        try {

            HttpResponseHandler<RegisterVolumeResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new RegisterVolumeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<RegisterVolumeRequest, RegisterVolumeResponse>()
                    .withMarshaller(new RegisterVolumeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(registerVolumeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specify the load-based auto scaling configuration for a specified layer. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html">Managing Load with
     * Time-based and Load-based Instances</a>.
     * </p>
     * <note>
     * <p>
     * To use load-based auto scaling, you must create a set of load-based auto scaling instances. Load-based auto
     * scaling operates only on the instances from that set, so you must ensure that you have created enough instances
     * to handle the maximum anticipated load.
     * </p>
     * </note>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param setLoadBasedAutoScalingRequest
     * @return A Java Future containing the result of the SetLoadBasedAutoScaling operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.SetLoadBasedAutoScaling
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/SetLoadBasedAutoScaling"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetLoadBasedAutoScalingResponse> setLoadBasedAutoScaling(
            SetLoadBasedAutoScalingRequest setLoadBasedAutoScalingRequest) {
        try {

            HttpResponseHandler<SetLoadBasedAutoScalingResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new SetLoadBasedAutoScalingResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<SetLoadBasedAutoScalingRequest, SetLoadBasedAutoScalingResponse>()
                            .withMarshaller(new SetLoadBasedAutoScalingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setLoadBasedAutoScalingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specifies a user's permissions. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingsecurity.html">Security and Permissions</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param setPermissionRequest
     * @return A Java Future containing the result of the SetPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.SetPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/SetPermission" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SetPermissionResponse> setPermission(SetPermissionRequest setPermissionRequest) {
        try {

            HttpResponseHandler<SetPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new SetPermissionResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<SetPermissionRequest, SetPermissionResponse>()
                    .withMarshaller(new SetPermissionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(setPermissionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specify the time-based auto scaling configuration for a specified instance. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html">Managing Load with
     * Time-based and Load-based Instances</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param setTimeBasedAutoScalingRequest
     * @return A Java Future containing the result of the SetTimeBasedAutoScaling operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.SetTimeBasedAutoScaling
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/SetTimeBasedAutoScaling"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetTimeBasedAutoScalingResponse> setTimeBasedAutoScaling(
            SetTimeBasedAutoScalingRequest setTimeBasedAutoScalingRequest) {
        try {

            HttpResponseHandler<SetTimeBasedAutoScalingResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new SetTimeBasedAutoScalingResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<SetTimeBasedAutoScalingRequest, SetTimeBasedAutoScalingResponse>()
                            .withMarshaller(new SetTimeBasedAutoScalingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setTimeBasedAutoScalingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a specified instance. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html">Starting, Stopping,
     * and Rebooting Instances</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param startInstanceRequest
     * @return A Java Future containing the result of the StartInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.StartInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StartInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartInstanceResponse> startInstance(StartInstanceRequest startInstanceRequest) {
        try {

            HttpResponseHandler<StartInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new StartInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<StartInstanceRequest, StartInstanceResponse>()
                    .withMarshaller(new StartInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a stack's instances.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param startStackRequest
     * @return A Java Future containing the result of the StartStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.StartStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StartStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartStackResponse> startStack(StartStackRequest startStackRequest) {
        try {

            HttpResponseHandler<StartStackResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new StartStackResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<StartStackRequest, StartStackResponse>()
                    .withMarshaller(new StartStackRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startStackRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a specified instance. When you stop a standard instance, the data disappears and must be reinstalled when
     * you restart the instance. You can stop an Amazon EBS-backed instance without losing data. For more information,
     * see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html">Starting,
     * Stopping, and Rebooting Instances</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param stopInstanceRequest
     * @return A Java Future containing the result of the StopInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.StopInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StopInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopInstanceResponse> stopInstance(StopInstanceRequest stopInstanceRequest) {
        try {

            HttpResponseHandler<StopInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new StopInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<StopInstanceRequest, StopInstanceResponse>()
                    .withMarshaller(new StopInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a specified stack.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param stopStackRequest
     * @return A Java Future containing the result of the StopStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.StopStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StopStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopStackResponse> stopStack(StopStackRequest stopStackRequest) {
        try {

            HttpResponseHandler<StopStackResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new StopStackResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<StopStackRequest, StopStackResponse>()
                    .withMarshaller(new StopStackRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopStackRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Apply cost-allocation tags to a specified stack or layer in AWS OpsWorks Stacks. For more information about how
     * tagging works, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/tagging.html">Tags</a> in the
     * AWS OpsWorks User Guide.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new TagResourceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Unassigns a registered instance from all of it's layers. The instance remains in the stack as an unassigned
     * instance and can be assigned to another layer, as needed. You cannot use this action with instances that were
     * created with AWS OpsWorks Stacks.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param unassignInstanceRequest
     * @return A Java Future containing the result of the UnassignInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UnassignInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UnassignInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnassignInstanceResponse> unassignInstance(UnassignInstanceRequest unassignInstanceRequest) {
        try {

            HttpResponseHandler<UnassignInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UnassignInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UnassignInstanceRequest, UnassignInstanceResponse>()
                    .withMarshaller(new UnassignInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(unassignInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Unassigns an assigned Amazon EBS volume. The volume remains registered with the stack. For more information, see
     * <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param unassignVolumeRequest
     * @return A Java Future containing the result of the UnassignVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UnassignVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UnassignVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnassignVolumeResponse> unassignVolume(UnassignVolumeRequest unassignVolumeRequest) {
        try {

            HttpResponseHandler<UnassignVolumeResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UnassignVolumeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UnassignVolumeRequest, UnassignVolumeResponse>()
                    .withMarshaller(new UnassignVolumeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(unassignVolumeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a specified stack or layer.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UntagResourceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a specified app.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Deploy or Manage permissions level for
     * the stack, or an attached policy that explicitly grants permissions. For more information on user permissions,
     * see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param updateAppRequest
     * @return A Java Future containing the result of the UpdateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UpdateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAppResponse> updateApp(UpdateAppRequest updateAppRequest) {
        try {

            HttpResponseHandler<UpdateAppResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateAppResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UpdateAppRequest, UpdateAppResponse>()
                    .withMarshaller(new UpdateAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAppRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a registered Elastic IP address's name. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param updateElasticIpRequest
     * @return A Java Future containing the result of the UpdateElasticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UpdateElasticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateElasticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateElasticIpResponse> updateElasticIp(UpdateElasticIpRequest updateElasticIpRequest) {
        try {

            HttpResponseHandler<UpdateElasticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateElasticIpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UpdateElasticIpRequest, UpdateElasticIpResponse>()
                    .withMarshaller(new UpdateElasticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateElasticIpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a specified instance.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param updateInstanceRequest
     * @return A Java Future containing the result of the UpdateInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UpdateInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateInstanceResponse> updateInstance(UpdateInstanceRequest updateInstanceRequest) {
        try {

            HttpResponseHandler<UpdateInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UpdateInstanceRequest, UpdateInstanceResponse>()
                    .withMarshaller(new UpdateInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a specified layer.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param updateLayerRequest
     * @return A Java Future containing the result of the UpdateLayer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UpdateLayer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateLayer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLayerResponse> updateLayer(UpdateLayerRequest updateLayerRequest) {
        try {

            HttpResponseHandler<UpdateLayerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateLayerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UpdateLayerRequest, UpdateLayerResponse>()
                    .withMarshaller(new UpdateLayerRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateLayerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a user's SSH public key.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have self-management enabled or an attached
     * policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param updateMyUserProfileRequest
     * @return A Java Future containing the result of the UpdateMyUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UpdateMyUserProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateMyUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMyUserProfileResponse> updateMyUserProfile(
            UpdateMyUserProfileRequest updateMyUserProfileRequest) {
        try {

            HttpResponseHandler<UpdateMyUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateMyUserProfileResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UpdateMyUserProfileRequest, UpdateMyUserProfileResponse>()
                    .withMarshaller(new UpdateMyUserProfileRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(updateMyUserProfileRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon RDS instance.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param updateRdsDbInstanceRequest
     * @return A Java Future containing the result of the UpdateRdsDbInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UpdateRdsDbInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateRdsDbInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRdsDbInstanceResponse> updateRdsDbInstance(
            UpdateRdsDbInstanceRequest updateRdsDbInstanceRequest) {
        try {

            HttpResponseHandler<UpdateRdsDbInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateRdsDbInstanceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UpdateRdsDbInstanceRequest, UpdateRdsDbInstanceResponse>()
                    .withMarshaller(new UpdateRdsDbInstanceRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(updateRdsDbInstanceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a specified stack.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param updateStackRequest
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStackResponse> updateStack(UpdateStackRequest updateStackRequest) {
        try {

            HttpResponseHandler<UpdateStackResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateStackResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UpdateStackRequest, UpdateStackResponse>()
                    .withMarshaller(new UpdateStackRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateStackRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a specified user profile.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have an attached policy that explicitly grants
     * permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param updateUserProfileRequest
     * @return A Java Future containing the result of the UpdateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UpdateUserProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateUserProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserProfileResponse> updateUserProfile(UpdateUserProfileRequest updateUserProfileRequest) {
        try {

            HttpResponseHandler<UpdateUserProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateUserProfileResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UpdateUserProfileRequest, UpdateUserProfileResponse>()
                    .withMarshaller(new UpdateUserProfileRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateUserProfileRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon EBS volume's name or mount point. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html">Resource Management</a>.
     * </p>
     * <p>
     * <b>Required Permissions</b>: To use this action, an IAM user must have a Manage permissions level for the stack,
     * or an attached policy that explicitly grants permissions. For more information on user permissions, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>.
     * </p>
     *
     * @param updateVolumeRequest
     * @return A Java Future containing the result of the UpdateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Indicates that a request was not valid.</li>
     *         <li>ResourceNotFoundException Indicates that a resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpsWorksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpsWorksAsyncClient.UpdateVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVolumeResponse> updateVolume(UpdateVolumeRequest updateVolumeRequest) {
        try {

            HttpResponseHandler<UpdateVolumeResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateVolumeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<UpdateVolumeRequest, UpdateVolumeResponse>()
                    .withMarshaller(new UpdateVolumeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateVolumeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata()
                .withSupportsCbor(false)
                .withSupportsIon(false)
                .withBaseServiceExceptionClass(software.amazon.awssdk.services.opsworks.model.OpsWorksException.class)
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(
                                ResourceNotFoundException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(
                                ValidationException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1")
                .protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
