/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignInstanceRequest extends OpsWorksRequest implements
        ToCopyableBuilder<AssignInstanceRequest.Builder, AssignInstanceRequest> {
    private final String instanceId;

    private final List<String> layerIds;

    private AssignInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.layerIds = builder.layerIds;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a built-in
     * layer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a
     *         built-in layer.
     */
    public List<String> layerIds() {
        return layerIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(layerIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignInstanceRequest)) {
            return false;
        }
        AssignInstanceRequest other = (AssignInstanceRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(layerIds(), other.layerIds());
    }

    @Override
    public String toString() {
        return ToString.builder("AssignInstanceRequest").add("InstanceId", instanceId()).add("LayerIds", layerIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "LayerIds":
            return Optional.ofNullable(clazz.cast(layerIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, AssignInstanceRequest> {
        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a built-in
         * layer.
         * </p>
         * 
         * @param layerIds
         *        The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a
         *        built-in layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(Collection<String> layerIds);

        /**
         * <p>
         * The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a built-in
         * layer.
         * </p>
         * 
         * @param layerIds
         *        The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a
         *        built-in layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(String... layerIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<String> layerIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssignInstanceRequest model) {
            super(model);
            instanceId(model.instanceId);
            layerIds(model.layerIds);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getLayerIds() {
            return layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String... layerIds) {
            layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssignInstanceRequest build() {
            return new AssignInstanceRequest(this);
        }
    }
}
