/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCommandsRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeCommandsRequest.Builder, DescribeCommandsRequest> {
    private final String deploymentId;

    private final String instanceId;

    private final List<String> commandIds;

    private DescribeCommandsRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.instanceId = builder.instanceId;
        this.commandIds = builder.commandIds;
    }

    /**
     * <p>
     * The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
     * commands associated with the specified deployment.
     * </p>
     * 
     * @return The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of
     *         the commands associated with the specified deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
     * commands associated with the specified instance.
     * </p>
     * 
     * @return The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of
     *         the commands associated with the specified instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description of
     * the specified commands. Otherwise, it returns a description of every command.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a
     *         description of the specified commands. Otherwise, it returns a description of every command.
     */
    public List<String> commandIds() {
        return commandIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(commandIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommandsRequest)) {
            return false;
        }
        DescribeCommandsRequest other = (DescribeCommandsRequest) obj;
        return Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(commandIds(), other.commandIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeCommandsRequest").add("DeploymentId", deploymentId()).add("InstanceId", instanceId())
                .add("CommandIds", commandIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "CommandIds":
            return Optional.ofNullable(clazz.cast(commandIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DescribeCommandsRequest> {
        /**
         * <p>
         * The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
         * commands associated with the specified deployment.
         * </p>
         * 
         * @param deploymentId
         *        The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description
         *        of the commands associated with the specified deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
         * commands associated with the specified instance.
         * </p>
         * 
         * @param instanceId
         *        The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of
         *        the commands associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description
         * of the specified commands. Otherwise, it returns a description of every command.
         * </p>
         * 
         * @param commandIds
         *        An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a
         *        description of the specified commands. Otherwise, it returns a description of every command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandIds(Collection<String> commandIds);

        /**
         * <p>
         * An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description
         * of the specified commands. Otherwise, it returns a description of every command.
         * </p>
         * 
         * @param commandIds
         *        An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a
         *        description of the specified commands. Otherwise, it returns a description of every command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandIds(String... commandIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String deploymentId;

        private String instanceId;

        private List<String> commandIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommandsRequest model) {
            super(model);
            deploymentId(model.deploymentId);
            instanceId(model.instanceId);
            commandIds(model.commandIds);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getCommandIds() {
            return commandIds;
        }

        @Override
        public final Builder commandIds(Collection<String> commandIds) {
            this.commandIds = StringsCopier.copy(commandIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandIds(String... commandIds) {
            commandIds(Arrays.asList(commandIds));
            return this;
        }

        public final void setCommandIds(Collection<String> commandIds) {
            this.commandIds = StringsCopier.copy(commandIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCommandsRequest build() {
            return new DescribeCommandsRequest(this);
        }
    }
}
