/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeStacks</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStacksResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeStacksResponse.Builder, DescribeStacksResponse> {
    private final List<Stack> stacks;

    private DescribeStacksResponse(BuilderImpl builder) {
        super(builder);
        this.stacks = builder.stacks;
    }

    /**
     * <p>
     * An array of <code>Stack</code> objects that describe the stacks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Stack</code> objects that describe the stacks.
     */
    public List<Stack> stacks() {
        return stacks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stacks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResponse)) {
            return false;
        }
        DescribeStacksResponse other = (DescribeStacksResponse) obj;
        return Objects.equals(stacks(), other.stacks());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeStacksResponse").add("Stacks", stacks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stacks":
            return Optional.ofNullable(clazz.cast(stacks()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeStacksResponse> {
        /**
         * <p>
         * An array of <code>Stack</code> objects that describe the stacks.
         * </p>
         * 
         * @param stacks
         *        An array of <code>Stack</code> objects that describe the stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stacks(Collection<Stack> stacks);

        /**
         * <p>
         * An array of <code>Stack</code> objects that describe the stacks.
         * </p>
         * 
         * @param stacks
         *        An array of <code>Stack</code> objects that describe the stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stacks(Stack... stacks);

        /**
         * <p>
         * An array of <code>Stack</code> objects that describe the stacks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Stack>.Builder} avoiding the need to create
         * one manually via {@link List<Stack>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Stack>.Builder#build()} is called immediately and its result
         * is passed to {@link #stacks(List<Stack>)}.
         * 
         * @param stacks
         *        a consumer that will call methods on {@link List<Stack>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stacks(List<Stack>)
         */
        Builder stacks(Consumer<Stack.Builder>... stacks);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<Stack> stacks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksResponse model) {
            super(model);
            stacks(model.stacks);
        }

        public final Collection<Stack.Builder> getStacks() {
            return stacks != null ? stacks.stream().map(Stack::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Stack... stacks) {
            stacks(Arrays.asList(stacks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Consumer<Stack.Builder>... stacks) {
            stacks(Stream.of(stacks).map(c -> Stack.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStacks(Collection<Stack.BuilderImpl> stacks) {
            this.stacks = StacksCopier.copyFromBuilder(stacks);
        }

        @Override
        public DescribeStacksResponse build() {
            return new DescribeStacksResponse(this);
        }
    }
}
