/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachElasticLoadBalancerRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DetachElasticLoadBalancerRequest.Builder, DetachElasticLoadBalancerRequest> {
    private final String elasticLoadBalancerName;

    private final String layerId;

    private DetachElasticLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.elasticLoadBalancerName = builder.elasticLoadBalancerName;
        this.layerId = builder.layerId;
    }

    /**
     * <p>
     * The Elastic Load Balancing instance's name.
     * </p>
     * 
     * @return The Elastic Load Balancing instance's name.
     */
    public String elasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * <p>
     * The ID of the layer that the Elastic Load Balancing instance is attached to.
     * </p>
     * 
     * @return The ID of the layer that the Elastic Load Balancing instance is attached to.
     */
    public String layerId() {
        return layerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticLoadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachElasticLoadBalancerRequest)) {
            return false;
        }
        DetachElasticLoadBalancerRequest other = (DetachElasticLoadBalancerRequest) obj;
        return Objects.equals(elasticLoadBalancerName(), other.elasticLoadBalancerName())
                && Objects.equals(layerId(), other.layerId());
    }

    @Override
    public String toString() {
        return ToString.builder("DetachElasticLoadBalancerRequest").add("ElasticLoadBalancerName", elasticLoadBalancerName())
                .add("LayerId", layerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticLoadBalancerName":
            return Optional.ofNullable(clazz.cast(elasticLoadBalancerName()));
        case "LayerId":
            return Optional.ofNullable(clazz.cast(layerId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DetachElasticLoadBalancerRequest> {
        /**
         * <p>
         * The Elastic Load Balancing instance's name.
         * </p>
         * 
         * @param elasticLoadBalancerName
         *        The Elastic Load Balancing instance's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancerName(String elasticLoadBalancerName);

        /**
         * <p>
         * The ID of the layer that the Elastic Load Balancing instance is attached to.
         * </p>
         * 
         * @param layerId
         *        The ID of the layer that the Elastic Load Balancing instance is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String elasticLoadBalancerName;

        private String layerId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachElasticLoadBalancerRequest model) {
            super(model);
            elasticLoadBalancerName(model.elasticLoadBalancerName);
            layerId(model.layerId);
        }

        public final String getElasticLoadBalancerName() {
            return elasticLoadBalancerName;
        }

        @Override
        public final Builder elasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
            return this;
        }

        public final void setElasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachElasticLoadBalancerRequest build() {
            return new DetachElasticLoadBalancerRequest(this);
        }
    }
}
