/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.EnvironmentVariableMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an app's environment variable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentVariable implements StructuredPojo,
        ToCopyableBuilder<EnvironmentVariable.Builder, EnvironmentVariable> {
    private final String key;

    private final String value;

    private final Boolean secure;

    private EnvironmentVariable(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.secure = builder.secure;
    }

    /**
     * <p>
     * (Required) The environment variable's name, which can consist of up to 64 characters and must be specified. The
     * name can contain upper- and lowercase letters, numbers, and underscores (_), but it must start with a letter or
     * underscore.
     * </p>
     * 
     * @return (Required) The environment variable's name, which can consist of up to 64 characters and must be
     *         specified. The name can contain upper- and lowercase letters, numbers, and underscores (_), but it must
     *         start with a letter or underscore.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * (Optional) The environment variable's value, which can be left empty. If you specify a value, it can contain up
     * to 256 characters, which must all be printable.
     * </p>
     * 
     * @return (Optional) The environment variable's value, which can be left empty. If you specify a value, it can
     *         contain up to 256 characters, which must all be printable.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * (Optional) Whether the variable's value will be returned by the <a>DescribeApps</a> action. To conceal an
     * environment variable's value, set <code>Secure</code> to <code>true</code>. <code>DescribeApps</code> then
     * returns <code>*****FILTERED*****</code> instead of the actual value. The default value for <code>Secure</code> is
     * <code>false</code>.
     * </p>
     * 
     * @return (Optional) Whether the variable's value will be returned by the <a>DescribeApps</a> action. To conceal an
     *         environment variable's value, set <code>Secure</code> to <code>true</code>. <code>DescribeApps</code>
     *         then returns <code>*****FILTERED*****</code> instead of the actual value. The default value for
     *         <code>Secure</code> is <code>false</code>.
     */
    public Boolean secure() {
        return secure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(secure());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentVariable)) {
            return false;
        }
        EnvironmentVariable other = (EnvironmentVariable) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(secure(), other.secure());
    }

    @Override
    public String toString() {
        return ToString.builder("EnvironmentVariable").add("Key", key()).add("Value", value()).add("Secure", secure()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Secure":
            return Optional.ofNullable(clazz.cast(secure()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentVariableMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EnvironmentVariable> {
        /**
         * <p>
         * (Required) The environment variable's name, which can consist of up to 64 characters and must be specified.
         * The name can contain upper- and lowercase letters, numbers, and underscores (_), but it must start with a
         * letter or underscore.
         * </p>
         * 
         * @param key
         *        (Required) The environment variable's name, which can consist of up to 64 characters and must be
         *        specified. The name can contain upper- and lowercase letters, numbers, and underscores (_), but it
         *        must start with a letter or underscore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * (Optional) The environment variable's value, which can be left empty. If you specify a value, it can contain
         * up to 256 characters, which must all be printable.
         * </p>
         * 
         * @param value
         *        (Optional) The environment variable's value, which can be left empty. If you specify a value, it can
         *        contain up to 256 characters, which must all be printable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * (Optional) Whether the variable's value will be returned by the <a>DescribeApps</a> action. To conceal an
         * environment variable's value, set <code>Secure</code> to <code>true</code>. <code>DescribeApps</code> then
         * returns <code>*****FILTERED*****</code> instead of the actual value. The default value for
         * <code>Secure</code> is <code>false</code>.
         * </p>
         * 
         * @param secure
         *        (Optional) Whether the variable's value will be returned by the <a>DescribeApps</a> action. To conceal
         *        an environment variable's value, set <code>Secure</code> to <code>true</code>.
         *        <code>DescribeApps</code> then returns <code>*****FILTERED*****</code> instead of the actual value.
         *        The default value for <code>Secure</code> is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secure(Boolean secure);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private Boolean secure;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentVariable model) {
            key(model.key);
            value(model.value);
            secure(model.secure);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Boolean getSecure() {
            return secure;
        }

        @Override
        public final Builder secure(Boolean secure) {
            this.secure = secure;
            return this;
        }

        public final void setSecure(Boolean secure) {
            this.secure = secure;
        }

        @Override
        public EnvironmentVariable build() {
            return new EnvironmentVariable(this);
        }
    }
}
